/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore.filesystem;

import eu.dnetlib.data.objectstore.filesystem.FileSystemUtility;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreServiceException;
import eu.dnetlib.miscutils.datetime.HumanTime;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ModularObjectStoreRESTService {
    private static final Log log = LogFactory.getLog(ModularObjectStoreRESTService.class);

    public static String retrieveURL(String baseURI, String basePath, String objectStoreId, String objectId) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder(baseURI).append("?objectStore=" + ModularObjectStoreRESTService.encode(objectStoreId)).append("&objectId=" + ModularObjectStoreRESTService.encode(objectId)).append("&basePath=" + ModularObjectStoreRESTService.encode(basePath));
        return sb.toString();
    }

    private static String encode(String s) throws UnsupportedEncodingException {
        return URLEncoder.encode(s, "UTF-8");
    }

    @RequestMapping(value={"/**/objectStore/retrieve.do"})
    public void retrieve(HttpServletResponse res, @RequestParam(value="basePath", required=true) String basePath, @RequestParam(value="objectStore", required=true) String objectStoreId, @RequestParam(value="objectId", required=true) String objectId) throws IOException, ObjectStoreServiceException {
        long start = System.currentTimeMillis();
        Path path = FileSystemUtility.objectStoreFilePath(basePath, objectStoreId, objectId);
        if (!Files.exists(path, new LinkOption[0]) || !Files.isReadable(path)) {
            String msg = String.format("Object with identifier: %s not found the in %s", objectId, path);
            res.sendError(404, msg);
            log.warn((Object)msg);
        } else {
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(path.toFile()));){
                long size = Files.size(path);
                res.setHeader("Content-Length", String.valueOf(size));
                IOUtils.copyLarge((InputStream)is, (OutputStream)res.getOutputStream());
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("retrive.do completed in %s, objId: %s", HumanTime.exactly((long)(System.currentTimeMillis() - start)), objectId));
                }
            }
            catch (IOException e) {
                String msg = "unable to close input Stream";
                res.sendError(500, "unable to close input Stream");
                log.error((Object)"unable to close input Stream", (Throwable)e);
            }
        }
    }
}

