/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore.filesystem;

import com.google.common.collect.Lists;
import com.mongodb.DBObject;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Sorts;
import eu.dnetlib.data.objectstore.filesystem.ObjectStoreFileUtility;
import eu.dnetlib.enabling.resultset.ResultSet;
import eu.dnetlib.enabling.resultset.ResultSetAware;
import eu.dnetlib.enabling.resultset.ResultSetListener;
import eu.dnetlib.miscutils.collections.MappedCollection;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.conversions.Bson;

public class FileSystemObjectStoreResultSetListener
implements ResultSetListener,
ResultSetAware {
    private static final Log log = LogFactory.getLog(FileSystemObjectStoreResultSetListener.class);
    private Long fromDate;
    private Long untilDate;
    private List<String> records;
    private String objectStoreID;
    private MongoCollection<DBObject> mongoCollection;
    private String baseURI;
    private String basePath;
    private int currentSize = -1;
    private MongoCursor<DBObject> currentCursor;
    private long cursorPosition;

    public List<String> getResult(int from, int to) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("ObjectStoreId :%s, from: %d, to: %d", this.objectStoreID, from, to));
        }
        if (this.records != null) {
            ArrayList ids = Lists.newArrayList();
            for (int i = from - 1; i < Math.min(this.records.size(), to); ++i) {
                ids.add(this.records.get(i));
            }
            Bson q = Filters.in((String)"id", (Iterable)ids);
            FindIterable res = this.getMongoCollection().find(q);
            return MappedCollection.listMap((Iterable)res, ObjectStoreFileUtility.asJSON(this.getBaseURI(), this.getObjectStoreID(), this.getBasePath()));
        }
        if (this.fromDate != null && this.untilDate != null) {
            if (this.currentCursor == null || this.cursorPosition > (long)from) {
                this.createCurrentCursor();
            }
            while (this.cursorPosition < (long)from) {
                this.currentCursor.next();
                ++this.cursorPosition;
            }
            ArrayList result = Lists.newArrayList();
            for (int i = from; i <= to; ++i) {
                if (!this.currentCursor.hasNext()) continue;
                result.add(this.currentCursor.next());
                ++this.cursorPosition;
            }
            return MappedCollection.listMap((Iterable)result, ObjectStoreFileUtility.asJSON(this.getBaseURI(), this.getObjectStoreID(), this.getBasePath()));
        }
        throw new IllegalArgumentException("Missing parameters on Delivery must provide either from, to, or ObjectStoreIDs");
    }

    private void createCurrentCursor() {
        Bson timestampQuery = Filters.and((Bson[])new Bson[]{Filters.gt((String)"timestamp", (Object)this.fromDate.doubleValue()), Filters.lt((String)"timestamp", (Object)this.untilDate.doubleValue())});
        if (this.currentCursor != null) {
            this.currentCursor.close();
        }
        this.currentCursor = this.getMongoCollection().find(timestampQuery).sort(Sorts.orderBy((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)1)})).iterator();
        this.cursorPosition = 1L;
    }

    public int getSize() {
        if (this.currentSize == -1) {
            this.currentSize = this.calculateSize();
        }
        return Math.max(0, this.currentSize - 1);
    }

    private int calculateSize() {
        if (this.records != null) {
            Bson query = Filters.in((String)"id", this.records);
            return (int)this.getMongoCollection().count(query);
        }
        if (this.fromDate != null && this.untilDate != null) {
            Bson timestampQuery = Filters.and((Bson[])new Bson[]{Filters.gt((String)"timestamp", (Object)this.fromDate.doubleValue()), Filters.lt((String)"timestamp", (Object)this.untilDate.doubleValue())});
            return (int)this.getMongoCollection().count(timestampQuery);
        }
        return 0;
    }

    public void setResultSet(ResultSet resultSet) {
        resultSet.close();
    }

    public Long getFromDate() {
        return this.fromDate;
    }

    public FileSystemObjectStoreResultSetListener setFromDate(Long fromDate) {
        this.fromDate = fromDate;
        return this;
    }

    public Long getUntilDate() {
        return this.untilDate;
    }

    public FileSystemObjectStoreResultSetListener setUntilDate(Long untilDate) {
        this.untilDate = untilDate;
        return this;
    }

    public List<String> getRecords() {
        return this.records;
    }

    public void setRecords(List<String> records) {
        this.records = records;
    }

    public String getObjectStoreID() {
        return this.objectStoreID;
    }

    public void setObjectStoreID(String objectStoreID) {
        this.objectStoreID = objectStoreID;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public int getCurrentSize() {
        return this.currentSize;
    }

    public void setCurrentSize(int currentSize) {
        this.currentSize = currentSize;
    }

    public MongoCursor<DBObject> getCurrentCursor() {
        return this.currentCursor;
    }

    public void setCurrentCursor(MongoCursor<DBObject> currentCursor) {
        this.currentCursor = currentCursor;
    }

    public long getCursorPosition() {
        return this.cursorPosition;
    }

    public void setCursorPosition(long cursorPosition) {
        this.cursorPosition = cursorPosition;
    }

    public MongoCollection<DBObject> getMongoCollection() {
        return this.mongoCollection;
    }

    public void setMongoCollection(MongoCollection<DBObject> mongoCollection) {
        this.mongoCollection = mongoCollection;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }
}

