/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.gtr2;

import eu.dnetlib.data.collector.plugins.gtr2.AbstractGtr2CollectorPlugin;
import eu.dnetlib.data.collector.plugins.gtr2.Gtr2Iterator;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class Gtr2PublicationsCollectorPlugin
extends AbstractGtr2CollectorPlugin {
    @Override
    protected Iterator<String> createIterator(String baseUrl, String fromDate, String startPage, String endPage) throws CollectorServiceException {
        return new Gtr2Iterator(baseUrl, fromDate, startPage, endPage){

            @Override
            protected String urlForPage(String baseUrl, int pageNumber) {
                return baseUrl + "/outcomes/publications?p=" + pageNumber;
            }

            @Override
            protected String xpathForEntity() {
                return "//*[local-name() = 'publication']";
            }

            @Override
            protected String expandMainEntity(Element mainEntity) {
                Element newRoot = DocumentHelper.createElement((String)"doc");
                newRoot.add(mainEntity);
                this.addLinkedEntities(mainEntity, "PROJECT", newRoot, o -> this.asProjectElement((Document)o));
                return DocumentHelper.createDocument((Element)newRoot).asXML();
            }

            private Element asProjectElement(Document doc) {
                Element newOrg = DocumentHelper.createElement((String)"project");
                newOrg.addElement("id").setText(doc.valueOf("/*/@*[local-name()='id']"));
                newOrg.addElement("code").setText(doc.valueOf("//*[local-name()='identifier' and @*[local-name()='type'] = 'RCUK']"));
                newOrg.addElement("title").setText(doc.valueOf("//*[local-name()='title']"));
                return newOrg;
            }
        };
    }
}

