/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.gtr2;

import eu.dnetlib.data.collector.plugins.gtr2.Gtr2ApiResponse;
import eu.dnetlib.data.collector.plugins.gtr2.Gtr2Helper;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.CollectorServiceRuntimeException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.Function;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.joda.time.DateTime;

public abstract class Gtr2Iterator
implements Iterator<String> {
    public static final int PAGE_SIZE = 20;
    private static final Log log = LogFactory.getLog(Gtr2Iterator.class);
    private final String baseUrl;
    private int currPage;
    private int endPage;
    private boolean incremental = false;
    private DateTime fromDate;
    private final Map<String, String> cache = new HashMap<String, String>();
    private final Queue<String> queue = new LinkedList<String>();
    private String nextElement;

    public Gtr2Iterator(String baseUrl, String fromDate, String startPage, String endPage) throws CollectorServiceException {
        this.baseUrl = baseUrl;
        this.currPage = NumberUtils.toInt((String)startPage, (int)1);
        this.endPage = NumberUtils.toInt((String)endPage, (int)Integer.MAX_VALUE);
        this.incremental = StringUtils.isNotBlank((CharSequence)fromDate);
        if (this.incremental) {
            this.fromDate = Gtr2Helper.parseDate(fromDate);
        }
        this.prepareNextElement();
    }

    @Override
    public boolean hasNext() {
        return this.nextElement != null;
    }

    @Override
    public String next() {
        try {
            String string = this.nextElement;
            return string;
        }
        finally {
            this.prepareNextElement();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void prepareNextElement() {
        while (this.currPage <= this.endPage && this.queue.isEmpty()) {
            log.debug((Object)("FETCHING PAGE + " + this.currPage + "/" + this.endPage));
            this.queue.addAll(this.fetchPage(this.currPage++));
        }
        this.nextElement = this.queue.poll();
    }

    private List<String> fetchPage(int pageNumber) {
        ArrayList<String> res = new ArrayList<String>();
        try {
            Gtr2ApiResponse urlResponse = Gtr2Helper.loadURL(this.urlForPage(this.baseUrl, pageNumber));
            Document doc = urlResponse.getDocument();
            if (this.endPage == Integer.MAX_VALUE) {
                for (Header header : urlResponse.getHeaders()) {
                    log.debug((Object)("HEADER: " + header.getName() + " = " + header.getValue()));
                    if (!"Link-Pages".equalsIgnoreCase(header.getName()) || Integer.parseInt(header.getValue()) >= this.endPage) continue;
                    this.endPage = Integer.parseInt(header.getValue());
                }
            }
            for (Object po : doc.selectNodes(this.xpathForEntity())) {
                Element mainEntity = (Element)((Element)po).detach();
                if (this.filterIncremental(mainEntity)) {
                    res.add(this.expandMainEntity(mainEntity));
                    continue;
                }
                log.debug((Object)"Skipped entity");
            }
        }
        catch (Throwable e) {
            log.error((Object)("Exception fetching page " + pageNumber), e);
            throw new CollectorServiceRuntimeException("Exception fetching page " + pageNumber, e);
        }
        return res;
    }

    protected void addLinkedEntities(Element master, String relType, Element newRoot, Function<Document, Element> mapper) {
        for (Object o : master.selectNodes(".//*[local-name()='link']")) {
            String rel = ((Element)o).valueOf("@*[local-name()='rel']");
            String href = ((Element)o).valueOf("@*[local-name()='href']");
            if (!relType.equals(rel) || !StringUtils.isNotBlank((CharSequence)href)) continue;
            String cacheKey = relType + "#" + href;
            if (this.cache.containsKey(cacheKey)) {
                try {
                    log.debug((Object)(" * from cache (" + relType + "): " + href));
                    newRoot.add(DocumentHelper.parseText((String)this.cache.get(cacheKey)).getRootElement());
                    continue;
                }
                catch (DocumentException e) {
                    log.error((Object)("Error retrieving cache element: " + cacheKey), (Throwable)e);
                    throw new CollectorServiceRuntimeException("Error retrieving cache element: " + cacheKey, (Throwable)e);
                }
            }
            try {
                Document doc = Gtr2Helper.loadURL(href).getDocument();
                Element elem = mapper.apply(doc);
                newRoot.add(elem);
                this.cache.put(cacheKey, elem.asXML());
            }
            catch (Throwable e) {
                log.warn((Object)("Invalid url: " + href));
            }
        }
    }

    private boolean filterIncremental(Element e) {
        if (!this.incremental) {
            return true;
        }
        if (Gtr2Helper.isAfter(e.valueOf("@*[local-name() = 'created']"), this.fromDate)) {
            return true;
        }
        return Gtr2Helper.isAfter(e.valueOf("@*[local-name() = 'updated']"), this.fromDate);
    }

    protected abstract String expandMainEntity(Element var1);

    protected abstract String urlForPage(String var1, int var2);

    protected abstract String xpathForEntity();
}

