package eu.dnetlib.data.collector.plugins.fairsharing;

import java.io.UnsupportedEncodingException;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.json.JSONObject;

import eu.dnetlib.data.collector.plugin.AbstractCollectorPlugin;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;

public class FairSharingPlugin extends AbstractCollectorPlugin {

	private static final int PAGE_SIZE = 100;

	private static final Log log = LogFactory.getLog(FairSharingPlugin.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Override
	public Iterable<String> collect(final InterfaceDescriptor interfaceDescriptor, final String fromDate, final String untilDate)
		throws CollectorServiceException {

		// It should be https://api.fairsharing.org
		final String baseUrl = interfaceDescriptor.getBaseUrl();
		final String login = interfaceDescriptor.getParams().get("login");
		final String password = interfaceDescriptor.getParams().get("password");

		final String authCode = login(baseUrl, login, password);

		log.debug("authCode: " + authCode);

		if (StringUtils.isBlank(authCode)) { throw new CollectorServiceException("Authorization failed: authCode is empty"); }

		return () -> new FairSharingIterator(baseUrl, authCode, PAGE_SIZE);
	}

	private String login(final String baseUrl, final String login, final String password) throws CollectorServiceException {
		final HttpPost req = new HttpPost(baseUrl + "/users/sign_in");
		req.addHeader("Accept", "application/json");
		req.addHeader("Content-Type", "application/json");
		req.setEntity(prepareCredentials(login, password));

		try (final CloseableHttpClient client = HttpClients.createDefault()) {
			try (final CloseableHttpResponse response = client.execute(req)) {
				final String content = IOUtils.toString(response.getEntity().getContent());
				final JSONObject obj = new JSONObject(content);
				return obj.getString("jwt");
			}
		} catch (final Exception e) {
			throw new CollectorServiceException("Error perfoming call fro login", e);
		}
	}

	public HttpEntity prepareCredentials(final String login, final String password) throws CollectorServiceException {

		final JSONObject objUser = new JSONObject();
		objUser.put("login", login);
		objUser.put("password", password);

		final JSONObject objCredentials = new JSONObject();
		objCredentials.put("user", objUser);

		try {
			return new StringEntity(objCredentials.toString());
		} catch (final UnsupportedEncodingException e) {
			throw new CollectorServiceException("Error preparing http entity for login");
		}
	}

}
