/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.opentrial;

import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.CollectorServiceRuntimeException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.XML;

public class OpenTrialIterator
implements Iterable<String> {
    private final String base_url;
    private int total;
    private ArrayBlockingQueue<String> trials = new ArrayBlockingQueue(100);
    private int current = 0;
    private static final Log log = LogFactory.getLog(OpenTrialIterator.class);

    public OpenTrialIterator(String base_url, String from_date, String to_date) throws CollectorServiceException {
        try {
            String q = "per_page=100";
            if (from_date != null) {
                q = to_date != null ? "q=registration_date%3A%5B" + from_date + "%20TO%20" + to_date + "%5D&" + q : "q=registration_date%3A%5B" + from_date + "%20TO%20*%5D&" + q;
            }
            this.base_url = base_url + q;
            log.info((Object)("url from which to collect " + this.base_url));
            this.prepare();
        }
        catch (Exception ex) {
            throw new CollectorServiceException((Throwable)ex);
        }
    }

    private void prepare() throws Exception {
        JSONObject json = new JSONObject(this.getPage(1));
        this.total = json.getInt("total_count");
        log.info((Object)("Total number of entries to collect: " + this.total));
        this.fillTrials(json);
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private int page_number = 2;

            @Override
            public void remove() {
            }

            @Override
            public String next() {
                try {
                    if (OpenTrialIterator.this.trials.isEmpty()) {
                        JSONObject json = new JSONObject(OpenTrialIterator.this.getPage(this.page_number));
                        OpenTrialIterator.this.fillTrials(json);
                        ++this.page_number;
                    }
                    return (String)OpenTrialIterator.this.trials.poll();
                }
                catch (Exception ex) {
                    throw new CollectorServiceRuntimeException((Throwable)ex);
                }
            }

            @Override
            public boolean hasNext() {
                log.debug((Object)("More entries to collect: (" + OpenTrialIterator.this.current + "<" + OpenTrialIterator.this.total + "=" + (OpenTrialIterator.this.current < OpenTrialIterator.this.total)));
                return OpenTrialIterator.this.current < OpenTrialIterator.this.total || !OpenTrialIterator.this.trials.isEmpty();
            }
        };
    }

    private void fillTrials(JSONObject json) throws CollectorServiceException {
        JSONArray entries = json.getJSONArray("items");
        for (Object entry : entries) {
            try {
                this.trials.put(XML.toString(entry));
            }
            catch (Exception ex) {
                throw new CollectorServiceException((Throwable)ex);
            }
            ++this.current;
        }
    }

    private String getPage(int page_number) throws CollectorServiceException {
        try {
            URL url = new URL(this.base_url + "&page=" + page_number);
            URLConnection conn = url.openConnection();
            conn.setRequestProperty("User-Agent", "Mozilla/5.0");
            return IOUtils.toString((InputStream)conn.getInputStream());
        }
        catch (Exception ex) {
            throw new CollectorServiceException((Throwable)ex);
        }
    }
}

