/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.actionmanager;

import eu.dnetlib.actionmanager.is.ISClient;
import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import eu.dnetlib.actionmanager.rmi.ActionManagerService;
import eu.dnetlib.actionmanager.set.ActionManagerSet;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.rmi.HadoopService;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.enabling.tools.blackboard.NotificationHandler;
import java.util.List;
import javax.jws.WebParam;
import org.apache.hadoop.fs.Path;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class ActionManagerServiceImpl
extends AbstractBaseService
implements ActionManagerService {
    private NotificationHandler notificationHandler;
    @Autowired
    private ISClient isClient;
    @Autowired
    private UniqueServiceLocator serviceLocator;

    public String createSet(@WebParam(name="set") ActionManagerSet set) throws ActionManagerException {
        try {
            String basePath = this.isClient.getBasePathHDFS();
            Path actionSetPath = new Path(basePath + "/" + set.getId());
            ((HadoopService)this.serviceLocator.getService(HadoopService.class)).createHdfsDirectory(ClusterName.DM.toString(), actionSetPath.toString(), true);
            return this.isClient.registerSetProfile(set);
        }
        catch (HadoopServiceException e) {
            throw new ActionManagerException((Throwable)e);
        }
    }

    public boolean deleteSet(@WebParam(name="set") String setId) throws ActionManagerException {
        try {
            String basePath = this.isClient.getBasePathHDFS();
            Path actionSetPath = new Path(basePath + "/" + setId);
            ((HadoopService)this.serviceLocator.getService(HadoopService.class)).deleteHdfsPath(ClusterName.DM.toString(), actionSetPath.toString());
            return this.isClient.deleteSetProfile(setId);
        }
        catch (HadoopServiceException e) {
            throw new ActionManagerException((Throwable)e);
        }
    }

    public List<ActionManagerSet> ListSets() throws ActionManagerException {
        return this.isClient.listValidSets();
    }

    public void notify(String subscriptionId, String topic, String isId, String message) {
        this.notificationHandler.notified(subscriptionId, topic, isId, message);
    }

    public NotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }

    @Required
    public void setNotificationHandler(NotificationHandler notificationHandler) {
        this.notificationHandler = notificationHandler;
    }
}

