package eu.dnetlib.actionmanager.blackboard;

import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import eu.dnetlib.enabling.tools.blackboard.AbstractBlackboardJobListener;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BlackboardJobListener extends AbstractBlackboardJobListener {

	private static final Log log = LogFactory.getLog(BlackboardJobListener.class);

	private JobCallback callback;

	public BlackboardJobListener(final JobCallback callback) {
		super();
		this.callback = callback;
	}

	@Override
	protected void onDone(final BlackboardJob job) {
		try {
			if (callback != null) {
				callback.onDone(job.getParameters());
			}
		} catch (Exception e) {
			log.error("fail to run a callback function");
		}
	}

	@Override
	protected void onFailed(final BlackboardJob job) {
		try {
			if (callback != null) {
				callback.onFailed(new ActionManagerException(job.getError()));
			}
		} catch (Exception e) {
			log.error("fail to run a callback function");
		}
	}
}
