/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.actionmanager.actions;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.actionmanager.actions.AbstractActionSerializer;
import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.miscutils.functional.hash.Hashing;
import java.lang.reflect.Type;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AtomicActionSerialiser
extends AbstractActionSerializer
implements JsonSerializer<AtomicAction> {
    private static final Log log = LogFactory.getLog(AtomicActionSerialiser.class);

    public JsonElement serialize(AtomicAction aa, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        json.addProperty("TargetColumn", aa.getTargetColumn());
        json.addProperty("TargetColumnFamily", aa.getTargetColumnFamily());
        json.addProperty("TargetRowKey", aa.getTargetRowKey());
        json.addProperty("RawSet", aa.getRawSet());
        json.addProperty("RowKey", aa.getRowKey());
        json.addProperty("ActionType", aa.getActionType().toString());
        json.add("Agent", this.getAgentJSON(aa));
        json.addProperty("TargetValue", Hashing.encodeBase64((String)this.getTargetValueJSON(aa)));
        return json;
    }

    private JsonElement getAgentJSON(AtomicAction aa) {
        Agent a = aa.getAgent();
        JsonObject json = new JsonObject();
        json.addProperty("Agent.Id", a.getId());
        json.addProperty("Agent.name", a.getName());
        json.addProperty("Agent.type", a.getType().toString());
        return json;
    }

    private String getTargetValueJSON(AtomicAction aa) {
        try {
            return aa.getTargetValue() != null && aa.getTargetValue().length > 0 ? JsonFormat.printToString((Message)OafProtos.Oaf.parseFrom((byte[])aa.getTargetValue())) : "";
        }
        catch (InvalidProtocolBufferException e) {
            log.error((Object)"unable to parse proto", (Throwable)e);
            return null;
        }
    }
}

