/*
 * Decompiled with CFR 0.152.
 */
package com.coxautodata.utils;

import com.coxautodata.SparkDistCPOptions;
import com.coxautodata.objects.CopyActionResult;
import com.coxautodata.objects.CopyActionResult$Copied$;
import com.coxautodata.objects.CopyActionResult$Created$;
import com.coxautodata.objects.CopyActionResult$OverwrittenOrUpdated$;
import com.coxautodata.objects.CopyActionResult$SkippedAlreadyExists$;
import com.coxautodata.objects.CopyActionResult$SkippedDryRun$;
import com.coxautodata.objects.CopyActionResult$SkippedIdenticalFileAlreadyExists$;
import com.coxautodata.objects.DeleteActionResult;
import com.coxautodata.objects.DeleteActionResult$Deleted$;
import com.coxautodata.objects.DeleteActionResult$SkippedDoesNotExists$;
import com.coxautodata.objects.DeleteActionResult$SkippedDryRun$;
import com.coxautodata.objects.DeleteResult;
import com.coxautodata.objects.DirectoryCopyResult;
import com.coxautodata.objects.DistCPResult;
import com.coxautodata.objects.FileCopyResult;
import com.coxautodata.objects.Logging;
import com.coxautodata.objects.SerializableFileStatus;
import com.coxautodata.objects.SerializableFileStatus$;
import com.coxautodata.objects.SingleCopyDefinition;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class CopyUtils$
implements Logging {
    public static final CopyUtils$ MODULE$ = new CopyUtils$();
    private static Logger com$coxautodata$objects$Logging$$log;

    static {
        Logging.$init$(MODULE$);
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void setLogLevel(Level level) {
        Logging.setLogLevel$(this, level);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public Logger com$coxautodata$objects$Logging$$log() {
        return com$coxautodata$objects$Logging$$log;
    }

    @Override
    public final void com$coxautodata$objects$Logging$_setter_$com$coxautodata$objects$Logging$$log_$eq(Logger x$1) {
        com$coxautodata$objects$Logging$$log = x$1;
    }

    public DistCPResult handleCopy(FileSystem sourceFS, FileSystem destFS, SingleCopyDefinition definition, SparkDistCPOptions options, long taskAttemptID) {
        Product product;
        if (options.verbose()) {
            this.setLogLevel(Level.DEBUG);
        }
        if (definition.source().isDirectory()) {
            product = this.createDirectory(destFS, definition, options);
        } else if (definition.source().isFile()) {
            product = this.copyFile(sourceFS, destFS, definition, options, taskAttemptID);
        } else {
            throw new UnsupportedOperationException("Given file is neither file nor directory. Copy unsupported: " + definition.source().getPath());
        }
        DirectoryCopyResult r = product;
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> r.getMessage());
        return r;
    }

    public DeleteResult handleDelete(FileSystem fs, URI uri, SparkDistCPOptions options) {
        if (options.verbose()) {
            this.setLogLevel(Level.DEBUG);
        }
        Path path = new Path(uri);
        DeleteResult r = this.deleteFile(fs, path, options);
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> r.getMessage());
        return r;
    }

    public DeleteResult deleteFile(FileSystem fs, Path path, SparkDistCPOptions options) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        if (!fs.exists(path)) {
            return new DeleteResult(path.toUri(), DeleteActionResult$SkippedDoesNotExists$.MODULE$);
        }
        if (options.dryRun()) {
            return new DeleteResult(path.toUri(), DeleteActionResult$SkippedDryRun$.MODULE$);
        }
        boolean bl4 = false;
        Success success = null;
        boolean bl5 = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> fs.delete(path, true));
        if (try_ instanceof Success) {
            bl4 = true;
            success = (Success)try_;
            boolean bl6 = BoxesRunTime.unboxToBoolean((Object)success.value());
            if (bl6) {
                return new DeleteResult(path.toUri(), DeleteActionResult$Deleted$.MODULE$);
            }
        }
        if (bl4 && !(bl3 = BoxesRunTime.unboxToBoolean((Object)success.value())) && !fs.exists(path)) {
            return new DeleteResult(path.toUri(), DeleteActionResult$SkippedDoesNotExists$.MODULE$);
        }
        if (bl4 && !(bl2 = BoxesRunTime.unboxToBoolean((Object)success.value())) && options.ignoreErrors()) {
            return new DeleteResult(path.toUri(), new DeleteActionResult.Failed(new RuntimeException("Failed to delete directory [" + path + "].")));
        }
        if (bl4 && !(bl = BoxesRunTime.unboxToBoolean((Object)success.value()))) {
            throw new RuntimeException("Failed to delete directory [" + path + "].");
        }
        if (try_ instanceof Failure) {
            bl5 = true;
            failure = (Failure)try_;
            Throwable e = failure.exception();
            if (options.ignoreErrors()) {
                return new DeleteResult(path.toUri(), new DeleteActionResult.Failed(e));
            }
        }
        if (bl5) {
            Throwable e = failure.exception();
            throw e;
        }
        throw new MatchError((Object)try_);
    }

    public DirectoryCopyResult createDirectory(FileSystem destFS, SingleCopyDefinition definition, SparkDistCPOptions options) {
        Path destPath = new Path(definition.destination());
        if (destFS.exists(destPath)) {
            return new DirectoryCopyResult(definition.source().getPath().toUri(), definition.destination(), CopyActionResult$SkippedAlreadyExists$.MODULE$);
        }
        if (options.dryRun()) {
            return new DirectoryCopyResult(definition.source().getPath().toUri(), definition.destination(), CopyActionResult$SkippedDryRun$.MODULE$);
        }
        Try result = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            if (destFS.exists(destPath.getParent())) {
                destFS.mkdirs(destPath);
                return new DirectoryCopyResult(definition.source().getPath().toUri(), definition.destination(), CopyActionResult$Created$.MODULE$);
            }
            throw new FileNotFoundException("Parent folder [" + destPath.getParent() + "] does not exist.");
        }).recover((PartialFunction)new Serializable(definition){
            private static final long serialVersionUID = 0L;
            private final SingleCopyDefinition definition$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof FileAlreadyExistsException) {
                    return (B1)new DirectoryCopyResult(this.definition$1.source().getPath().toUri(), this.definition$1.destination(), CopyActionResult$SkippedAlreadyExists$.MODULE$);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable instanceof FileAlreadyExistsException;
            }
            {
                this.definition$1 = definition$1;
            }
        });
        boolean bl = false;
        Failure failure = null;
        Try try_ = result;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            DirectoryCopyResult v = (DirectoryCopyResult)success.value();
            return v;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable e = failure.exception();
            if (options.ignoreErrors()) {
                this.logError((Function0<String>)(Function0 & Serializable)() -> "Exception whilst creating directory [" + definition.destination() + "]", e);
                return new DirectoryCopyResult(definition.source().getPath().toUri(), definition.destination(), new CopyActionResult.Failed(e));
            }
        }
        if (bl) {
            Throwable e = failure.exception();
            throw e;
        }
        throw new MatchError((Object)try_);
    }

    public FileCopyResult copyFile(FileSystem sourceFS, FileSystem destFS, SingleCopyDefinition definition, SparkDistCPOptions options, long taskAttemptID) {
        Path destPath = new Path(definition.destination());
        boolean bl = false;
        Failure failure = null;
        boolean bl2 = false;
        Success success = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> destFS.getFileStatus(destPath));
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof FileNotFoundException && options.dryRun()) {
                return new FileCopyResult(definition.source().getPath().toUri(), definition.destination(), definition.source().len(), CopyActionResult$SkippedDryRun$.MODULE$);
            }
        }
        if (bl && failure.exception() instanceof FileNotFoundException) {
            return this.performCopy(sourceFS, definition.source(), destFS, definition.destination(), false, options.ignoreErrors(), options.direct(), taskAttemptID);
        }
        if (bl) {
            Throwable e = failure.exception();
            if (options.ignoreErrors()) {
                this.logError((Function0<String>)(Function0 & Serializable)() -> "Exception whilst getting destination file information [" + definition.destination() + "]", e);
                return new FileCopyResult(definition.source().getPath().toUri(), definition.destination(), definition.source().len(), new CopyActionResult.Failed(e));
            }
        }
        if (bl) {
            Throwable e = failure.exception();
            throw e;
        }
        if (try_ instanceof Success) {
            bl2 = true;
            success = (Success)try_;
            if (options.overwrite() && options.dryRun()) {
                return new FileCopyResult(definition.source().getPath().toUri(), definition.destination(), definition.source().len(), CopyActionResult$SkippedDryRun$.MODULE$);
            }
        }
        if (bl2 && options.overwrite()) {
            return this.performCopy(sourceFS, definition.source(), destFS, definition.destination(), true, options.ignoreErrors(), options.direct(), taskAttemptID);
        }
        if (bl2) {
            FileStatus d = (FileStatus)success.value();
            if (options.update()) {
                boolean bl3;
                boolean bl4;
                boolean bl5 = false;
                Failure failure2 = null;
                boolean bl6 = false;
                Success success2 = null;
                Try try_2 = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> MODULE$.filesAreIdentical(definition.source(), (Function0<Option<FileChecksum>>)(Function0 & Serializable)() -> Option$.MODULE$.apply((Object)sourceFS.getFileChecksum(definition.source().getPath())), SerializableFileStatus$.MODULE$.apply(d), (Function0<Option<FileChecksum>>)(Function0 & Serializable)() -> Option$.MODULE$.apply((Object)destFS.getFileChecksum(destPath))));
                if (try_2 instanceof Failure) {
                    bl5 = true;
                    failure2 = (Failure)try_2;
                    Throwable e = failure2.exception();
                    if (options.ignoreErrors()) {
                        this.logError((Function0<String>)(Function0 & Serializable)() -> "Exception whilst getting source and destination checksum: source [" + definition.source().getPath() + "] destination [" + definition.destination(), e);
                        return new FileCopyResult(definition.source().getPath().toUri(), definition.destination(), definition.source().len(), new CopyActionResult.Failed(e));
                    }
                }
                if (bl5) {
                    Throwable e = failure2.exception();
                    throw e;
                }
                if (try_2 instanceof Success) {
                    bl6 = true;
                    success2 = (Success)try_2;
                    boolean bl7 = BoxesRunTime.unboxToBoolean((Object)success2.value());
                    if (bl7) {
                        return new FileCopyResult(definition.source().getPath().toUri(), definition.destination(), definition.source().len(), CopyActionResult$SkippedIdenticalFileAlreadyExists$.MODULE$);
                    }
                }
                if (bl6 && !(bl4 = BoxesRunTime.unboxToBoolean((Object)success2.value())) && options.dryRun()) {
                    return new FileCopyResult(definition.source().getPath().toUri(), definition.destination(), definition.source().len(), CopyActionResult$SkippedDryRun$.MODULE$);
                }
                if (bl6 && !(bl3 = BoxesRunTime.unboxToBoolean((Object)success2.value()))) {
                    return this.performCopy(sourceFS, definition.source(), destFS, definition.destination(), true, options.ignoreErrors(), options.direct(), taskAttemptID);
                }
                throw new MatchError((Object)try_2);
            }
        }
        if (bl2) {
            return new FileCopyResult(definition.source().getPath().toUri(), definition.destination(), definition.source().len(), CopyActionResult$SkippedAlreadyExists$.MODULE$);
        }
        throw new MatchError((Object)try_);
    }

    public boolean filesAreIdentical(SerializableFileStatus f1, Function0<Option<FileChecksum>> mc1, SerializableFileStatus f2, Function0<Option<FileChecksum>> mc2) {
        if (f1.getLen() != f2.getLen()) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Length [" + f1.getLen() + "] of file [" + f1.uri() + "] was not the same as length [" + f2.getLen() + "] of file [" + f2.uri() + "]. Files are not identical.");
            return false;
        }
        Option c12 = (Option)mc1.apply();
        Option c2 = (Option)mc2.apply();
        boolean same = BoxesRunTime.unboxToBoolean((Object)((Option)mc1.apply()).flatMap((Function1 & Serializable)c1 -> ((Option)mc2.apply()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CopyUtils$.$anonfun$filesAreIdentical$3(c1, x$1)))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true));
        if (same) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "CRC [" + c12 + "] of file [" + f1.uri() + "] was the same as CRC [" + c2 + "] of file [" + f2.uri() + "]. Files are identical.");
            return true;
        }
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "CRC [" + c12 + "] of file [" + f1.uri() + "] was not the same as CRC [" + c2 + "] of file [" + f2.uri() + "]. Files are not identical.");
        return false;
    }

    public FileCopyResult performCopy(FileSystem sourceFS, SerializableFileStatus sourceFile, FileSystem destFS, URI dest, boolean removeExisting, boolean ignoreErrors, boolean direct, long taskAttemptID) {
        Path destPath = new Path(dest);
        Path tempPath = direct ? destPath : new Path(destPath.getParent(), ".sparkdistcp." + taskAttemptID + "." + destPath.getName());
        boolean bl = false;
        Success success = null;
        boolean bl2 = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            None$ in = None$.MODULE$;
            None$ out = None$.MODULE$;
            try {
                in = new Some((Object)sourceFS.open(sourceFile.getPath()));
                if (!destFS.exists(tempPath.getParent())) {
                    throw new RuntimeException("Destination folder [" + tempPath.getParent() + "] does not exist");
                }
                out = new Some((Object)destFS.create(tempPath, direct));
                IOUtils.copyBytes((InputStream)((InputStream)in.get()), (OutputStream)((OutputStream)out.get()), (int)sourceFS.getConf().getInt("io.file.buffer.size", 4096));
            }
            finally {
                in.foreach((Function1 & Serializable)x$2 -> {
                    x$2.close();
                    return BoxedUnit.UNIT;
                });
                out.foreach((Function1 & Serializable)x$3 -> {
                    x$3.close();
                    return BoxedUnit.UNIT;
                });
            }
        }).map((Function1 & Serializable)x$4 -> {
            CopyUtils$.$anonfun$performCopy$4(destFS, tempPath, sourceFile, direct, removeExisting, destPath, x$4);
            return BoxedUnit.UNIT;
        });
        if (try_ instanceof Success) {
            bl = true;
            success = (Success)try_;
            if (removeExisting) {
                return new FileCopyResult(sourceFile.getPath().toUri(), dest, sourceFile.len(), CopyActionResult$OverwrittenOrUpdated$.MODULE$);
            }
        }
        if (bl) {
            return new FileCopyResult(sourceFile.getPath().toUri(), dest, sourceFile.len(), CopyActionResult$Copied$.MODULE$);
        }
        if (try_ instanceof Failure) {
            bl2 = true;
            failure = (Failure)try_;
            Throwable e = failure.exception();
            if (ignoreErrors) {
                this.logError((Function0<String>)(Function0 & Serializable)() -> "Failed to copy file [" + sourceFile.getPath() + "] to [" + destPath + "]", e);
                return new FileCopyResult(sourceFile.getPath().toUri(), dest, sourceFile.len(), new CopyActionResult.Failed(e));
            }
        }
        if (bl2) {
            Throwable e = failure.exception();
            throw e;
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ boolean $anonfun$filesAreIdentical$3(FileChecksum c1$1, FileChecksum x$1) {
        FileChecksum fileChecksum = x$1;
        FileChecksum fileChecksum2 = c1$1;
        return !(fileChecksum != null ? !fileChecksum.equals(fileChecksum2) : fileChecksum2 != null);
    }

    public static final /* synthetic */ void $anonfun$performCopy$4(FileSystem destFS$3, Path tempPath$1, SerializableFileStatus sourceFile$1, boolean direct$1, boolean removeExisting$1, Path destPath$3, BoxedUnit x$4) {
        FileStatus tempFile = destFS$3.getFileStatus(tempPath$1);
        if (sourceFile$1.getLen() != tempFile.getLen()) {
            throw new RuntimeException("Written file [" + tempFile.getPath() + "] length [" + tempFile.getLen() + "] did not match source file [" + sourceFile$1.getPath() + "] length [" + sourceFile$1.getLen() + "]");
        }
        if (!direct$1) {
            boolean res;
            if (removeExisting$1 && !(res = destFS$3.delete(destPath$3, false))) {
                throw new RuntimeException("Failed to clean up existing file [" + destPath$3 + "]");
            }
            if (destFS$3.exists(destPath$3)) {
                throw new RuntimeException("Cannot create file [" + destPath$3 + "] as it already exists");
            }
            boolean res2 = destFS$3.rename(tempPath$1, destPath$3);
            if (!res2) {
                throw new RuntimeException("Failed to rename temporary file [" + tempPath$1 + "] to [" + destPath$3 + "]");
            }
            return;
        }
    }

    private CopyUtils$() {
    }
}

