/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.organizations.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.common.controller.AbstractDnetController;
import eu.dnetlib.organizations.controller.HomeController;
import eu.dnetlib.organizations.controller.UserInfo;
import eu.dnetlib.organizations.controller.UserRole;
import eu.dnetlib.organizations.importer.ImportExecutor;
import eu.dnetlib.organizations.importer.ImportStatus;
import eu.dnetlib.organizations.model.SystemConfiguration;
import eu.dnetlib.organizations.repository.SystemConfigurationRepository;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;

@Controller
public class HomeController
extends AbstractDnetController {
    @Autowired
    private Environment env;
    @Autowired
    private ImportExecutor importExecutor;
    @Autowired
    private SystemConfigurationRepository systemConfigurationRepository;
    @Value(value="${openaire.explore.organization.baseurl}")
    private String openaireBaseUrl;
    @Value(value="${openorgs.support.pages}")
    private String supportPagesJson;
    private Map<String, String> supportPages;

    @GetMapping(value={"/"})
    public String home() {
        return this.env.acceptsProfiles(Profiles.of((String[])new String[]{"dev"})) ? "redirect:main" : "home";
    }

    @GetMapping(value={"/redirect/oa/{orgId}"})
    public String openaireUrl(@PathVariable String orgId) {
        return "redirect:" + String.format(this.openaireBaseUrl, orgId);
    }

    @GetMapping(value={"/main"})
    public String main() {
        return "main";
    }

    @GetMapping(value={"/login"})
    public String login() {
        return "login";
    }

    @GetMapping(value={"/authorizationRequest"})
    public String authorizationRequest() {
        return "authorizationRequest";
    }

    @GetMapping(value={"/alreadyRegistered"})
    public String alreadyRegistered() {
        return "alreadyRegistered";
    }

    @ModelAttribute(value="email")
    public String getUserEmail(Authentication authentication) {
        return authentication != null ? UserInfo.getEmail((Authentication)authentication) : null;
    }

    @ModelAttribute(value="role")
    public UserRole getUserRole(Authentication authentication) {
        return authentication != null ? UserInfo.findRole((Authentication)authentication) : null;
    }

    @ModelAttribute(value="fullname")
    public String getUserFullname(Authentication authentication) {
        return authentication != null ? UserInfo.getFullname((Authentication)authentication) : "unknown";
    }

    @ModelAttribute(value="organization")
    public String getUserOrganization(Authentication authentication) {
        return authentication != null ? UserInfo.getOrganization((Authentication)authentication) : "unknown";
    }

    @ModelAttribute(value="sysconf")
    public SystemConfiguration getSysConf(Authentication authentication) {
        return (SystemConfiguration)this.systemConfigurationRepository.findById((Object)"default").get();
    }

    @ModelAttribute(value="isImportRunning")
    public boolean isImportRunning(Authentication authentication) {
        return this.importExecutor.getLastImportExecution().getStatus() == ImportStatus.RUNNING;
    }

    @ModelAttribute(value="supportPages")
    public Map<String, String> supportPages(Authentication authentication) throws JsonMappingException, JsonProcessingException {
        if (this.supportPages == null) {
            ObjectMapper mapper = new ObjectMapper();
            1 typeRef = new /* Unavailable Anonymous Inner Class!! */;
            this.supportPages = (Map)mapper.readValue(this.supportPagesJson, (TypeReference)typeRef);
        }
        return this.supportPages;
    }

    @GetMapping(value={"apidoc", "api-doc", "/doc", "/swagger"})
    public String apiDoc() {
        return "redirect:swagger-ui/index.html";
    }
}

