/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.organizations.metrics;

import eu.dnetlib.common.metrics.MetricsCalculator;
import eu.dnetlib.organizations.metrics.OrganizationMetrics;
import eu.dnetlib.organizations.model.view.SuggestionInfoViewByCountry;
import eu.dnetlib.organizations.model.view.UserView;
import eu.dnetlib.organizations.repository.readonly.SuggestionInfoViewByCountryRepository;
import eu.dnetlib.organizations.repository.readonly.UserViewRepository;
import eu.dnetlib.organizations.utils.DatabaseUtils;
import io.prometheus.client.Collector;
import io.prometheus.client.GaugeMetricFamily;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class OrganizationMetricsCalculator
implements MetricsCalculator {
    @Autowired
    private UserViewRepository userViewRepository;
    @Autowired
    private DatabaseUtils dbUtils;
    @Autowired
    private SuggestionInfoViewByCountryRepository suggestionInfoViewByCountryRepository;
    private static final Log log = LogFactory.getLog(OrganizationMetricsCalculator.class);

    public List<Collector.MetricFamilySamples> getMetrics() {
        ArrayList<Collector.MetricFamilySamples> list = new ArrayList<Collector.MetricFamilySamples>();
        OrganizationMetrics m = this.prepareMetrics();
        list.add((Collector.MetricFamilySamples)new GaugeMetricFamily("openorgs_approved_organizations", "approved organisations", (double)m.getApprovedOrgs()));
        list.add((Collector.MetricFamilySamples)new GaugeMetricFamily("openorgs_suggested_organizations", "suggested organisations", (double)m.getSuggestedOrgs()));
        list.add((Collector.MetricFamilySamples)new GaugeMetricFamily("openorgs_with_duplicates_orgs", "orgs with new duplicates", (double)m.getOrgsWithSuggestedDuplicates()));
        list.add((Collector.MetricFamilySamples)new GaugeMetricFamily("openorgs_potential_conflicts", "potential conflicts", (double)m.getPotentialConflicts()));
        list.add((Collector.MetricFamilySamples)new GaugeMetricFamily("openorgs_national_curators", "Number of curators", (double)m.getNationalCurators()));
        list.add((Collector.MetricFamilySamples)new GaugeMetricFamily("openorgs_national_curators_countries", "Number of collaborating countries", (double)m.getNationalCuratorCountries().longValue()));
        m.getTypes().forEach((k, v) -> list.add((Collector.MetricFamilySamples)new GaugeMetricFamily("openorgs_approved_organizations_type_" + k.toLowerCase(), "Number of approved organisations by type (" + k + ")", (double)v.longValue())));
        m.getCountries().forEach((k, cm) -> list.add((Collector.MetricFamilySamples)new GaugeMetricFamily("openorgs_approved_organizations_country_" + k.toLowerCase(), "Number of approved organisations by country (" + cm.getName() + ")", (double)cm.getApprovedOrgs())));
        return list;
    }

    @Cacheable(value={"metrics"}, key="'metrics'")
    public OrganizationMetrics prepareMetrics() {
        String country;
        log.debug((Object)"Preparing metrics");
        long nUsers = 0L;
        long nApproved = 0L;
        long nSuggested = 0L;
        long nDups = 0L;
        long nConflicts = 0L;
        LinkedHashMap types = new LinkedHashMap();
        HashSet<String> countriesWithUsers = new HashSet<String>();
        LinkedHashMap countryMetrics = new LinkedHashMap();
        this.dbUtils.listValuesOfVocabularyTable(DatabaseUtils.VocabularyTable.countries).forEach(entry -> {
            OrganizationMetrics m = new OrganizationMetrics();
            m.setName(entry.getName());
            m.setImageUrl(entry.getValue() + ".gif");
            countryMetrics.put(entry.getValue(), m);
        });
        this.dbUtils.browseCountries().forEach(entry -> {
            OrganizationMetrics m = (OrganizationMetrics)countryMetrics.get(entry.getCode());
            m.setApprovedOrgs(entry.getValues().getOrDefault("approved", 0L).longValue());
            m.setSuggestedOrgs(entry.getValues().getOrDefault("suggested", 0L).longValue());
        });
        for (UserView userView : this.userViewRepository.findAll()) {
            if (userView.isValid()) {
                ++nUsers;
            }
            for (String country2 : userView.getCountries()) {
                if (!countryMetrics.containsKey(country2)) continue;
                ((OrganizationMetrics)countryMetrics.get(country2)).setNationalCurators(((OrganizationMetrics)countryMetrics.get(country2)).getNationalCurators() + 1L);
            }
        }
        for (SuggestionInfoViewByCountry suggestionInfoViewByCountry : this.suggestionInfoViewByCountryRepository.findAll()) {
            country = suggestionInfoViewByCountry.getCode();
            ((OrganizationMetrics)countryMetrics.get(country)).setSuggestedOrgs(suggestionInfoViewByCountry.getnPendingOrgs());
            ((OrganizationMetrics)countryMetrics.get(country)).setOrgsWithSuggestedDuplicates(suggestionInfoViewByCountry.getnDuplicates());
            ((OrganizationMetrics)countryMetrics.get(country)).setPotentialConflicts(suggestionInfoViewByCountry.getnConflicts());
        }
        for (Map.Entry entry2 : this.dbUtils.countValidOrgsByTypesAndCountry().entrySet()) {
            country = (String)entry2.getKey();
            ((OrganizationMetrics)countryMetrics.get(country)).setTypes((Map)entry2.getValue());
        }
        for (OrganizationMetrics organizationMetrics : countryMetrics.values()) {
            nApproved += organizationMetrics.getApprovedOrgs();
            nSuggested += organizationMetrics.getSuggestedOrgs();
            nDups += organizationMetrics.getOrgsWithSuggestedDuplicates();
            nConflicts += organizationMetrics.getPotentialConflicts();
            if (organizationMetrics.getNationalCurators() > 0L) {
                countriesWithUsers.add(organizationMetrics.getName());
            }
            organizationMetrics.getTypes().forEach((k, v) -> {
                if (types.containsKey(k)) {
                    types.put(k, (Long)types.get(k) + v);
                } else {
                    types.put(k, v);
                }
            });
        }
        for (OrganizationMetrics organizationMetrics : countryMetrics.values()) {
            organizationMetrics.setPercentageOfApproved(Double.valueOf((double)organizationMetrics.getApprovedOrgs() * 100.0 / (double)(organizationMetrics.getApprovedOrgs() + organizationMetrics.getSuggestedOrgs())));
            organizationMetrics.setPercentageOfApprovedOnAllApproved(Double.valueOf((double)organizationMetrics.getApprovedOrgs() * 100.0 / (double)nApproved));
        }
        OrganizationMetrics m = new OrganizationMetrics();
        m.setName("OpenOrgs Metrics");
        m.setImageUrl("openorgs_logo.png");
        m.setApprovedOrgs(nApproved);
        m.setSuggestedOrgs(nSuggested);
        m.setPercentageOfApproved(Double.valueOf((double)nApproved * 100.0 / (double)(nApproved + nSuggested)));
        m.setOrgsWithSuggestedDuplicates(nDups);
        m.setPotentialConflicts(nConflicts);
        m.setNationalCurators(nUsers);
        m.setNationalCuratorCountries(Long.valueOf(countriesWithUsers.size()));
        m.setCountries(countryMetrics);
        m.setTypes(types);
        return m;
    }

    @CacheEvict(value={"metrics"}, allEntries=true)
    @Scheduled(fixedRate=3600000L)
    public void clearCache() {
        log.debug((Object)"Metrics cache cleaned");
    }
}

