package eu.dnetlib.organizations.metrics;

import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;

public class OrganizationMetrics {

	// TODO controllare i termini specifici per ogni country

	private String name;

	private String imageUrl;

	private long validOrgs;

	private long pendingOrgs;

	private long orgsWithSuggestedDuplicates;

	private long potentialConflicts;

	private long nationalCurators;

	@JsonInclude(Include.NON_ABSENT)
	private Long nationalCuratorCountries;

	private Map<String, Long> types = new HashMap<>();

	@JsonInclude(Include.NON_ABSENT)
	private Map<String, OrganizationMetrics> countries;

	public String getName() {
		return name;
	}

	public void setName(final String name) {
		this.name = name;
	}

	public String getImageUrl() {
		return imageUrl;
	}

	public void setImageUrl(final String imageUrl) {
		this.imageUrl = imageUrl;
	}

	public long getValidOrgs() {
		return validOrgs;
	}

	public void setValidOrgs(final long validOrgs) {
		this.validOrgs = validOrgs;
	}

	public long getPendingOrgs() {
		return pendingOrgs;
	}

	public void setPendingOrgs(final long pendingOrgs) {
		this.pendingOrgs = pendingOrgs;
	}

	public long getOrgsWithSuggestedDuplicates() {
		return orgsWithSuggestedDuplicates;
	}

	public void setOrgsWithSuggestedDuplicates(final long orgsWithSuggestedDuplicates) {
		this.orgsWithSuggestedDuplicates = orgsWithSuggestedDuplicates;
	}

	public long getPotentialConflicts() {
		return potentialConflicts;
	}

	public void setPotentialConflicts(final long potentialConflicts) {
		this.potentialConflicts = potentialConflicts;
	}

	public long getNationalCurators() {
		return nationalCurators;
	}

	public void setNationalCurators(final long nationalCurators) {
		this.nationalCurators = nationalCurators;
	}

	public Long getNationalCuratorCountries() {
		return nationalCuratorCountries;
	}

	public void setNationalCuratorCountries(final Long nationalCuratorCountries) {
		this.nationalCuratorCountries = nationalCuratorCountries;
	}

	public Map<String, Long> getTypes() {
		return types;
	}

	public void setTypes(final Map<String, Long> types) {
		this.types = types;
	}

	public Map<String, OrganizationMetrics> getCountries() {
		return countries;
	}

	public void setCountries(final Map<String, OrganizationMetrics> countries) {
		this.countries = countries;
	}

}
