/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.organizations.metrics;

import eu.dnetlib.common.metrics.MetricsCalculator;
import eu.dnetlib.organizations.metrics.OrganizationMetrics;
import eu.dnetlib.organizations.model.utils.BrowseEntry;
import eu.dnetlib.organizations.model.view.SuggestionInfoViewByCountry;
import eu.dnetlib.organizations.model.view.UserView;
import eu.dnetlib.organizations.repository.OrganizationRepository;
import eu.dnetlib.organizations.repository.readonly.SuggestionInfoViewByCountryRepository;
import eu.dnetlib.organizations.repository.readonly.UserViewRepository;
import eu.dnetlib.organizations.utils.DatabaseUtils;
import eu.dnetlib.organizations.utils.OrganizationStatus;
import io.prometheus.client.Collector;
import io.prometheus.client.GaugeMetricFamily;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrganizationMetricsCalculator
implements MetricsCalculator {
    @Autowired
    private OrganizationRepository organizationRepository;
    @Autowired
    private UserViewRepository userViewRepository;
    @Autowired
    private DatabaseUtils dbUtils;
    @Autowired
    private SuggestionInfoViewByCountryRepository suggestionInfoViewByCountryRepository;

    public List<Collector.MetricFamilySamples> getMetrics() {
        ArrayList<Collector.MetricFamilySamples> list = new ArrayList<Collector.MetricFamilySamples>();
        OrganizationMetrics m = this.prepareMetrics(null);
        list.add((Collector.MetricFamilySamples)new GaugeMetricFamily("openorgs_valid_organizations", "approved organisations", (double)m.getValidOrgs()));
        list.add((Collector.MetricFamilySamples)new GaugeMetricFamily("openorgs_suggested_organizations", "suggested organisations", (double)m.getPendingOrgs()));
        list.add((Collector.MetricFamilySamples)new GaugeMetricFamily("openorgs_with_duplicates_orgs", "orgs with new duplicates", (double)m.getOrgsWithSuggestedDuplicates()));
        list.add((Collector.MetricFamilySamples)new GaugeMetricFamily("openorgs_potential_conflicts", "potential conflicts", (double)m.getPotentialConflicts()));
        list.add((Collector.MetricFamilySamples)new GaugeMetricFamily("openorgs_national_curators", "Number of curators", (double)m.getNationalCurators()));
        list.add((Collector.MetricFamilySamples)new GaugeMetricFamily("openorgs_national_curators_countries", "Number of collaborating countries", (double)m.getNationalCuratorCountries()));
        m.getByType().forEach((k, v) -> list.add((Collector.MetricFamilySamples)new GaugeMetricFamily("openorgs_approved_organizations_type_" + k.toLowerCase(), "Number of approved organisations by type (" + k + ")", (double)v.longValue())));
        return list;
    }

    public OrganizationMetrics prepareMetrics(String country) {
        long nUsers = 0L;
        long nUsersByCountry = 0L;
        HashSet nUserCountries = new HashSet();
        for (UserView u : this.userViewRepository.findAll()) {
            if (u.isValid()) {
                ++nUsers;
                Collections.addAll(nUserCountries, u.getCountries());
            }
            if (country == null || !u.isValid() || !Arrays.asList(u.getCountries()).contains(country)) continue;
            ++nUsersByCountry;
        }
        nUserCountries.remove("UNKNOWN");
        String countryLabel = country;
        long nSuggested = 0L;
        long nDups = 0L;
        long nConflicts = 0L;
        long nSuggestedByCountry = 0L;
        long nDupsByCountry = 0L;
        long nConflictsByCountry = 0L;
        for (SuggestionInfoViewByCountry info : this.suggestionInfoViewByCountryRepository.findAll()) {
            nSuggested += info.getnPendingOrgs();
            nDups += info.getnDuplicates();
            nConflicts += info.getnConflicts();
            if (country == null || !country.equals(info.getCode())) continue;
            countryLabel = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{info.getName(), info.getCode(), country});
            nSuggestedByCountry = info.getnPendingOrgs();
            nDupsByCountry = info.getnDuplicates();
            nConflictsByCountry = info.getnConflicts();
        }
        OrganizationMetrics m = new OrganizationMetrics();
        m.setName("OpenOrgs Metrics");
        m.setImageUrl("openorgs_logo.png");
        m.setValidOrgs(this.organizationRepository.countByStatus(OrganizationStatus.approved.toString()));
        m.setPendingOrgs(nSuggested);
        m.setOrgsWithSuggestedDuplicates(nDups);
        m.setPotentialConflicts(nConflicts);
        m.setNationalCurators(nUsers);
        m.setNationalCuratorCountries((long)nUserCountries.size());
        m.setByType(this.asTerms(this.dbUtils.browseTypes()));
        if (country != null) {
            OrganizationMetrics mc = new OrganizationMetrics();
            mc.setName(countryLabel);
            mc.setImageUrl(country + ".gif");
            mc.setValidOrgs(this.organizationRepository.countByStatusAndCountry(OrganizationStatus.approved.toString(), country));
            mc.setPendingOrgs(nSuggestedByCountry);
            mc.setOrgsWithSuggestedDuplicates(nDupsByCountry);
            mc.setPotentialConflicts(nConflictsByCountry);
            mc.setNationalCurators(nUsersByCountry);
            mc.setByType(this.asTerms(this.dbUtils.browseTypesForCountry(country)));
            m.setByCountry(new LinkedHashMap());
            m.getByCountry().put(country, mc);
        }
        return m;
    }

    private Map<String, Long> asTerms(List<BrowseEntry> list) {
        return list.stream().collect(Collectors.toMap(BrowseEntry::getCode, e -> e.getValues().getOrDefault("approved", 0L)));
    }
}

