/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.organizations.controller;

import eu.dnetlib.organizations.metrics.OrganizationMetrics;
import eu.dnetlib.organizations.metrics.OrganizationMetricsCalculator;
import eu.dnetlib.organizations.utils.DatabaseUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/public-api"})
public class PublicApiController {
    @Autowired
    private DatabaseUtils dbUtils;
    @Autowired
    private OrganizationMetricsCalculator organizationMetricsCalculator;

    @GetMapping(value={"/logs"})
    public void findJournalById(@RequestParam String id, HttpServletResponse res) throws IOException {
        String filename = String.format("%s.log", id.replaceAll(":", "_"));
        res.setContentType(MediaType.TEXT_PLAIN.getType());
        res.setHeader("Content-Disposition", "attachment; filename=" + filename);
        try (ServletOutputStream out = res.getOutputStream();){
            for (String s : this.dbUtils.obtainLogEntries(id)) {
                IOUtils.write((String)s, (OutputStream)out, (Charset)StandardCharsets.UTF_8);
            }
        }
    }

    @GetMapping(value={"/logs/{year}/{month}/{country}"})
    public void findJournalByCountry(@PathVariable int year, @PathVariable int month, @PathVariable String country, HttpServletResponse res) throws IOException {
        if (month < 1 || month > 12) {
            res.sendError(HttpStatus.BAD_REQUEST.value(), "Invalid month");
        }
        if (year < 2020 || year > 2100) {
            res.sendError(HttpStatus.BAD_REQUEST.value(), "Invalid year");
        }
        String filename = String.format("%04d_%02d_%s.log", year, month, country);
        res.setContentType(MediaType.TEXT_PLAIN.getType());
        res.setHeader("Content-Disposition", "attachment; filename=" + filename);
        try (ServletOutputStream out = res.getOutputStream();){
            for (String s : this.dbUtils.obtainLogEntries(year, month, country)) {
                IOUtils.write((String)s, (OutputStream)out, (Charset)StandardCharsets.UTF_8);
            }
        }
    }

    @GetMapping(value={"/metrics"})
    public OrganizationMetrics metrics(@RequestParam(required=false) String country) throws IOException {
        return this.organizationMetricsCalculator.prepareMetrics(country);
    }
}

