/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.organizations.controller;

import eu.dnetlib.common.controller.AbstractDnetController;
import eu.dnetlib.organizations.controller.UserInfo;
import eu.dnetlib.organizations.controller.UserRegistration;
import eu.dnetlib.organizations.controller.UserRole;
import eu.dnetlib.organizations.importer.ImportExecution;
import eu.dnetlib.organizations.importer.ImportExecutor;
import eu.dnetlib.organizations.model.SystemConfiguration;
import eu.dnetlib.organizations.model.utils.VocabularyTerm;
import eu.dnetlib.organizations.model.view.PersistentOrganizationView;
import eu.dnetlib.organizations.model.view.UserView;
import eu.dnetlib.organizations.repository.SystemConfigurationRepository;
import eu.dnetlib.organizations.repository.UserRepository;
import eu.dnetlib.organizations.repository.readonly.UserViewRepository;
import eu.dnetlib.organizations.utils.DatabaseUtils;
import eu.dnetlib.organizations.utils.MailDispatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AdminController
extends AbstractDnetController {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private UserViewRepository userViewRepository;
    @Autowired
    private SystemConfigurationRepository systemConfigurationRepository;
    @Autowired
    private ImportExecutor importExecutor;
    @Autowired
    private DatabaseUtils dbUtils;
    @Autowired
    private MailDispatcher mailDispatcher;

    @PostMapping(value={"/registration_api/newUser"})
    public Map<String, Integer> newUser(@RequestBody UserRegistration user, Authentication authentication) {
        String email = UserInfo.getEmail((Authentication)authentication);
        String fullname = UserInfo.getFullname((Authentication)authentication);
        String organization = UserInfo.getOrganization((Authentication)authentication);
        HashMap<String, Integer> res = new HashMap<String, Integer>();
        if (!UserInfo.isNotAuthorized((Authentication)authentication) || this.userRepository.existsById((Object)email)) {
            res.put("status", 2);
        } else {
            this.dbUtils.newUser(email, fullname, organization, user.getReferencePerson(), user.getRequestMessage(), user.getCountries());
            UserView savedUser = (UserView)this.userViewRepository.findById((Object)email).get();
            this.mailDispatcher.sendRequestRegistrationMail(savedUser);
            res.put("status", 1);
        }
        return res;
    }

    @GetMapping(value={"/api/users"})
    public Iterable<UserView> users(Authentication authentication) {
        ArrayList<UserView> res = new ArrayList<UserView>();
        Map<String, String> allCountries = this.dbUtils.listValuesOfVocabularyTable(DatabaseUtils.VocabularyTable.countries).stream().collect(Collectors.toMap(VocabularyTerm::getValue, VocabularyTerm::getName));
        Set<String> myCountries = UserInfo.isNationalAdmin((Authentication)authentication) ? this.dbUtils.listCountriesForUser(UserInfo.getEmail((Authentication)authentication)).stream().map(VocabularyTerm::getValue).collect(Collectors.toSet()) : (UserInfo.isSuperAdmin((Authentication)authentication) ? allCountries.keySet() : new HashSet<String>());
        for (UserView uw : this.userViewRepository.findAll()) {
            if (!UserInfo.isSuperAdmin((Authentication)authentication) && (!UserInfo.isNationalAdmin((Authentication)authentication) || UserRole.ADMIN.toString().equals(uw.getRole()) || uw.getCountries() == null || uw.getCountries().length <= 0 || !myCountries.containsAll(Arrays.asList(uw.getCountries())))) continue;
            if (uw.getCountries() != null) {
                for (String code : uw.getCountries()) {
                    uw.getCountryMap().put(code, allCountries.get(code));
                }
            }
            res.add(uw);
        }
        return res;
    }

    @PostMapping(value={"/api/users"})
    public Iterable<UserView> updateUser(@RequestBody UserView userView, Authentication authentication) {
        if (UserInfo.getEmail((Authentication)authentication).equals(userView.getEmail())) {
            throw new RuntimeException("You can't edit your own user");
        }
        this.dbUtils.updateUser(userView);
        if (userView.getRole().equals(UserRole.USER.toString()) || userView.getRole().equals(UserRole.NATIONAL_ADMIN.toString()) || userView.getRole().equals(UserRole.ADMIN.toString())) {
            this.mailDispatcher.sendUpdatedUserMail(userView);
        }
        return this.users(authentication);
    }

    @DeleteMapping(value={"/api/users"})
    public Iterable<UserView> deleteUser(@RequestParam String email, Authentication authentication) {
        if (UserInfo.getEmail((Authentication)authentication).equals(email)) {
            throw new RuntimeException("You can't delete your own user");
        }
        this.dbUtils.deleteUser(email);
        return this.users(authentication);
    }

    @GetMapping(value={"/api/sysconf"})
    public SystemConfiguration sysConf(Authentication authentication) {
        if (UserInfo.isSuperAdmin((Authentication)authentication)) {
            return (SystemConfiguration)this.systemConfigurationRepository.findById((Object)"default").get();
        }
        throw new RuntimeException("User not authorized");
    }

    @GetMapping(value={"/api/lastImportStatus"})
    private ImportExecution lastImportExecution(Authentication authentication) {
        if (UserInfo.isSuperAdmin((Authentication)authentication)) {
            return this.importExecutor.getLastImportExecution();
        }
        throw new RuntimeException("User not authorized");
    }

    @PostMapping(value={"/api/sysconf"})
    public SystemConfiguration saveSysConf(@RequestBody SystemConfiguration sysConf, Authentication authentication) {
        if (UserInfo.isSuperAdmin((Authentication)authentication)) {
            sysConf.setId("default");
            this.systemConfigurationRepository.save((Object)sysConf);
            this.mailDispatcher.configure(sysConf);
            return sysConf;
        }
        throw new RuntimeException("User not authorized");
    }

    @GetMapping(value={"/api/refreshFulltextIndex"})
    public List<String> refreshFulltextIndex(Authentication authentication) {
        if (UserInfo.isSuperAdmin((Authentication)authentication)) {
            new Thread(() -> ((DatabaseUtils)this.dbUtils).updateFulltextIndex()).start();
            return Arrays.asList("The index update is in progress, please wait a few minutes");
        }
        throw new RuntimeException("User not authorized");
    }

    @GetMapping(value={"/api/performConsistencyCheck"})
    public List<String> performConsistencyCheck(Authentication authentication) {
        if (UserInfo.isSuperAdmin((Authentication)authentication)) {
            new Thread(() -> ((DatabaseUtils)this.dbUtils).verifyConsistency()).start();
            return Arrays.asList("The check is running, please wait a few minutes");
        }
        throw new RuntimeException("User not authorized");
    }

    @GetMapping(value={"/api/verifyCountriesInSuggestions"})
    public List<String> verifyCountriesInSuggestions(Authentication authentication) {
        if (!UserInfo.isSuperAdmin((Authentication)authentication)) {
            throw new RuntimeException("User not authorized");
        }
        List list = this.dbUtils.invalidCountriesInSuggestions();
        if (list.isEmpty()) {
            return Arrays.asList("All countries are valid");
        }
        return Arrays.asList("Invalid countries in suggestions: " + StringUtils.join((Iterable)list, (String)", "));
    }

    @GetMapping(value={"/api/clearCache"})
    public List<String> clearCache(Authentication authentication) {
        if (UserInfo.isSuperAdmin((Authentication)authentication)) {
            this.dbUtils.clearCache();
            return Arrays.asList("All caches are cleared");
        }
        throw new RuntimeException("User not authorized");
    }

    @GetMapping(value={"/api/restartSuggestionsImport"})
    public List<String> restartSuggestionsImport(Authentication authentication) {
        if (UserInfo.isSuperAdmin((Authentication)authentication)) {
            this.importExecutor.startImport("the portal, user: " + UserInfo.getEmail((Authentication)authentication));
            return Arrays.asList("The import is running");
        }
        throw new RuntimeException("User not authorized");
    }

    @GetMapping(value={"/api/persistentOrgs"})
    public Iterable<PersistentOrganizationView> listPersistentOrgs() {
        return this.dbUtils.listPersistentOrgs();
    }

    @PostMapping(value={"/api/persistentOrgs"})
    public Iterable<PersistentOrganizationView> addPersistentOrgs(@RequestBody List<String> ids) {
        ids.forEach(id -> this.dbUtils.addPersistentOrgs(id));
        return this.dbUtils.listPersistentOrgs();
    }

    @DeleteMapping(value={"/api/persistentOrgs"})
    public Iterable<PersistentOrganizationView> deletePersistentOrgs(@RequestParam String id) {
        this.dbUtils.deletePersistentOrgs(id);
        return this.dbUtils.listPersistentOrgs();
    }
}

