/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.organizations.utils;

import eu.dnetlib.organizations.controller.UserRole;
import eu.dnetlib.organizations.model.Acronym;
import eu.dnetlib.organizations.model.JournalEntry;
import eu.dnetlib.organizations.model.OpenaireConflictPK;
import eu.dnetlib.organizations.model.OpenaireDuplicate;
import eu.dnetlib.organizations.model.Organization;
import eu.dnetlib.organizations.model.OtherIdentifier;
import eu.dnetlib.organizations.model.PersistentOrganization;
import eu.dnetlib.organizations.model.Relationship;
import eu.dnetlib.organizations.model.Url;
import eu.dnetlib.organizations.model.User;
import eu.dnetlib.organizations.model.UserCountry;
import eu.dnetlib.organizations.model.utils.BrowseEntry;
import eu.dnetlib.organizations.model.utils.OpenaireGraphNode;
import eu.dnetlib.organizations.model.utils.OrganizationConflict;
import eu.dnetlib.organizations.model.utils.TempBrowseEntry;
import eu.dnetlib.organizations.model.utils.VocabularyTerm;
import eu.dnetlib.organizations.model.view.OrganizationView;
import eu.dnetlib.organizations.model.view.OtherName;
import eu.dnetlib.organizations.model.view.PersistentOrganizationView;
import eu.dnetlib.organizations.model.view.UserView;
import eu.dnetlib.organizations.repository.AcronymRepository;
import eu.dnetlib.organizations.repository.JournalEntryRepository;
import eu.dnetlib.organizations.repository.OpenaireConflictRepository;
import eu.dnetlib.organizations.repository.OpenaireDuplicateRepository;
import eu.dnetlib.organizations.repository.OrganizationRepository;
import eu.dnetlib.organizations.repository.OtherIdentifierRepository;
import eu.dnetlib.organizations.repository.OtherNameRepository;
import eu.dnetlib.organizations.repository.PersistentOrganizationRepository;
import eu.dnetlib.organizations.repository.RelationshipRepository;
import eu.dnetlib.organizations.repository.UrlRepository;
import eu.dnetlib.organizations.repository.UserCountryRepository;
import eu.dnetlib.organizations.repository.UserRepository;
import eu.dnetlib.organizations.repository.readonly.OrganizationViewRepository;
import eu.dnetlib.organizations.repository.readonly.PersistentOrganizationViewRepository;
import eu.dnetlib.organizations.utils.DatabaseUtils;
import eu.dnetlib.organizations.utils.JournalOperations;
import eu.dnetlib.organizations.utils.OrganizationStatus;
import eu.dnetlib.organizations.utils.RelationType;
import eu.dnetlib.organizations.utils.SimilarityType;
import java.io.StringWriter;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;

@Component
public class DatabaseUtils {
    @Autowired
    private AcronymRepository acronymRepository;
    @Autowired
    private OrganizationRepository organizationRepository;
    @Autowired
    private OtherIdentifierRepository otherIdentifierRepository;
    @Autowired
    private OtherNameRepository otherNameRepository;
    @Autowired
    private UrlRepository urlRepository;
    @Autowired
    private RelationshipRepository relationshipRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private UserCountryRepository userCountryRepository;
    @Autowired
    private OpenaireConflictRepository openaireConflictRepository;
    @Autowired
    private OpenaireDuplicateRepository openaireDuplicateRepository;
    @Autowired
    private OrganizationViewRepository organizationViewRepository;
    @Autowired
    private JournalEntryRepository journalEntryRepository;
    @Autowired
    private PersistentOrganizationRepository persistentOrganizationRepository;
    @Autowired
    private PersistentOrganizationViewRepository persistentOrganizationViewRepository;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private static final Log log = LogFactory.getLog(DatabaseUtils.class);

    @Transactional
    public String insertOrUpdateOrganization(OrganizationView orgView, String user, boolean isSimpleUser) {
        String newStatus;
        String oldId = StringUtils.isNotBlank((CharSequence)orgView.getId()) ? new String(orgView.getId()) : null;
        String oldStatus = oldId != null ? (String)this.organizationRepository.findById((Object)oldId).map(Organization::getStatus).orElse(null) : null;
        boolean alreadyApproved = StringUtils.equals(oldStatus, (CharSequence)OrganizationStatus.approved.toString());
        if (!isSimpleUser) {
            newStatus = OrganizationStatus.approved.toString();
        } else if (isSimpleUser && oldStatus == null) {
            newStatus = OrganizationStatus.suggested.toString();
        } else if (isSimpleUser && alreadyApproved) {
            newStatus = OrganizationStatus.approved.toString();
        } else {
            throw new RuntimeException("User not authorized");
        }
        if (oldId == null || !oldId.startsWith("openorgs____::")) {
            if (isSimpleUser) {
                String pendingId = "pending_org_::" + UUID.randomUUID();
                orgView.setId(pendingId);
                this.organizationRepository.prepareOrgWithId(pendingId);
            } else {
                orgView.setId(null);
            }
        }
        Organization org = new Organization(orgView.getId(), orgView.getName(), orgView.getType(), orgView.getLat(), orgView.getLng(), orgView.getCity(), orgView.getCountry(), newStatus, orgView.getEcLegalBody(), orgView.getEcLegalPerson(), orgView.getEcNonProfit(), orgView.getEcResearchOrganization(), orgView.getEcHigherEducation(), orgView.getEcInternationalOrganizationEurInterests(), orgView.getEcInternationalOrganization(), orgView.getEcEnterprise(), orgView.getEcSmeValidated(), orgView.getEcNutscode());
        String newId = ((Organization)this.organizationRepository.save((Object)org)).getId();
        OffsetDateTime now = OffsetDateTime.now();
        if (StringUtils.equals((CharSequence)newId, (CharSequence)oldId)) {
            this.makeRelations(newId, orgView, true);
        } else {
            this.organizationRepository.updateCreationDate(newId, user, now);
            this.makeRelations(newId, orgView, false);
            if (oldId != null) {
                List<OpenaireDuplicate> dups = this.openaireDuplicateRepository.findByLocalId(oldId).stream().map(d -> this.prepareNewDuplicate(newId, oldId, d)).collect(Collectors.toList());
                this.openaireDuplicateRepository.saveAll(dups);
                dups.forEach(d -> {
                    this.openaireDuplicateRepository.updateCreatedByIfMissing(d.getLocalId(), d.getOaOriginalId(), user);
                    this.openaireDuplicateRepository.updateModificationDate(d.getLocalId(), d.getOaOriginalId(), user, now);
                });
                if (oldId.startsWith("pending_org_::")) {
                    this.organizationRepository.deleteById((Object)oldId);
                }
            }
        }
        this.organizationRepository.updateModificationDate(newId, user, now);
        JournalOperations op = JournalOperations.UNKNOWN;
        String message = "-";
        if (newStatus.equals(OrganizationStatus.suggested.toString())) {
            if (oldStatus == null) {
                op = JournalOperations.NEW_SUGG_ORG;
                message = "Created a new suggested org";
            } else {
                op = JournalOperations.EDIT_SUGG_ORG;
                message = "Metadata updated";
            }
        } else if (newStatus.equals(OrganizationStatus.approved.toString())) {
            if (oldStatus == null) {
                op = JournalOperations.NEW_ORG;
                message = "Created a new organization";
            } else if (oldStatus.equals(OrganizationStatus.suggested.toString())) {
                op = JournalOperations.APPROVE_SUGG_ORG;
                message = "Approved the suggested org: " + oldId;
            } else {
                op = JournalOperations.EDIT_ORG;
                message = "Metadata updated";
            }
        }
        this.journalEntryRepository.save((Object)new JournalEntry(newId, op, message, user));
        return newId;
    }

    private OpenaireDuplicate prepareNewDuplicate(String newId, String oldId, OpenaireDuplicate old) {
        OpenaireDuplicate d = new OpenaireDuplicate();
        d.setLocalId(newId);
        d.setOaOriginalId(old.getOaOriginalId());
        d.setOaCollectedFrom(old.getOaCollectedFrom());
        if (oldId != null && newId.startsWith("openorgs____::") && oldId.startsWith("pending_org_::") && StringUtils.substringAfter((String)oldId, (String)"pending_org_::").equalsIgnoreCase(DigestUtils.md5Hex((String)d.getOaOriginalId()))) {
            d.setRelType(SimilarityType.is_similar.toString());
        } else {
            d.setRelType(SimilarityType.suggested.toString());
        }
        return d;
    }

    @Transactional
    public void saveDuplicates(List<OpenaireDuplicate> simrels, String user) {
        OffsetDateTime now = OffsetDateTime.now();
        ArrayList<OpenaireDuplicate> toSave = new ArrayList<OpenaireDuplicate>();
        toSave.addAll(simrels);
        ArrayList<OpenaireDuplicate> toDelete = new ArrayList<OpenaireDuplicate>();
        for (OpenaireDuplicate r1 : simrels) {
            if (r1.getRelType().equals(SimilarityType.is_different.toString())) continue;
            for (OpenaireDuplicate r2 : this.openaireDuplicateRepository.findByOaOriginalId(r1.getOaOriginalId())) {
                if (r2.getLocalId().startsWith("pending_org_::")) {
                    toDelete.add(r2);
                    continue;
                }
                if (r1.getLocalId().equals(r2.getLocalId())) continue;
                r2.setRelType(SimilarityType.is_different.toString());
                toSave.add(r2);
            }
        }
        this.openaireDuplicateRepository.saveAll(toSave).forEach(d -> {
            this.openaireDuplicateRepository.updateCreatedByIfMissing(d.getLocalId(), d.getOaOriginalId(), user);
            this.openaireDuplicateRepository.updateModificationDate(d.getLocalId(), d.getOaOriginalId(), user, now);
        });
        log.debug((Object)("Simrels saved (contains also the fixed rels): " + toSave.size()));
        this.openaireDuplicateRepository.deleteAll(toDelete);
        log.debug((Object)("Simrels related to a pending orgs deleted: " + toDelete.size()));
        toSave.stream().collect(Collectors.groupingBy(OpenaireDuplicate::getLocalId)).forEach((id, list) -> {
            long sim = list.stream().filter(d -> d.getRelType().equals(SimilarityType.is_similar.toString())).count();
            long diff = list.stream().filter(d -> d.getRelType().equals(SimilarityType.is_different.toString())).count();
            long sugg = list.stream().filter(d -> d.getRelType().equals(SimilarityType.suggested.toString())).count();
            String message = String.format("Duplicates updated (%s similars, %s differents, %s suggested)", sim, diff, sugg);
            this.journalEntryRepository.save((Object)new JournalEntry(id, JournalOperations.DUPLICATES, message, user));
        });
    }

    @Scheduled(fixedRate=300000L)
    public void verifyConsistency() {
        log.debug((Object)"Verify consistency (START)");
        int n = this.jdbcTemplate.update("delete from organizations where id in (select o.id from organizations o left outer join oa_duplicates d on (o.id = d.local_id) where o.status = 'suggested' and o.created_by = 'dedupWf' group by o.id having count(d.local_id) = 0)");
        if (n > 0) {
            log.info((Object)("Invalid pending orgs deleted: " + n));
        }
        log.debug((Object)"Verify consistency (END)");
    }

    private void makeRelations(String orgId, OrganizationView orgView, boolean update) {
        if (update) {
            this.acronymRepository.deleteByOrgId(orgId);
            this.otherNameRepository.deleteByOrgId(orgId);
            this.otherIdentifierRepository.deleteByOrgId(orgId);
            this.urlRepository.deleteByOrgId(orgId);
            this.relationshipRepository.deleteById1(orgId);
            this.relationshipRepository.deleteById2(orgId);
        }
        orgView.getAcronyms().forEach(s -> {
            Acronym cfr_ignored_0 = (Acronym)this.acronymRepository.save((Object)new Acronym(orgId, s));
        });
        orgView.getOtherNames().forEach(n -> {
            eu.dnetlib.organizations.model.OtherName cfr_ignored_0 = (eu.dnetlib.organizations.model.OtherName)this.otherNameRepository.save((Object)new eu.dnetlib.organizations.model.OtherName(orgId, n.getName(), n.getLang()));
        });
        orgView.getOtherIdentifiers().forEach(id -> {
            OtherIdentifier cfr_ignored_0 = (OtherIdentifier)this.otherIdentifierRepository.save((Object)new OtherIdentifier(orgId, id.getId(), id.getType()));
        });
        orgView.getUrls().forEach(u -> {
            Url cfr_ignored_0 = (Url)this.urlRepository.save((Object)new Url(orgId, u));
        });
        orgView.getRelations().forEach(r -> this.makeRelation(orgId, r.getRelatedOrgId(), RelationType.valueOf((String)r.getType())));
    }

    @Cacheable(value={"vocs"})
    public List<VocabularyTerm> listValuesOfVocabularyTable(VocabularyTable table) {
        String sql = "select val as value, name as name from " + table + " order by name";
        return this.jdbcTemplate.query(sql, (RowMapper)new BeanPropertyRowMapper(VocabularyTerm.class));
    }

    @Cacheable(value={"countries_for_user"})
    public List<VocabularyTerm> listCountriesForUser(String name) {
        String sql = "select uc.country as value, c.name as name from user_countries uc left outer join countries c on (c.val = uc.country) where uc.email = ? order by c.name";
        return this.jdbcTemplate.query("select uc.country as value, c.name as name from user_countries uc left outer join countries c on (c.val = uc.country) where uc.email = ? order by c.name", (RowMapper)new BeanPropertyRowMapper(VocabularyTerm.class), new Object[]{name});
    }

    @CacheEvict(value={"vocs", "countries_for_user"}, allEntries=true)
    public void clearCache() {
        log.info((Object)"All caches cleaned");
    }

    @Transactional
    public void updateUser(@RequestBody UserView userView) {
        User user = (User)this.userRepository.findById((Object)userView.getEmail()).orElseThrow(() -> new RuntimeException("User not found"));
        user.setFullname(userView.getFullname());
        user.setOrganization(userView.getOrganization());
        user.setReferencePerson(userView.getReferencePerson());
        user.setRequestMessage(userView.getRequestMessage());
        user.setRole(userView.getRole());
        user.setValid(userView.isValid());
        this.userRepository.save((Object)user);
        this.userCountryRepository.deleteByEmail(userView.getEmail());
        if (userView.getCountries() != null) {
            this.userCountryRepository.saveAll((Iterable)Arrays.stream(userView.getCountries()).map(c -> new UserCountry(userView.getEmail(), c)).collect(Collectors.toList()));
        }
    }

    @Transactional
    public void deleteUser(String email) {
        this.userCountryRepository.deleteByEmail(email);
        this.userRepository.deleteById((Object)email);
    }

    @Transactional
    public void newUser(String email, String fullname, String organization, String referencePerson, String requestMessage, List<String> countries) {
        User user = new User();
        user.setEmail(email);
        user.setFullname(fullname);
        user.setOrganization(organization);
        user.setReferencePerson(referencePerson);
        user.setRequestMessage(requestMessage);
        user.setRole(UserRole.PENDING.name());
        user.setValid(false);
        this.userRepository.save((Object)user);
        if (countries != null) {
            this.userCountryRepository.saveAll((Iterable)countries.stream().map(c -> new UserCountry(email, c)).collect(Collectors.toList()));
        }
    }

    @Transactional
    public List<Relationship> makeRelation(String id1, String id2, RelationType type) {
        Relationship r1 = new Relationship(id1, id2, type.toString());
        Relationship r2 = new Relationship(id2, id1, type.getInverse().toString());
        this.relationshipRepository.save((Object)r1);
        this.relationshipRepository.save((Object)r2);
        return Arrays.asList(r1, r2);
    }

    public List<BrowseEntry> browseCountries() {
        String sql = "select o.country as code, c.name as name, o.status as group, count(o.status) as count from organizations o left outer join countries c on (o.country = c.val) group by o.country, c.name, o.status";
        return this.listBrowseEntries("select o.country as code, c.name as name, o.status as group, count(o.status) as count from organizations o left outer join countries c on (o.country = c.val) group by o.country, c.name, o.status", new Object[0]);
    }

    public List<BrowseEntry> browseCountriesForUser(String email) {
        String sql = "select o.country as code, c.name as name, o.status as group, count(o.status) as count from user_countries uc left outer join organizations o on (uc.country = o.country) left outer join countries c on (o.country = c.val) where uc.email=? group by o.country, c.name, o.status";
        return this.listBrowseEntries("select o.country as code, c.name as name, o.status as group, count(o.status) as count from user_countries uc left outer join organizations o on (uc.country = o.country) left outer join countries c on (o.country = c.val) where uc.email=? group by o.country, c.name, o.status", new Object[]{email});
    }

    public List<BrowseEntry> browseTypes() {
        String sql = "select type as code, type as name, status as group, count(status) as count from organizations group by type, status";
        return this.listBrowseEntries("select type as code, type as name, status as group, count(status) as count from organizations group by type, status", new Object[0]);
    }

    public List<BrowseEntry> browseTypesForUser(String email) {
        String sql = "select o.type as code, o.type as name,o.status as group, count(o.status) as count from organizations o left outer join user_countries uc on (uc.country = o.country) where uc.email=? group by o.type, o.status";
        return this.listBrowseEntries("select o.type as code, o.type as name,o.status as group, count(o.status) as count from organizations o left outer join user_countries uc on (uc.country = o.country) where uc.email=? group by o.type, o.status", new Object[]{email});
    }

    private List<BrowseEntry> listBrowseEntries(String sql, Object ... params) {
        HashMap<String, BrowseEntry> map = new HashMap<String, BrowseEntry>();
        for (TempBrowseEntry t : this.jdbcTemplate.query(sql, (RowMapper)new BeanPropertyRowMapper(TempBrowseEntry.class), params)) {
            if (!StringUtils.isNotBlank((CharSequence)t.getCode())) continue;
            if (!map.containsKey(t.getCode())) {
                BrowseEntry e = new BrowseEntry();
                e.setCode(t.getCode());
                e.setName(t.getName());
                map.put(t.getCode(), e);
            }
            ((BrowseEntry)map.get(t.getCode())).getValues().put(t.getGroup(), t.getCount());
        }
        return map.values().stream().sorted((o1, o2) -> StringUtils.compare((String)o1.getName(), (String)o2.getName())).collect(Collectors.toList());
    }

    public List<OrganizationConflict> listConflictsForId(String id) {
        String sql = "select o.id, o.name, o.type, o.city, o.country from oa_conflicts c left outer join organizations o on (c.id2 = o.id) where o.id is not null and c.id1 = ? and c.reltype = 'suggested'";
        return this.jdbcTemplate.query("select o.id, o.name, o.type, o.city, o.country from oa_conflicts c left outer join organizations o on (c.id2 = o.id) where o.id is not null and c.id1 = ? and c.reltype = 'suggested'", (RowMapper)new BeanPropertyRowMapper(OrganizationConflict.class), new Object[]{id});
    }

    @Transactional
    public void importDedupEvents() throws Exception {
        this.jdbcTemplate.update("CALL import_dedup_events();");
    }

    @Transactional
    public void updateFulltextIndex() {
        try {
            log.info((Object)"Updating Fulltext Index...");
            this.jdbcTemplate.queryForList("SELECT refresh_index_search()");
            log.info((Object)"...done");
        }
        catch (Exception e) {
            log.error((Object)"Error updating Fulltext Index", (Throwable)e);
        }
    }

    @Transactional
    public String fixConflictSimilars(List<String> similarIds, String user) {
        List views = similarIds.stream().map(arg_0 -> ((OrganizationViewRepository)this.organizationViewRepository).findById(arg_0)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        List persistents = views.stream().filter(OpenaireGraphNode::getPersistent).collect(Collectors.toList());
        OrganizationView masterOrg = new OrganizationView();
        if (persistents.size() > 1) {
            throw new RuntimeException("Too many persintent organizations");
        }
        if (persistents.size() == 1) {
            this.backupOrg((OrganizationView)persistents.get(0), user);
            masterOrg.setId(((OrganizationView)persistents.get(0)).getId());
            masterOrg.setStatus(OrganizationStatus.approved.toString());
        } else {
            masterOrg.setId(null);
            masterOrg.setStatus(null);
        }
        return this.fixConflicts(masterOrg, views, user);
    }

    private String backupOrg(OrganizationView org, String user) {
        String origId = org.getId();
        String backupId = origId + "::" + OffsetDateTime.now().toEpochSecond();
        this.organizationRepository.prepareOrgWithId(backupId);
        try {
            OrganizationView backupOrg = (OrganizationView)BeanUtils.cloneBean((Object)org);
            backupOrg.setId(backupId);
            this.insertOrUpdateOrganization(backupOrg, user, false);
            this.organizationRepository.updateStatus(backupId, OrganizationStatus.hidden.toString());
            this.journalEntryRepository.save((Object)new JournalEntry(origId, JournalOperations.BACKUP_ORG, "Saved a backup copy: " + backupId, user));
            this.journalEntryRepository.save((Object)new JournalEntry(backupId, JournalOperations.BACKUP_ORG, "Saved a backup copy of " + origId, user));
            return backupId;
        }
        catch (Exception e) {
            log.error((Object)("Error performing the backup of " + origId), (Throwable)e);
            throw new RuntimeException("Error performing the backup of " + origId, e);
        }
    }

    private String fixConflicts(OrganizationView masterOrg, List<OrganizationView> orgs, String user) {
        OffsetDateTime now = OffsetDateTime.now();
        String finalMessage = (masterOrg.getId() == null ? "New org created merging: " : "Merging in persistent org: ") + orgs.stream().map(OrganizationView::getId).collect(Collectors.joining(",  "));
        masterOrg.setName(this.findFirstString(orgs, OrganizationView::getName));
        masterOrg.setType(this.findFirstString(orgs, OrganizationView::getType));
        masterOrg.setLat(this.findFirstNumber(orgs, OrganizationView::getLat));
        masterOrg.setLng(this.findFirstNumber(orgs, OrganizationView::getLng));
        masterOrg.setCity(this.findFirstString(orgs, OrganizationView::getCity));
        masterOrg.setCountry(this.findFirstString(orgs, OrganizationView::getCountry));
        masterOrg.setOtherIdentifiers(this.findAll(orgs, OrganizationView::getOtherIdentifiers));
        masterOrg.setOtherNames(this.findAll(orgs, OrganizationView::getOtherNames));
        masterOrg.setAcronyms(this.findAll(orgs, OrganizationView::getAcronyms));
        masterOrg.setUrls(this.findAll(orgs, OrganizationView::getUrls));
        masterOrg.setRelations(this.findAll(orgs, OrganizationView::getRelations, r -> !r.getType().equals(RelationType.Merged_In.toString()) && !r.getType().equals(RelationType.Merged_In.toString())));
        masterOrg.getOtherNames().addAll(orgs.stream().map(OrganizationView::getName).filter(StringUtils::isNotBlank).filter(s -> StringUtils.equalsIgnoreCase((CharSequence)s, (CharSequence)masterOrg.getName())).map(s -> new OtherName(s, "UNKNOWN")).collect(Collectors.toList()));
        String masterId = this.insertOrUpdateOrganization(masterOrg, user, false);
        orgs.stream().map(OrganizationView::getId).filter(id -> !id.equals(masterId)).forEach(id -> {
            this.hideConflictOrgs(masterId, id);
            this.journalEntryRepository.save((Object)new JournalEntry(id, JournalOperations.FIX_CONFLICT, "The org has been hidded and merged in " + masterId, user));
        });
        List<OpenaireDuplicate> newDuplicates = orgs.stream().map(OrganizationView::getId).map(arg_0 -> ((OpenaireDuplicateRepository)this.openaireDuplicateRepository).findByLocalId(arg_0)).flatMap(Collection::stream).map(d -> new OpenaireDuplicate(masterId, d.getOaOriginalId(), d.getRelType(), d.getOaCollectedFrom())).collect(Collectors.toList());
        this.openaireDuplicateRepository.saveAll(newDuplicates);
        newDuplicates.forEach(d -> {
            this.openaireDuplicateRepository.updateCreatedByIfMissing(d.getLocalId(), d.getOaOriginalId(), user);
            this.openaireDuplicateRepository.updateModificationDate(d.getLocalId(), d.getOaOriginalId(), user, now);
        });
        orgs.forEach(org -> {
            String similarId = org.getId();
            this.openaireConflictRepository.updateMultipleStatusAndResetGroup(similarId, SimilarityType.is_different.toString(), user, now);
        });
        for (int i = 0; i < orgs.size(); ++i) {
            for (int j = i + 1; j < orgs.size(); ++j) {
                this.openaireConflictRepository.updateStatusAndResetGroup(orgs.get(i).getId(), orgs.get(j).getId(), SimilarityType.is_similar.toString(), user, now);
            }
        }
        this.journalEntryRepository.save((Object)new JournalEntry(masterId, JournalOperations.FIX_CONFLICT, finalMessage, user));
        return masterId;
    }

    @Transactional
    public void fixConflictDifferents(List<String> differentsIds, String user) {
        OffsetDateTime now = OffsetDateTime.now();
        String message = "Mark the following orgs as different: " + StringUtils.join(differentsIds, (String)", ");
        for (int i = 0; i < differentsIds.size(); ++i) {
            for (int j = i + 1; j < differentsIds.size(); ++j) {
                this.openaireConflictRepository.updateStatusAndResetGroup(differentsIds.get(i), differentsIds.get(j), SimilarityType.is_different.toString(), user, now);
            }
            this.journalEntryRepository.save((Object)new JournalEntry(differentsIds.get(i), JournalOperations.NO_CONFLICT, message, user));
        }
    }

    @Transactional
    public Optional<User> findUser(String email) {
        return this.userRepository.findById((Object)email);
    }

    @Transactional
    public void updateUserDetails(String email, String fullname, String organization) {
        this.userRepository.updateDetails(email, fullname, organization, OffsetDateTime.now());
    }

    private String findFirstString(List<OrganizationView> views, Function<OrganizationView, String> mapper) {
        return views.stream().map(mapper).filter(StringUtils::isNotBlank).findFirst().orElse(null);
    }

    private Double findFirstNumber(List<OrganizationView> views, Function<OrganizationView, Double> mapper) {
        return views.stream().map(mapper).filter(Objects::nonNull).filter(n -> n != 0.0).findFirst().orElse(0.0);
    }

    private <T> Set<T> findAll(List<OrganizationView> views, Function<OrganizationView, Set<T>> mapper) {
        return views.stream().map(mapper).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private <T> Set<T> findAll(List<OrganizationView> views, Function<OrganizationView, Set<T>> mapper, Predicate<T> filter) {
        return views.stream().map(mapper).flatMap(Collection::stream).filter(filter).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private List<Relationship> hideConflictOrgs(String masterId, String otherId) {
        this.organizationRepository.updateStatus(otherId, OrganizationStatus.hidden.toString());
        this.openaireConflictRepository.findById((Object)new OpenaireConflictPK(masterId, otherId)).ifPresent(arg_0 -> ((OpenaireConflictRepository)this.openaireConflictRepository).delete(arg_0));
        this.openaireConflictRepository.findById((Object)new OpenaireConflictPK(otherId, masterId)).ifPresent(arg_0 -> ((OpenaireConflictRepository)this.openaireConflictRepository).delete(arg_0));
        return this.makeRelation(masterId, otherId, RelationType.Merges);
    }

    public List<String> invalidCountriesInSuggestions() {
        String sql = " select distinct t.oa_country from tmp_dedup_events t left outer join countries c on (t.oa_country = c.val) where c.val is null order by t.oa_country";
        return this.jdbcTemplate.queryForList(" select distinct t.oa_country from tmp_dedup_events t left outer join countries c on (t.oa_country = c.val) where c.val is null order by t.oa_country", String.class);
    }

    public Iterable<PersistentOrganizationView> listPersistentOrgs() {
        return this.persistentOrganizationViewRepository.findAll();
    }

    public String addPersistentOrgs(String id) {
        String ooid;
        boolean valid;
        if (id.length() == 46) {
            Optional orgView = this.organizationViewRepository.findByOpenaireId(id);
            valid = orgView.map(OrganizationView::getStatus).filter(s -> s.equals(OrganizationStatus.approved.toString())).isPresent();
            ooid = ((OrganizationView)orgView.get()).getId();
        } else {
            valid = this.organizationRepository.findById((Object)id).map(Organization::getStatus).filter(s -> s.equals(OrganizationStatus.approved.toString())).isPresent();
            ooid = id;
        }
        if (valid) {
            this.persistentOrganizationRepository.save((Object)new PersistentOrganization(ooid));
            return ooid;
        }
        throw new RuntimeException("The ID does not refer to an approved Organization");
    }

    public void deletePersistentOrgs(String id) {
        this.persistentOrganizationRepository.deleteById((Object)id);
    }

    public List<String> obtainLogEntries(String id) {
        String query = "SELECT o.id, o.name, j.operation, j.description, date(j.op_date) as op_date FROM organizations o JOIN journal j ON o.id = j.id WHERE o.id=? ORDER BY date(j.op_date)";
        return this.jdbcTemplate.queryForList("SELECT o.id, o.name, j.operation, j.description, date(j.op_date) as op_date FROM organizations o JOIN journal j ON o.id = j.id WHERE o.id=? ORDER BY date(j.op_date)", new Object[]{id}).stream().map(arg_0 -> this.asLogEntry(arg_0)).collect(Collectors.toList());
    }

    public List<String> obtainLogEntries(int year, int month, String country) {
        String query = "SELECT o.id, o.name, j.operation, j.description, date(j.op_date) as op_date FROM organizations o JOIN journal j ON o.id = j.id WHERE o.country=? AND extract(year FROM j.op_date)=? AND extract(month FROM j.op_date)=? ORDER BY date(j.op_date), o,id";
        return this.jdbcTemplate.queryForList("SELECT o.id, o.name, j.operation, j.description, date(j.op_date) as op_date FROM organizations o JOIN journal j ON o.id = j.id WHERE o.country=? AND extract(year FROM j.op_date)=? AND extract(month FROM j.op_date)=? ORDER BY date(j.op_date), o,id", new Object[]{country, year, month}).stream().map(arg_0 -> this.asLogEntry(arg_0)).collect(Collectors.toList());
    }

    private String asLogEntry(Map<String, Object> map) {
        JournalOperations op = JournalOperations.valueOf((String)("" + map.get("operation")));
        StringWriter sw = new StringWriter();
        sw.write("On %s a curator ");
        switch (1.$SwitchMap$eu$dnetlib$organizations$utils$JournalOperations[op.ordinal()]) {
            case 1: {
                sw.write("approved the suggested organisation %s (ID: %s)");
                break;
            }
            case 2: {
                sw.write("created the organisation %s (ID: %s)");
                break;
            }
            case 3: {
                sw.write("suggested the organisation %s (ID: %s)");
                break;
            }
            case 4: {
                sw.write("updated the metadata of %s (ID: %s)");
                break;
            }
            case 5: {
                sw.write("updated the metadata of the suggested organisation %s (ID: %s)");
                break;
            }
            case 6: {
                sw.write("updated the list of duplicates for %s (ID: %s)");
                break;
            }
            case 7: {
                sw.write("chose as master the organisation %s (id: %s), which has been involved in a conflict resolution");
                break;
            }
            case 8: {
                sw.write("stated that the conflict where the organisation %s (id: %s) was involved was a false positive");
                break;
            }
            case 9: {
                sw.write("resolved a conflict and the organisation %s (id: %s) involved has been hidden, because another organisation has been chosen as master");
                break;
            }
            default: {
                sw.write("performed an unknown operation on %s (ID: %s)");
            }
        }
        sw.write(". \"%s\"\n");
        return String.format(sw.toString(), map.get("op_date"), map.get("name"), map.get("id"), map.get("description"));
    }
}

