package eu.dnetlib.organizations.repository;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import eu.dnetlib.organizations.model.OpenaireConflict;
import eu.dnetlib.organizations.model.OpenaireConflictPK;
import eu.dnetlib.organizations.model.utils.OrganizationConflict;

@Repository
public interface OpenaireConflictRepository extends JpaRepository<OpenaireConflict, OpenaireConflictPK> {

	@Query(value = "select o.id, o.name, o.type, o.city, o.country from oa_conflicts c left outer join organizations o on (c.id2 = o.id) where o.id is not null and c.id1 = ?", nativeQuery = true)
	List<OrganizationConflict> getConflictsForId(String id);

	Iterable<OpenaireConflict> findById1AndGroupIsNull(String id);

	Iterable<OpenaireConflict> findById2AndGroupIsNull(String id);

	@Modifying
	@Query(value = "update oa_conflicts set idgroup = null", nativeQuery = true)
	void resetGroupIds();

	long countByGroupNull();

}
