/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.organizations.controller;

import eu.dnetlib.organizations.controller.UserRole;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public class UserInfo {
    private String name;
    private UserRole role;

    public UserInfo() {
        this.name = "anonymous";
        this.role = UserRole.NOT_AUTHORIZED;
    }

    public UserInfo(String name, UserRole role) {
        this.name = name;
        this.role = role;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UserRole getRole() {
        return this.role;
    }

    public void setRole(UserRole role) {
        this.role = role;
    }

    public static UserInfo generate(Authentication authentication) {
        return new UserInfo(authentication.getName(), UserInfo.findRole(authentication));
    }

    public static UserRole findRole(Authentication authentication) {
        return authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).map(s -> StringUtils.substringAfter((String)s, (String)"ROLE_")).filter(s -> EnumUtils.isValidEnum(UserRole.class, (String)s)).map(UserRole::valueOf).findFirst().orElseGet(() -> UserRole.NOT_AUTHORIZED);
    }

    public static boolean isSuperAdmin(Authentication authentication) {
        for (GrantedAuthority aut : authentication.getAuthorities()) {
            if (!aut.getAuthority().equals("ROLE_" + (Object)((Object)UserRole.ADMIN))) continue;
            return true;
        }
        return false;
    }

    public static boolean isNationalAdmin(Authentication authentication) {
        for (GrantedAuthority aut : authentication.getAuthorities()) {
            if (!aut.getAuthority().equals("ROLE_" + (Object)((Object)UserRole.NATIONAL_ADMIN))) continue;
            return true;
        }
        return false;
    }

    public static boolean isSimpleUser(Authentication authentication) {
        for (GrantedAuthority aut : authentication.getAuthorities()) {
            if (!aut.getAuthority().equals("ROLE_" + (Object)((Object)UserRole.USER))) continue;
            return true;
        }
        return false;
    }

    public static boolean isPending(Authentication authentication) {
        for (GrantedAuthority aut : authentication.getAuthorities()) {
            if (!aut.getAuthority().equals("ROLE_" + (Object)((Object)UserRole.PENDING))) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotAuthorized(Authentication authentication) {
        for (GrantedAuthority aut : authentication.getAuthorities()) {
            if (!aut.getAuthority().equals("ROLE_" + (Object)((Object)UserRole.NOT_AUTHORIZED))) continue;
            return true;
        }
        return false;
    }
}

