/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.stats_actionsets;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.actionmanager.stats_actionsets.StatsResultEnhancementModel;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.HdfsSupport;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.schema.action.AtomicAction;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.OpenAccessColor;
import eu.dnetlib.dhp.schema.oaf.Result;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class StatsAtomicActionsJob
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(StatsAtomicActionsJob.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static <I extends Result> void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)StatsAtomicActionsJob.class.getResourceAsStream("/eu/dnetlib/dhp/actionmanager/stats_actionsets/input_actionset_parameter.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String outputPath = parser.get("outputPath");
        log.info("outputPath {}: ", (Object)outputPath);
        SparkConf conf = new SparkConf();
        conf.set("hive.metastore.uris", parser.get("hive_metastore_uris"));
        conf.set("spark.speculation", "false");
        conf.set("spark.hadoop.mapreduce.map.speculative", "false");
        conf.set("spark.hadoop.mapreduce.reduce.speculative", "false");
        String dbname = parser.get("statsDB");
        String workingPath = parser.get("workingPath");
        SparkSessionSupport.runWithSparkHiveSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            StatsAtomicActionsJob.removeOutputDir(spark, outputPath);
            StatsAtomicActionsJob.prepareResultEnhancement(dbname, spark, workingPath + "/resultEnhancements", "id");
            StatsAtomicActionsJob.writeActionSet(spark, workingPath, outputPath);
        });
    }

    private static void prepareResultEnhancement(String dbname, SparkSession spark, String workingPath, String resultAttributeName) {
        spark.sql(String.format("select r.%s as id, CASE WHEN g.is_gold = 1 THEN true ELSE false END as is_gold, CASE WHEN b.is_bronze_oa = 1 THEN true ELSE false END as is_bronze_oa, CASE WHEN h.is_hybrid = 1 THEN true ELSE false END as is_hybrid, CASE WHEN gr.green_oa = 1 THEN true ELSE false END as green_oa, CASE WHEN d.in_diamond_journal = 1 THEN true ELSE false END as in_diamond_journal, CASE WHEN f.publicly_funded = 1 THEN true ELSE false END as publicly_funded from %s.publication r left outer join %s.indi_pub_bronze_oa b on r.id=b.id left outer join %s.indi_pub_gold_oa g on r.id=g.id left outer join %s.indi_pub_hybrid h on r.id=h.id left outer join %s.indi_pub_green_oa gr on r.id=gr.id left outer join %s.indi_pub_diamond d on b.id=d.id left outer join %s.indi_pub_publicly_funded f on r.id=f.id ", resultAttributeName, dbname, dbname, dbname, dbname, dbname, dbname, dbname)).as(Encoders.bean(StatsResultEnhancementModel.class)).write().mode(SaveMode.Overwrite).option("compression", "gzip").json(workingPath);
    }

    public static void writeActionSet(SparkSession spark, String inputPath, String outputPath) {
        StatsAtomicActionsJob.getResultEnhancements(spark, inputPath + "/resultEnhancements").toJavaRDD().map((Function & Serializable)p -> new AtomicAction(p.getClass(), (Oaf)p)).mapToPair((PairFunction & Serializable)aa -> new Tuple2((Object)new Text(aa.getClazz().getCanonicalName()), (Object)new Text(OBJECT_MAPPER.writeValueAsString(aa)))).saveAsHadoopFile(outputPath, Text.class, Text.class, SequenceFileOutputFormat.class, GzipCodec.class);
    }

    private static Dataset<Result> getResultEnhancements(SparkSession spark, String inputPath) {
        return StatsAtomicActionsJob.readPath(spark, inputPath, StatsResultEnhancementModel.class).map((MapFunction & Serializable)usm -> {
            Result r = new Result();
            r.setId("50|" + usm.getId());
            r.setIsInDiamondJournal(Boolean.valueOf(usm.isIn_diamond_journal()));
            r.setIsGreen(Boolean.valueOf(usm.isGreen_oa()));
            r.setPubliclyFunded(Boolean.valueOf(usm.isPublicly_funded()));
            if (usm.isIs_gold().booleanValue()) {
                r.setOpenAccessColor(OpenAccessColor.gold);
            } else if (usm.isIs_hybrid().booleanValue()) {
                r.setOpenAccessColor(OpenAccessColor.hybrid);
            } else if (usm.isIs_bronze_oa().booleanValue()) {
                r.setOpenAccessColor(OpenAccessColor.bronze);
            }
            return r;
        }, Encoders.bean(Result.class));
    }

    private static void removeOutputDir(SparkSession spark, String path) {
        HdfsSupport.remove((String)path, (Configuration)spark.sparkContext().hadoopConfiguration());
    }

    public static <R> Dataset<R> readPath(SparkSession spark, String inputPath, Class<R> clazz) {
        return spark.read().textFile(inputPath).map((MapFunction & Serializable)value -> OBJECT_MAPPER.readValue(value, clazz), Encoders.bean(clazz));
    }
}

