/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.oaf;

import eu.dnetlib.dhp.schema.common.AccessRightComparator;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.Context;
import eu.dnetlib.dhp.schema.oaf.Country;
import eu.dnetlib.dhp.schema.oaf.ExternalReference;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.Measure;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class Result
extends OafEntity
implements Serializable {
    private List<Measure> measures;
    private List<Author> author;
    private Qualifier resulttype;
    private Qualifier language;
    private List<Country> country;
    private List<StructuredProperty> subject;
    private List<StructuredProperty> title;
    private List<StructuredProperty> relevantdate;
    private List<Field<String>> description;
    private Field<String> dateofacceptance;
    private Field<String> publisher;
    private Field<String> embargoenddate;
    private List<Field<String>> source;
    private List<Field<String>> fulltext;
    private List<Field<String>> format;
    private List<Field<String>> contributor;
    private Qualifier resourcetype;
    private List<Field<String>> coverage;
    private Qualifier bestaccessright;
    private List<Context> context;
    private List<ExternalReference> externalReference;
    private List<Instance> instance;

    public List<Measure> getMeasures() {
        return this.measures;
    }

    public void setMeasures(List<Measure> measures) {
        this.measures = measures;
    }

    public List<Author> getAuthor() {
        return this.author;
    }

    public void setAuthor(List<Author> author) {
        this.author = author;
    }

    public Qualifier getResulttype() {
        return this.resulttype;
    }

    public void setResulttype(Qualifier resulttype) {
        this.resulttype = resulttype;
    }

    public Qualifier getLanguage() {
        return this.language;
    }

    public void setLanguage(Qualifier language) {
        this.language = language;
    }

    public List<Country> getCountry() {
        return this.country;
    }

    public void setCountry(List<Country> country) {
        this.country = country;
    }

    public List<StructuredProperty> getSubject() {
        return this.subject;
    }

    public void setSubject(List<StructuredProperty> subject) {
        this.subject = subject;
    }

    public List<StructuredProperty> getTitle() {
        return this.title;
    }

    public void setTitle(List<StructuredProperty> title) {
        this.title = title;
    }

    public List<StructuredProperty> getRelevantdate() {
        return this.relevantdate;
    }

    public void setRelevantdate(List<StructuredProperty> relevantdate) {
        this.relevantdate = relevantdate;
    }

    public List<Field<String>> getDescription() {
        return this.description;
    }

    public void setDescription(List<Field<String>> description) {
        this.description = description;
    }

    public Field<String> getDateofacceptance() {
        return this.dateofacceptance;
    }

    public void setDateofacceptance(Field<String> dateofacceptance) {
        this.dateofacceptance = dateofacceptance;
    }

    public Field<String> getPublisher() {
        return this.publisher;
    }

    public void setPublisher(Field<String> publisher) {
        this.publisher = publisher;
    }

    public Field<String> getEmbargoenddate() {
        return this.embargoenddate;
    }

    public void setEmbargoenddate(Field<String> embargoenddate) {
        this.embargoenddate = embargoenddate;
    }

    public List<Field<String>> getSource() {
        return this.source;
    }

    public void setSource(List<Field<String>> source) {
        this.source = source;
    }

    public List<Field<String>> getFulltext() {
        return this.fulltext;
    }

    public void setFulltext(List<Field<String>> fulltext) {
        this.fulltext = fulltext;
    }

    public List<Field<String>> getFormat() {
        return this.format;
    }

    public void setFormat(List<Field<String>> format) {
        this.format = format;
    }

    public List<Field<String>> getContributor() {
        return this.contributor;
    }

    public void setContributor(List<Field<String>> contributor) {
        this.contributor = contributor;
    }

    public Qualifier getResourcetype() {
        return this.resourcetype;
    }

    public void setResourcetype(Qualifier resourcetype) {
        this.resourcetype = resourcetype;
    }

    public List<Field<String>> getCoverage() {
        return this.coverage;
    }

    public void setCoverage(List<Field<String>> coverage) {
        this.coverage = coverage;
    }

    public Qualifier getBestaccessright() {
        return this.bestaccessright;
    }

    public void setBestaccessright(Qualifier bestaccessright) {
        this.bestaccessright = bestaccessright;
    }

    public List<Context> getContext() {
        return this.context;
    }

    public void setContext(List<Context> context) {
        this.context = context;
    }

    public List<ExternalReference> getExternalReference() {
        return this.externalReference;
    }

    public void setExternalReference(List<ExternalReference> externalReference) {
        this.externalReference = externalReference;
    }

    public List<Instance> getInstance() {
        return this.instance;
    }

    public void setInstance(List<Instance> instance) {
        this.instance = instance;
    }

    @Override
    public void mergeFrom(OafEntity e) {
        super.mergeFrom(e);
        if (!Result.class.isAssignableFrom(e.getClass())) {
            return;
        }
        Result r = (Result)e;
        this.measures = this.mergeLists(this.measures, r.getMeasures());
        this.instance = this.mergeLists(this.instance, r.getInstance());
        if (r.getBestaccessright() != null && new AccessRightComparator<Qualifier>().compare(r.getBestaccessright(), this.bestaccessright) < 0) {
            this.bestaccessright = r.getBestaccessright();
        }
        if (r.getResulttype() != null && this.compareTrust(this, r) < 0) {
            this.resulttype = r.getResulttype();
        }
        if (r.getLanguage() != null && this.compareTrust(this, r) < 0) {
            this.language = r.getLanguage();
        }
        if (Objects.nonNull(r.getDateofacceptance())) {
            if (Objects.isNull(this.getDateofacceptance())) {
                this.dateofacceptance = r.getDateofacceptance();
            } else if (this.compareTrust(this, r) < 0) {
                this.dateofacceptance = r.getDateofacceptance();
            }
        }
        this.country = this.mergeLists(this.country, r.getCountry());
        this.subject = this.mergeLists(this.subject, r.getSubject());
        StructuredProperty baseMainTitle = null;
        if (this.title != null && (baseMainTitle = this.getMainTitle(this.title)) != null) {
            StructuredProperty p = baseMainTitle;
            this.title = this.title.stream().filter(t -> t != p).collect(Collectors.toList());
        }
        StructuredProperty newMainTitle = null;
        if (r.getTitle() != null && (newMainTitle = this.getMainTitle(r.getTitle())) != null) {
            StructuredProperty p = newMainTitle;
            r.setTitle(r.getTitle().stream().filter(t -> t != p).collect(Collectors.toList()));
        }
        if (newMainTitle != null && this.compareTrust(this, r) < 0) {
            baseMainTitle = newMainTitle;
        }
        this.title = this.mergeLists(this.title, r.getTitle());
        if (this.title != null && baseMainTitle != null) {
            this.title.add(baseMainTitle);
        }
        this.relevantdate = this.mergeLists(this.relevantdate, r.getRelevantdate());
        this.description = this.longestLists(this.description, r.getDescription());
        if (r.getPublisher() != null && this.compareTrust(this, r) < 0) {
            this.publisher = r.getPublisher();
        }
        if (r.getEmbargoenddate() != null && this.compareTrust(this, r) < 0) {
            this.embargoenddate = r.getEmbargoenddate();
        }
        this.source = this.mergeLists(this.source, r.getSource());
        this.fulltext = this.mergeLists(this.fulltext, r.getFulltext());
        this.format = this.mergeLists(this.format, r.getFormat());
        this.contributor = this.mergeLists(this.contributor, r.getContributor());
        if (r.getResourcetype() != null) {
            this.resourcetype = r.getResourcetype();
        }
        this.coverage = this.mergeLists(this.coverage, r.getCoverage());
        this.context = this.mergeLists(this.context, r.getContext());
        this.externalReference = this.mergeLists(this.externalReference, r.getExternalReference());
    }

    private List<Field<String>> longestLists(List<Field<String>> a, List<Field<String>> b) {
        if (a == null || b == null) {
            return a == null ? b : a;
        }
        if (a.size() == b.size()) {
            int msb;
            int msa = a.stream().filter(i -> i != null && i.getValue() != null).map(i -> ((String)i.getValue()).length()).max(Comparator.naturalOrder()).orElse(0);
            return msa > (msb = b.stream().filter(i -> i != null && i.getValue() != null).map(i -> ((String)i.getValue()).length()).max(Comparator.naturalOrder()).orElse(0).intValue()) ? a : b;
        }
        return a.size() > b.size() ? a : b;
    }

    private StructuredProperty getMainTitle(List<StructuredProperty> titles) {
        for (StructuredProperty title : titles) {
            if (title.getQualifier() == null || title.getQualifier().getClassid() == null || !title.getQualifier().getClassid().equals("main title")) continue;
            return title;
        }
        return null;
    }
}

