/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.oaf;

import com.google.common.base.Preconditions;
import eu.dnetlib.dhp.schema.common.ModelSupport;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Relation
extends Oaf {
    private String relType;
    private String subRelType;
    private String relClass;
    private String source;
    private String target;
    private Boolean validated;
    private String validationDate;
    private List<KeyValue> properties = new ArrayList<KeyValue>();

    public String getRelType() {
        return this.relType;
    }

    public void setRelType(String relType) {
        this.relType = relType;
    }

    public String getSubRelType() {
        return this.subRelType;
    }

    public void setSubRelType(String subRelType) {
        this.subRelType = subRelType;
    }

    public String getRelClass() {
        return this.relClass;
    }

    public void setRelClass(String relClass) {
        this.relClass = relClass;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public List<KeyValue> getProperties() {
        return this.properties;
    }

    public void setProperties(List<KeyValue> properties) {
        this.properties = properties;
    }

    public Boolean getValidated() {
        return Objects.nonNull(this.validated) && this.validated != false;
    }

    public void setValidated(Boolean validated) {
        this.validated = validated;
    }

    public String getValidationDate() {
        return this.validationDate;
    }

    public void setValidationDate(String validationDate) {
        this.validationDate = validationDate;
    }

    public void mergeFrom(Relation r) {
        Preconditions.checkArgument((boolean)Objects.equals(this.getSource(), r.getSource()), (Object)"source ids must be equal");
        Preconditions.checkArgument((boolean)Objects.equals(this.getTarget(), r.getTarget()), (Object)"target ids must be equal");
        Preconditions.checkArgument((boolean)Objects.equals(this.getRelType(), r.getRelType()), (Object)"relType(s) must be equal");
        Preconditions.checkArgument((boolean)Objects.equals(this.getSubRelType(), r.getSubRelType()), (Object)"subRelType(s) must be equal");
        Preconditions.checkArgument((boolean)Objects.equals(this.getRelClass(), r.getRelClass()), (Object)"relClass(es) must be equal");
        this.setValidated(this.getValidated() != false || r.getValidated() != false);
        try {
            this.setValidationDate(ModelSupport.oldest(this.getValidationDate(), r.getValidationDate()));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(String.format("invalid validation date format in relation [s:%s, t:%s]: %s", this.getSource(), this.getTarget(), this.getValidationDate()));
        }
        super.mergeFrom(r);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Relation relation = (Relation)o;
        return this.relType.equals(relation.relType) && this.subRelType.equals(relation.subRelType) && this.relClass.equals(relation.relClass) && this.source.equals(relation.source) && this.target.equals(relation.target);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.relType, this.subRelType, this.relClass, this.source, this.target, this.collectedfrom);
    }
}

