/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.scholexplorer;

import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.scholexplorer.ProvenaceInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DLIDataset
extends Dataset {
    private String originalObjIdentifier;
    private List<ProvenaceInfo> dlicollectedfrom;
    private String completionStatus;

    public String getCompletionStatus() {
        return this.completionStatus;
    }

    public void setCompletionStatus(String completionStatus) {
        this.completionStatus = completionStatus;
    }

    public List<ProvenaceInfo> getDlicollectedfrom() {
        return this.dlicollectedfrom;
    }

    public void setDlicollectedfrom(List<ProvenaceInfo> dlicollectedfrom) {
        this.dlicollectedfrom = dlicollectedfrom;
    }

    public String getOriginalObjIdentifier() {
        return this.originalObjIdentifier;
    }

    public void setOriginalObjIdentifier(String originalObjIdentifier) {
        this.originalObjIdentifier = originalObjIdentifier;
    }

    @Override
    public void mergeFrom(OafEntity e) {
        super.mergeFrom(e);
        DLIDataset p = (DLIDataset)e;
        if (StringUtils.isBlank((CharSequence)this.completionStatus) && StringUtils.isNotBlank((CharSequence)p.completionStatus)) {
            this.completionStatus = p.completionStatus;
        }
        if ("complete".equalsIgnoreCase(p.completionStatus)) {
            this.completionStatus = "complete";
        }
        this.dlicollectedfrom = this.mergeProvenance(this.dlicollectedfrom, p.getDlicollectedfrom());
    }

    private List<ProvenaceInfo> mergeProvenance(List<ProvenaceInfo> a, List<ProvenaceInfo> b) {
        HashMap result = new HashMap();
        if (a != null) {
            a.forEach(p -> {
                if (p != null && StringUtils.isNotBlank((CharSequence)p.getId()) && result.containsKey(p.getId())) {
                    if ("incomplete".equalsIgnoreCase(((ProvenaceInfo)result.get(p.getId())).getCompletionStatus()) && StringUtils.isNotBlank((CharSequence)p.getCompletionStatus())) {
                        result.put(p.getId(), p);
                    }
                } else if (p != null && p.getId() != null && !result.containsKey(p.getId())) {
                    result.put(p.getId(), p);
                }
            });
        }
        if (b != null) {
            b.forEach(p -> {
                if (p != null && StringUtils.isNotBlank((CharSequence)p.getId()) && result.containsKey(p.getId())) {
                    if ("incomplete".equalsIgnoreCase(((ProvenaceInfo)result.get(p.getId())).getCompletionStatus()) && StringUtils.isNotBlank((CharSequence)p.getCompletionStatus())) {
                        result.put(p.getId(), p);
                    }
                } else if (p != null && p.getId() != null && !result.containsKey(p.getId())) {
                    result.put(p.getId(), p);
                }
            });
        }
        return new ArrayList<ProvenaceInfo>(result.values());
    }
}

