/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import eu.dnetlib.dhp.schema.common.EntityType;
import eu.dnetlib.dhp.schema.common.MainEntityType;
import eu.dnetlib.dhp.schema.common.RelationInverse;
import eu.dnetlib.dhp.schema.oaf.AccessRight;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.Context;
import eu.dnetlib.dhp.schema.oaf.Country;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.Datasource;
import eu.dnetlib.dhp.schema.oaf.ExternalReference;
import eu.dnetlib.dhp.schema.oaf.ExtraInfo;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.GeoLocation;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.Journal;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.OAIProvenance;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.OpenAccessRoute;
import eu.dnetlib.dhp.schema.oaf.Organization;
import eu.dnetlib.dhp.schema.oaf.OriginDescription;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Project;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.Software;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class ModelSupport {
    private static final Map<EntityType, MainEntityType> entityMapping = Maps.newHashMap();
    public static final Map<EntityType, Class> entityTypes;
    public static final Map<String, Class> oafTypes;
    public static final Map<Class, String> idPrefixMap;
    public static final Map<String, String> entityIdPrefix;
    public static final Map<String, String> idPrefixEntity;
    public static final Map<String, RelationInverse> relationInverseMap;
    private static final String schemeTemplate = "dnet:%s_%s_relations";
    public static final String[] DATE_TIME_FORMATS;

    private ModelSupport() {
    }

    public static <E extends OafEntity> String getIdPrefix(Class<E> clazz) {
        return idPrefixMap.get(clazz);
    }

    public static <X extends Oaf, Y extends Oaf> Boolean isSubClass(X subClazzObject, Y superClazzObject) {
        return ModelSupport.isSubClass(subClazzObject.getClass(), superClazzObject.getClass());
    }

    public static <X extends Oaf, Y extends Oaf> Boolean isSubClass(X subClazzObject, Class<Y> superClazz) {
        return ModelSupport.isSubClass(subClazzObject.getClass(), superClazz);
    }

    public static <X extends Oaf, Y extends Oaf> Boolean isSubClass(Class<X> subClazz, Class<Y> superClazz) {
        return superClazz.isAssignableFrom(subClazz);
    }

    public static <T extends Oaf> Class<T>[] getOafModelClasses() {
        return new Class[]{Author.class, Context.class, Country.class, DataInfo.class, Dataset.class, Datasource.class, ExternalReference.class, ExtraInfo.class, Field.class, GeoLocation.class, Instance.class, AccessRight.class, OpenAccessRoute.class, Journal.class, KeyValue.class, Oaf.class, OafEntity.class, OAIProvenance.class, Organization.class, OriginDescription.class, OtherResearchProduct.class, Project.class, Publication.class, Qualifier.class, Relation.class, Result.class, Software.class, StructuredProperty.class};
    }

    public static String getMainType(EntityType type) {
        return entityMapping.get((Object)type).name();
    }

    public static boolean isResult(EntityType type) {
        return MainEntityType.result.name().equals(ModelSupport.getMainType(type));
    }

    public static String getScheme(String sourceType, String targetType) {
        return String.format(schemeTemplate, entityMapping.get((Object)EntityType.valueOf(sourceType)).name(), entityMapping.get((Object)EntityType.valueOf(targetType)).name());
    }

    public static <T extends Oaf> String tableIdentifier(String dbName, String tableName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)dbName), (Object)"DB name cannot be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)tableName), (Object)"table name cannot be empty");
        return String.format("%s.%s", dbName, tableName);
    }

    public static <T extends Oaf> String tableIdentifier(String dbName, Class<T> clazz) {
        Preconditions.checkArgument((boolean)Objects.nonNull(clazz), (Object)"clazz is needed to derive the table name, thus cannot be null");
        return ModelSupport.tableIdentifier(dbName, clazz.getSimpleName().toLowerCase());
    }

    public static <T extends Oaf> Function<T, String> idFn() {
        return x -> {
            if (ModelSupport.isSubClass(x, Relation.class).booleanValue()) {
                return ModelSupport.idFnForRelation(x);
            }
            return ModelSupport.idFnForOafEntity(x);
        };
    }

    private static <T extends Oaf> String idFnForRelation(T t) {
        Relation r = (Relation)t;
        return Optional.ofNullable(r.getSource()).map(source -> Optional.ofNullable(r.getTarget()).map(target -> Optional.ofNullable(r.getRelType()).map(relType -> Optional.ofNullable(r.getSubRelType()).map(subRelType -> Optional.ofNullable(r.getRelClass()).map(relClass -> String.join((CharSequence)source, target, relType, subRelType, relClass)).orElse(String.join((CharSequence)source, target, relType, subRelType))).orElse(String.join((CharSequence)source, target, relType))).orElse(String.join((CharSequence)source, target))).orElse((String)source)).orElse(null);
    }

    private static <T extends Oaf> String idFnForOafEntity(T t) {
        return ((OafEntity)t).getId();
    }

    public static String md5(String s) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(s.getBytes(StandardCharsets.UTF_8));
            return new String(Hex.encodeHex((byte[])md.digest()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String generateIdentifier(String originalId, String nsPrefix) {
        return String.format("%s::%s", nsPrefix, ModelSupport.md5(originalId));
    }

    public static String oldest(String dateA, String dateB) throws ParseException {
        if (StringUtils.isBlank((CharSequence)dateA)) {
            return dateB;
        }
        if (StringUtils.isBlank((CharSequence)dateB)) {
            return dateA;
        }
        if (StringUtils.isNotBlank((CharSequence)dateA) && StringUtils.isNotBlank((CharSequence)dateB)) {
            Date a = ModelSupport.tryParse(dateA);
            Date b = ModelSupport.tryParse(dateB);
            if (Objects.nonNull(a) && Objects.nonNull(b)) {
                return a.before(b) ? dateA : dateB;
            }
            return null;
        }
        return null;
    }

    private static Date tryParse(String date) throws DateTimeParseException {
        try {
            return DateUtils.parseDate((String)date, (String[])DATE_TIME_FORMATS);
        }
        catch (ParseException parseException) {
            String formats = String.join((CharSequence)"\n", Arrays.asList(DATE_TIME_FORMATS));
            throw new DateTimeParseException(String.format("cannot parse %s, supported formats: \n%s", date, formats), date, 0);
        }
    }

    static {
        entityMapping.put(EntityType.publication, MainEntityType.result);
        entityMapping.put(EntityType.dataset, MainEntityType.result);
        entityMapping.put(EntityType.otherresearchproduct, MainEntityType.result);
        entityMapping.put(EntityType.software, MainEntityType.result);
        entityMapping.put(EntityType.datasource, MainEntityType.datasource);
        entityMapping.put(EntityType.organization, MainEntityType.organization);
        entityMapping.put(EntityType.project, MainEntityType.project);
        entityTypes = Maps.newHashMap();
        entityTypes.put(EntityType.datasource, Datasource.class);
        entityTypes.put(EntityType.organization, Organization.class);
        entityTypes.put(EntityType.project, Project.class);
        entityTypes.put(EntityType.dataset, Dataset.class);
        entityTypes.put(EntityType.otherresearchproduct, OtherResearchProduct.class);
        entityTypes.put(EntityType.software, Software.class);
        entityTypes.put(EntityType.publication, Publication.class);
        oafTypes = Maps.newHashMap();
        oafTypes.put("datasource", Datasource.class);
        oafTypes.put("organization", Organization.class);
        oafTypes.put("project", Project.class);
        oafTypes.put("dataset", Dataset.class);
        oafTypes.put("otherresearchproduct", OtherResearchProduct.class);
        oafTypes.put("software", Software.class);
        oafTypes.put("publication", Publication.class);
        oafTypes.put("relation", Relation.class);
        idPrefixMap = Maps.newHashMap();
        idPrefixMap.put(Datasource.class, "10");
        idPrefixMap.put(Organization.class, "20");
        idPrefixMap.put(Project.class, "40");
        idPrefixMap.put(Dataset.class, "50");
        idPrefixMap.put(OtherResearchProduct.class, "50");
        idPrefixMap.put(Software.class, "50");
        idPrefixMap.put(Publication.class, "50");
        entityIdPrefix = Maps.newHashMap();
        entityIdPrefix.put("datasource", "10");
        entityIdPrefix.put("organization", "20");
        entityIdPrefix.put("project", "40");
        entityIdPrefix.put("result", "50");
        idPrefixEntity = Maps.newHashMap();
        idPrefixEntity.put("10", "datasource");
        idPrefixEntity.put("20", "organization");
        idPrefixEntity.put("40", "project");
        idPrefixEntity.put("50", "result");
        relationInverseMap = Maps.newHashMap();
        relationInverseMap.put("personResult_authorship_isAuthorOf", new RelationInverse().setRelation("isAuthorOf").setInverse("hasAuthor").setRelType("personResult").setSubReltype("authorship"));
        relationInverseMap.put("personResult_authorship_hasAuthor", new RelationInverse().setInverse("isAuthorOf").setRelation("hasAuthor").setRelType("personResult").setSubReltype("authorship"));
        relationInverseMap.put("projectOrganization_participation_isParticipant", new RelationInverse().setRelation("isParticipant").setInverse("hasParticipant").setRelType("projectOrganization").setSubReltype("participation"));
        relationInverseMap.put("projectOrganization_participation_hasParticipant", new RelationInverse().setInverse("isParticipant").setRelation("hasParticipant").setRelType("projectOrganization").setSubReltype("participation"));
        relationInverseMap.put("resultOrganization_affiliation_hasAuthorInstitution", new RelationInverse().setRelation("hasAuthorInstitution").setInverse("isAuthorInstitutionOf").setRelType("resultOrganization").setSubReltype("affiliation"));
        relationInverseMap.put("resultOrganization_affiliation_isAuthorInstitutionOf", new RelationInverse().setInverse("hasAuthorInstitution").setRelation("isAuthorInstitutionOf").setRelType("resultOrganization").setSubReltype("affiliation"));
        relationInverseMap.put("organizationOrganization_dedup_merges", new RelationInverse().setRelation("merges").setInverse("isMergedIn").setRelType("organizationOrganization").setSubReltype("dedup"));
        relationInverseMap.put("organizationOrganization_dedup_isMergedIn", new RelationInverse().setInverse("merges").setRelation("isMergedIn").setRelType("organizationOrganization").setSubReltype("dedup"));
        relationInverseMap.put("organizationOrganization_dedupSimilarity_isSimilarTo", new RelationInverse().setInverse("isSimilarTo").setRelation("isSimilarTo").setRelType("organizationOrganization").setSubReltype("dedup"));
        relationInverseMap.put("resultProject_outcome_isProducedBy", new RelationInverse().setRelation("isProducedBy").setInverse("produces").setRelType("resultProject").setSubReltype("outcome"));
        relationInverseMap.put("resultProject_outcome_produces", new RelationInverse().setInverse("isProducedBy").setRelation("produces").setRelType("resultProject").setSubReltype("outcome"));
        relationInverseMap.put("projectPerson_contactPerson_isContact", new RelationInverse().setRelation("isContact").setInverse("hasContact").setRelType("projectPerson").setSubReltype("contactPerson"));
        relationInverseMap.put("projectPerson_contactPerson_hasContact", new RelationInverse().setInverse("isContact").setRelation("hasContact").setRelType("personPerson").setSubReltype("coAuthorship"));
        relationInverseMap.put("personPerson_coAuthorship_isCoauthorOf", new RelationInverse().setInverse("isCoAuthorOf").setRelation("isCoAuthorOf").setRelType("personPerson").setSubReltype("coAuthorship"));
        relationInverseMap.put("personPerson_dedup_merges", new RelationInverse().setInverse("isMergedIn").setRelation("merges").setRelType("personPerson").setSubReltype("dedup"));
        relationInverseMap.put("personPerson_dedup_isMergedIn", new RelationInverse().setInverse("merges").setRelation("isMergedIn").setRelType("personPerson").setSubReltype("dedup"));
        relationInverseMap.put("personPerson_dedupSimilarity_isSimilarTo", new RelationInverse().setInverse("isSimilarTo").setRelation("isSimilarTo").setRelType("personPerson").setSubReltype("dedup"));
        relationInverseMap.put("datasourceOrganization_provision_isProvidedBy", new RelationInverse().setInverse("provides").setRelation("isProvidedBy").setRelType("datasourceOrganization").setSubReltype("provision"));
        relationInverseMap.put("datasourceOrganization_provision_provides", new RelationInverse().setInverse("isProvidedBy").setRelation("provides").setRelType("datasourceOrganization").setSubReltype("provision"));
        relationInverseMap.put("resultResult_similarity_hasAmongTopNSimilarDocuments", new RelationInverse().setInverse("isAmongTopNSimilarDocuments").setRelation("hasAmongTopNSimilarDocuments").setRelType("resultResult").setSubReltype("similarity"));
        relationInverseMap.put("resultResult_similarity_isAmongTopNSimilarDocuments", new RelationInverse().setInverse("hasAmongTopNSimilarDocuments").setRelation("isAmongTopNSimilarDocuments").setRelType("resultResult").setSubReltype("similarity"));
        relationInverseMap.put("resultResult_relationship_isRelatedTo", new RelationInverse().setInverse("isRelatedTo").setRelation("isRelatedTo").setRelType("resultResult").setSubReltype("relationship"));
        relationInverseMap.put("resultResult_supplement_isSupplementTo", new RelationInverse().setInverse("isSupplementedBy").setRelation("isSupplementTo").setRelType("resultResult").setSubReltype("supplement"));
        relationInverseMap.put("resultResult_supplement_isSupplementedBy", new RelationInverse().setInverse("isSupplementTo").setRelation("isSupplementedBy").setRelType("resultResult").setSubReltype("supplement"));
        relationInverseMap.put("resultResult_part_isPartOf", new RelationInverse().setInverse("hasPart").setRelation("isPartOf").setRelType("resultResult").setSubReltype("part"));
        relationInverseMap.put("resultResult_part_hasPart", new RelationInverse().setInverse("isPartOf").setRelation("hasPart").setRelType("resultResult").setSubReltype("part"));
        relationInverseMap.put("resultResult_dedup_merges", new RelationInverse().setInverse("isMergedIn").setRelation("merges").setRelType("resultResult").setSubReltype("dedup"));
        relationInverseMap.put("resultResult_dedup_isMergedIn", new RelationInverse().setInverse("merges").setRelation("isMergedIn").setRelType("resultResult").setSubReltype("dedup"));
        relationInverseMap.put("resultResult_dedupSimilarity_isSimilarTo", new RelationInverse().setInverse("isSimilarTo").setRelation("isSimilarTo").setRelType("resultResult").setSubReltype("dedup"));
        DATE_TIME_FORMATS = new String[]{"yyyy-MM-dd'T'hh:mm:ss.SSS'Z'", "yyyy-MM-dd'T'hh:mm:ss'Z'", "yyyy-MM-dd hh:mm:ss'Z'", "yyyy-MM-dd hh:mm:ss", "yyyy-MM-dd"};
    }
}

