/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.sx.scholix;

import eu.dnetlib.dhp.schema.sx.scholix.ScholixComparator;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixEntityId;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ScholixCollectedFrom
implements Serializable,
Comparable<ScholixCollectedFrom> {
    private ScholixEntityId provider;
    private String provisionMode;
    private String completionStatus;

    public ScholixCollectedFrom() {
    }

    public ScholixCollectedFrom(ScholixEntityId provider, String provisionMode, String completionStatus) {
        this.provider = provider;
        this.provisionMode = provisionMode;
        this.completionStatus = completionStatus;
    }

    public ScholixEntityId getProvider() {
        return this.provider;
    }

    public void setProvider(ScholixEntityId provider) {
        this.provider = provider;
    }

    public String getProvisionMode() {
        return this.provisionMode;
    }

    public void setProvisionMode(String provisionMode) {
        this.provisionMode = provisionMode;
    }

    public String getCompletionStatus() {
        return this.completionStatus;
    }

    public void setCompletionStatus(String completionStatus) {
        this.completionStatus = completionStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScholixCollectedFrom)) {
            return false;
        }
        ScholixCollectedFrom that = (ScholixCollectedFrom)o;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.provider, ScholixComparator.normalizeString(this.provisionMode), ScholixComparator.normalizeString(this.completionStatus));
    }

    @Override
    public int compareTo(ScholixCollectedFrom other) {
        if (other == null) {
            return -1;
        }
        int provModeCompare = StringUtils.compare((String)ScholixComparator.normalizeString(this.provisionMode), (String)ScholixComparator.normalizeString(other.getProvisionMode()));
        int compStatusCompare = StringUtils.compare((String)ScholixComparator.normalizeString(this.completionStatus), (String)ScholixComparator.normalizeString(other.getCompletionStatus()));
        if (this.provider == null && other.getProvider() == null) {
            return provModeCompare == 0 ? compStatusCompare : provModeCompare;
        }
        if (this.provider == null) {
            return 1;
        }
        if (other.getProvider() == null) {
            return -1;
        }
        int provCompare = this.provider.compareTo(other.getProvider());
        if (provCompare == 0) {
            return provModeCompare == 0 ? compStatusCompare : provModeCompare;
        }
        return provCompare;
    }
}

