/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.sx.api.model.v2;

import com.fasterxml.jackson.annotation.JsonProperty;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixIdentifier;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.validation.constraints.NotBlank;

public class ScholixIdentifierType {
    @NotBlank
    @JsonProperty(value="ID")
    private String id = null;
    @NotBlank
    @JsonProperty(value="IDScheme")
    private String idScheme = null;
    @NotBlank
    @JsonProperty(value="IDURL")
    private String idURL = null;

    @Schema(description="The identifier")
    public String getId() {
        return this.id;
    }

    public ScholixIdentifierType setId(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="The scheme or namespace of the identifier string")
    public String getIdScheme() {
        return this.idScheme;
    }

    public ScholixIdentifierType setIdScheme(String idScheme) {
        this.idScheme = idScheme;
        return this;
    }

    @Schema(description="An internet resolvable form of the identifier")
    public String getIdURL() {
        return this.idURL;
    }

    public ScholixIdentifierType setIdURL(String idURL) {
        this.idURL = idURL;
        return this;
    }

    public static ScholixIdentifierType fromScholixIdentifier(ScholixIdentifier input) {
        if (input == null) {
            return null;
        }
        ScholixIdentifierType instance = new ScholixIdentifierType();
        instance.setId(input.getIdentifier());
        instance.setIdScheme(input.getSchema());
        instance.setIdURL(input.getUrl());
        return instance;
    }
}

