/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.manager;

import eu.dnetlib.common.app.AbstractDnetApp;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.cache.annotation.EnableCaching;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@SpringBootApplication
@EnableSwagger2
@EnableCaching
@EntityScan(value={"eu.dnetlib.dhp.schema.mdstore"})
public class MainApplication
extends AbstractDnetApp {
    @Value(value="${dhp.swagger.api.host}")
    private String swaggetHost;
    @Value(value="${dhp.swagger.api.basePath}")
    private String swaggerPath;

    public static void main(String[] args) {
        SpringApplication.run(MainApplication.class, (String[])args);
    }

    protected void configSwagger(Docket docket) {
        docket.host(this.swaggetHost).pathMapping(this.swaggerPath).select().apis(RequestHandlerSelectors.any()).paths(p -> p.startsWith("/mdstores")).build().apiInfo(new ApiInfoBuilder().title("MDStore Manager APIs").description("APIs documentation").version("1.1").contact(ApiInfo.DEFAULT_CONTACT).license("Apache 2.0").licenseUrl("http://www.apache.org/licenses/LICENSE-2.0").build());
    }
}

