/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.sx.provision;

import co.elastic.clients.elasticsearch.core.bulk.BulkOperation;
import co.elastic.clients.elasticsearch.core.bulk.IndexOperation;
import co.elastic.clients.util.BinaryData;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConvertScholixResourceToES
implements Function<String, BulkOperation> {
    private static final Pattern summaryIDPattern = Pattern.compile("\"dnetIdentifier\":\"(\\d{2}\\|.{12}::.{32})\"");
    private static final Pattern summaryTypePattern = Pattern.compile("\"objectType\":\"((\\d|\\w)*)\"");
    private final String index;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public ConvertScholixResourceToES(String index) {
        this.index = index;
    }

    private String search(String text, Pattern pattern) {
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    @Override
    public BulkOperation apply(String rawJson) {
        try {
            String dnetIdentifier = this.search(rawJson, summaryIDPattern);
            String objectType = this.search(rawJson, summaryTypePattern);
            HashMap<String, String> d = new HashMap<String, String>();
            d.put("objectType", objectType);
            d.put("body", rawJson);
            String data = MAPPER.writeValueAsString(d);
            BulkOperation result = (BulkOperation)new BulkOperation.Builder().index(i -> ((IndexOperation.Builder)((IndexOperation.Builder)i.index(this.index)).id(dnetIdentifier)).document((Object)BinaryData.of((byte[])data.getBytes(StandardCharsets.UTF_8), (String)"application/json"))).build();
            return result;
        }
        catch (Throwable e) {
            throw new RuntimeException("Error processing JSON: " + rawJson, e);
        }
    }
}

