/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.provision.model;

import com.google.common.base.Objects;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Maps;
import eu.dnetlib.dhp.schema.oaf.Relation;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;

public class SortableRelationKey
implements Comparable<SortableRelationKey>,
Serializable {
    private static final Map<String, Integer> weights = Maps.newHashMap();
    private static final long serialVersionUID = 3232323L;
    private String groupingKey;
    private String subRelType;

    public static SortableRelationKey create(Relation r, String groupingKey) {
        SortableRelationKey sr = new SortableRelationKey();
        sr.setGroupingKey(groupingKey);
        sr.setSubRelType(r.getSubRelType());
        return sr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortableRelationKey that = (SortableRelationKey)o;
        return this.getGroupingKey().equals(that.getGroupingKey());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getGroupingKey()});
    }

    @Override
    public int compareTo(SortableRelationKey o) {
        return ComparisonChain.start().compare((Comparable)((Object)this.getGroupingKey()), (Comparable)((Object)o.getGroupingKey())).compare((Comparable)this.getWeight(this), (Comparable)this.getWeight(o)).result();
    }

    private Integer getWeight(SortableRelationKey o) {
        return Optional.ofNullable(weights.get(o.getSubRelType())).orElse(Integer.MAX_VALUE);
    }

    public String getSubRelType() {
        return this.subRelType;
    }

    public void setSubRelType(String subRelType) {
        this.subRelType = subRelType;
    }

    public String getGroupingKey() {
        return this.groupingKey;
    }

    public void setGroupingKey(String groupingKey) {
        this.groupingKey = groupingKey;
    }

    static {
        weights.put("participation", 0);
        weights.put("outcome", 1);
        weights.put("affiliation", 2);
        weights.put("dedup", 3);
        weights.put("publicationDataset", 4);
        weights.put("supplement", 5);
        weights.put("review", 6);
        weights.put("relationship", 7);
        weights.put("part", 8);
        weights.put("provision", 9);
        weights.put("version", 10);
        weights.put("similarity", 11);
        weights.put("citation", 12);
    }
}

