/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.provision;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.oa.provision.AbstractSolrRecordTransformJob;
import eu.dnetlib.dhp.oa.provision.model.SerializableSolrInputDocument;
import eu.dnetlib.dhp.oa.provision.model.TupleWrapper;
import eu.dnetlib.dhp.oa.provision.utils.ISLookupClient;
import eu.dnetlib.dhp.oa.provision.utils.StreamingInputDocumentFactory;
import eu.dnetlib.dhp.utils.ISLookupClientFactory;
import eu.dnetlib.dhp.utils.saxon.SaxonTransformerFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrRecordDumpJob
extends AbstractSolrRecordTransformJob {
    private static final Logger log = LoggerFactory.getLogger(SolrRecordDumpJob.class);
    private static final Integer DEFAULT_BATCH_SIZE = 1000;
    private final String inputPath;
    private final String shadowFormat;
    private final String outputPath;
    private final SparkSession spark;

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)SolrRecordDumpJob.class.getResourceAsStream("/eu/dnetlib/dhp/oa/provision/input_params_solr_record_dump.json")));
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String inputPath = parser.get("inputPath");
        log.info("inputPath: {}", (Object)inputPath);
        String shadowFormat = parser.get("shadowFormat");
        log.info("shadowFormat: {}", (Object)shadowFormat);
        String outputPath = Optional.ofNullable(parser.get("outputPath")).map(StringUtils::trim).orElse(null);
        log.info("outputPath: {}", (Object)outputPath);
        Integer batchSize = Optional.ofNullable(parser.get("batchSize")).map(Integer::valueOf).orElse(DEFAULT_BATCH_SIZE);
        log.info("batchSize: {}", (Object)batchSize);
        boolean shouldIndex = Optional.ofNullable(parser.get("shouldIndex")).map(Boolean::valueOf).orElse(false);
        log.info("shouldIndex: {}", (Object)shouldIndex);
        SparkConf conf = new SparkConf();
        conf.registerKryoClasses(new Class[]{SerializableSolrInputDocument.class});
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            String isLookupUrl = parser.get("isLookupUrl");
            log.info("isLookupUrl: {}", (Object)isLookupUrl);
            ISLookupClient isLookup = new ISLookupClient(ISLookupClientFactory.getLookUpService((String)isLookupUrl));
            new SolrRecordDumpJob((SparkSession)spark, inputPath, shadowFormat, outputPath).run(isLookup);
        });
    }

    public SolrRecordDumpJob(SparkSession spark, String inputPath, String shadowFormat, String outputPath) {
        this.spark = spark;
        this.inputPath = inputPath;
        this.shadowFormat = shadowFormat;
        this.outputPath = outputPath;
    }

    public void run(ISLookupClient isLookup) throws ISLookUpException, TransformerException {
        String fields = isLookup.getLayoutSource(this.shadowFormat);
        log.info("fields: {}", (Object)fields);
        String xslt = isLookup.getLayoutTransformer();
        String indexRecordXslt = SolrRecordDumpJob.getLayoutTransformer(this.shadowFormat, fields, xslt);
        log.info("indexRecordTransformer {}", (Object)indexRecordXslt);
        Encoder encoder = Encoders.bean(TupleWrapper.class);
        this.spark.read().schema(encoder.schema()).json(this.inputPath).as(encoder).map((MapFunction & Serializable)t -> new TupleWrapper(SolrRecordDumpJob.toIndexRecord(SaxonTransformerFactory.newInstance((String)indexRecordXslt), t.getXml()), t.getJson()), Encoders.bean(TupleWrapper.class)).map((MapFunction & Serializable)t -> {
            SolrInputDocument s = new StreamingInputDocumentFactory().parseDocument(t.getXml(), t.getJson());
            return new SerializableSolrInputDocument((Map<String, SolrInputField>)s);
        }, Encoders.kryo(SerializableSolrInputDocument.class)).write().mode(SaveMode.Overwrite).parquet(this.outputPath);
    }
}

