/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.provision.utils;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISLookupClient {
    private static final Logger log = LoggerFactory.getLogger(ISLookupClient.class);
    private ISLookUpService isLookup;

    public ISLookupClient(ISLookUpService isLookup) {
        this.isLookup = isLookup;
    }

    public String getLayoutSource(String format) throws ISLookUpException {
        return this.doLookup(String.format("collection('')//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'MDFormatDSResourceType' and .//NAME='%s']//LAYOUT[@name='%s']", format, "index"));
    }

    public String getLayoutTransformer() throws ISLookUpException {
        return this.doLookup("collection('/db/DRIVER/TransformationRuleDSResources/TransformationRuleDSResourceType')//RESOURCE_PROFILE[./BODY/CONFIGURATION/SCRIPT/TITLE/text() = 'openaireLayoutToRecordStylesheet']//CODE/node()");
    }

    public String getDsId(String format) throws ISLookUpException {
        return this.doLookup(String.format("collection('/db/DRIVER/IndexDSResources/IndexDSResourceType')//RESOURCE_PROFILE[./BODY/CONFIGURATION/METADATA_FORMAT/text() = '%s']//RESOURCE_IDENTIFIER/@value/string()", format));
    }

    public String getZkHost() throws ISLookUpException {
        return this.doLookup("for $x in /RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='IndexServiceResourceType'] return $x//PROTOCOL[./@name='solr']/@address/string()");
    }

    private String doLookup(String xquery) throws ISLookUpException {
        log.info("running xquery: {}", (Object)xquery);
        String res = this.getIsLookup().getResourceProfileByQuery(xquery);
        log.info("got response (100 chars): {} ...", (Object)StringUtils.left((String)res, (int)100));
        return res;
    }

    public ISLookUpService getIsLookup() {
        return this.isLookup;
    }

    public void setIsLookup(ISLookUpService isLookup) {
        this.isLookup = isLookup;
    }
}

