/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.provision;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.HdfsSupport;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.oa.provision.model.ProvisionModelSupport;
import eu.dnetlib.dhp.oa.provision.model.RelatedEntity;
import eu.dnetlib.dhp.oa.provision.model.RelatedEntityWrapper;
import eu.dnetlib.dhp.schema.common.EntityType;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.Datasource;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.Organization;
import eu.dnetlib.dhp.schema.oaf.Person;
import eu.dnetlib.dhp.schema.oaf.Project;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.utils.DHPUtils;
import eu.dnetlib.dhp.utils.InputType;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class CreateRelatedEntitiesJob_phase1 {
    private static final Logger log = LoggerFactory.getLogger(CreateRelatedEntitiesJob_phase1.class);

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)Objects.requireNonNull(CreateRelatedEntitiesJob_phase1.class.getResourceAsStream("/eu/dnetlib/dhp/oa/provision/input_params_related_entities_pahase1.json")));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String inputRelationsPath = parser.get("inputRelationsPath");
        log.info("inputRelationsPath: {}", (Object)inputRelationsPath);
        InputType inputType = Optional.ofNullable(parser.get("inputType")).map(InputType::valueOf).orElse(InputType.HDFS_JSON);
        log.info("inputType: {}", (Object)inputType);
        String inputGraph = parser.get("inputGraph");
        log.info("inputGraph: {}", (Object)inputGraph);
        String outputPath = parser.get("outputPath");
        log.info("outputPath: {}", (Object)outputPath);
        String graphTableClassName = parser.get("graphTableClassName");
        log.info("graphTableClassName: {}", (Object)graphTableClassName);
        Class<?> entityClazz = Class.forName(graphTableClassName);
        String hiveMetastoreUris = parser.get("hiveMetastoreUris");
        log.info("hiveMetastoreUris: {}", (Object)hiveMetastoreUris);
        SparkConf conf = new SparkConf();
        conf.set("hive.metastore.uris", hiveMetastoreUris);
        conf.set("spark.hadoop.hive.metastore.uris", hiveMetastoreUris);
        conf.set("spark.sql.catalogImplementation", "hive");
        conf.set("spark.serializer", "org.apache.spark.serializer.KryoSerializer");
        conf.registerKryoClasses(ProvisionModelSupport.getModelClasses());
        SparkSessionSupport.runWithSparkHiveSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            CreateRelatedEntitiesJob_phase1.removeOutputDir(spark, outputPath);
            CreateRelatedEntitiesJob_phase1.joinRelationEntity(spark, inputRelationsPath, inputType, inputGraph, entityClazz, outputPath);
        });
    }

    private static <E extends OafEntity> void joinRelationEntity(SparkSession spark, String inputRelationsPath, InputType inputType, String inputGraph, Class<E> clazz, String outputPath) {
        Dataset relsByTarget = CreateRelatedEntitiesJob_phase1.readPathRelation(spark, inputRelationsPath).map((MapFunction & Serializable)r -> new Tuple2((Object)r.getTarget(), r), Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.kryo(Relation.class)));
        Dataset entities = DHPUtils.readGraphAs((SparkSession)spark, (InputType)inputType, (String)inputGraph, clazz).filter("dataInfo.invisible == false").map((MapFunction & Serializable)e -> new Tuple2((Object)e.getId(), (Object)CreateRelatedEntitiesJob_phase1.asRelatedEntity(e, clazz)), Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.kryo(RelatedEntity.class)));
        relsByTarget.joinWith(entities, entities.col("_1").equalTo((Object)relsByTarget.col("_1")), "inner").map((MapFunction & Serializable)t -> new RelatedEntityWrapper((Relation)((Tuple2)t._1())._2(), (RelatedEntity)((Tuple2)t._2())._2()), Encoders.kryo(RelatedEntityWrapper.class)).write().mode(SaveMode.Overwrite).parquet(outputPath);
    }

    public static <E extends OafEntity> RelatedEntity asRelatedEntity(E entity, Class<E> clazz) {
        RelatedEntity re = new RelatedEntity();
        re.setId(entity.getId());
        re.setType(EntityType.fromClass(clazz).name());
        if (Objects.nonNull(entity.getPid())) {
            re.setPid(entity.getPid().stream().limit(400L).collect(Collectors.toList()));
        }
        re.setCollectedfrom(entity.getCollectedfrom());
        switch (EntityType.fromClass(clazz)) {
            case publication: 
            case dataset: 
            case otherresearchproduct: 
            case software: {
                Result result = (Result)entity;
                if (Objects.nonNull(result.getTitle()) && !result.getTitle().isEmpty()) {
                    result.getTitle().stream().filter(t -> StringUtils.isNotBlank((CharSequence)t.getValue())).findFirst().ifPresent(title -> {
                        re.setTitle((StructuredProperty)title);
                        re.getTitle().setValue(StringUtils.left((String)title.getValue(), (int)5000));
                    });
                }
                if (Objects.nonNull(result.getDescription()) && !result.getDescription().isEmpty()) {
                    result.getDescription().stream().filter(d -> Objects.nonNull(d.getValue())).map(Field::getValue).max(Comparator.comparingInt(String::length)).ifPresent(d -> re.setDescription(StringUtils.left((String)d, (int)500)));
                }
                if (Objects.nonNull(result.getAuthor()) && !result.getAuthor().isEmpty()) {
                    re.setAuthor(result.getAuthor().stream().map(Author::getFullname).filter(StringUtils::isNotBlank).collect(Collectors.toList()));
                }
                re.setDateofacceptance(CreateRelatedEntitiesJob_phase1.getValue((Field<String>)result.getDateofacceptance()));
                re.setPublisher(CreateRelatedEntitiesJob_phase1.getValue((Field<String>)result.getPublisher()));
                re.setResulttype(result.getResulttype());
                if (!Objects.nonNull(result.getInstance())) break;
                re.setInstances(result.getInstance().stream().filter(Objects::nonNull).limit(10L).collect(Collectors.toList()));
                break;
            }
            case datasource: {
                Datasource d2 = (Datasource)entity;
                re.setOfficialname(CreateRelatedEntitiesJob_phase1.getValue((Field<String>)d2.getOfficialname()));
                re.setWebsiteurl(CreateRelatedEntitiesJob_phase1.getValue((Field<String>)d2.getWebsiteurl()));
                re.setDatasourcetype(d2.getDatasourcetype());
                re.setDatasourcetypeui(d2.getDatasourcetypeui());
                re.setOpenairecompatibility(d2.getOpenairecompatibility());
                break;
            }
            case organization: {
                Organization o = (Organization)entity;
                re.setLegalname(CreateRelatedEntitiesJob_phase1.getValue((Field<String>)o.getLegalname()));
                re.setLegalshortname(CreateRelatedEntitiesJob_phase1.getValue((Field<String>)o.getLegalshortname()));
                re.setCountry(o.getCountry());
                re.setWebsiteurl(CreateRelatedEntitiesJob_phase1.getValue((Field<String>)o.getWebsiteurl()));
                break;
            }
            case project: {
                Project p = (Project)entity;
                re.setProjectTitle(CreateRelatedEntitiesJob_phase1.getValue((Field<String>)p.getTitle()));
                re.setCode(CreateRelatedEntitiesJob_phase1.getValue((Field<String>)p.getCode()));
                re.setAcronym(CreateRelatedEntitiesJob_phase1.getValue((Field<String>)p.getAcronym()));
                re.setContracttype(p.getContracttype());
                re.setStartDate(CreateRelatedEntitiesJob_phase1.getValue((Field<String>)p.getStartdate()));
                re.setEndDate(CreateRelatedEntitiesJob_phase1.getValue((Field<String>)p.getEnddate()));
                List f = p.getFundingtree();
                if (f.isEmpty()) break;
                re.setFundingtree(f.stream().map(Field::getValue).collect(Collectors.toList()));
                break;
            }
            case person: {
                Person person = (Person)entity;
                re.setGivenName(person.getGivenName());
                re.setFamilyName(person.getFamilyName());
                re.setAlternativeNames(person.getAlternativeNames());
            }
        }
        return re;
    }

    private static String getValue(Field<String> field) {
        return CreateRelatedEntitiesJob_phase1.getFieldValueWithDefault(field, "");
    }

    private static <T> T getFieldValueWithDefault(Field<T> f, T defaultValue) {
        return (T)Optional.ofNullable(f).filter(Objects::nonNull).map(Field::getValue).orElse(defaultValue);
    }

    private static Dataset<Relation> readPathRelation(SparkSession spark, String relationPath) {
        log.info("Reading relations from: {}", (Object)relationPath);
        return spark.read().load(relationPath).as(Encoders.bean(Relation.class));
    }

    private static void removeOutputDir(SparkSession spark, String path) {
        HdfsSupport.remove((String)path, (Configuration)spark.sparkContext().hadoopConfiguration());
    }
}

