/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.provision;

import eu.dnetlib.dhp.oa.provision.SolrTest;
import eu.dnetlib.dhp.oa.provision.XmlIndexingJob;
import eu.dnetlib.dhp.oa.provision.XmlIndexingJobTest;
import eu.dnetlib.dhp.oa.provision.model.SerializableSolrInputDocument;
import eu.dnetlib.dhp.oa.provision.utils.ISLookupClient;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class SolrConfigTest
extends SolrTest {
    protected static SparkSession spark;
    private static final Integer batchSize;
    @Mock
    private ISLookUpService isLookUpService;
    @Mock
    private ISLookupClient isLookupClient;

    @BeforeEach
    public void prepareMocks() throws ISLookUpException, IOException {
        this.isLookupClient.setIsLookup(this.isLookUpService);
        int solrPort = URI.create("http://" + miniCluster.getZkClient().getZkServerAddress()).getPort();
        Mockito.when((Object)this.isLookupClient.getZkHost()).thenReturn((Object)String.format("127.0.0.1:%s/solr", solrPort));
        Mockito.when((Object)this.isLookupClient.getLayoutSource(Mockito.anyString())).thenReturn((Object)IOUtils.toString((InputStream)this.getClass().getResourceAsStream("fields.xml")));
        Mockito.when((Object)this.isLookupClient.getLayoutTransformer()).thenReturn((Object)IOUtils.toString((InputStream)this.getClass().getResourceAsStream("layoutToRecordTransformer.xsl")));
    }

    @BeforeAll
    public static void before() {
        SparkConf conf = new SparkConf();
        conf.setAppName(XmlIndexingJobTest.class.getSimpleName());
        conf.registerKryoClasses(new Class[]{SerializableSolrInputDocument.class});
        conf.setMaster("local[1]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.resolve("spark").toString());
        spark = SparkSession.builder().appName(XmlIndexingJobTest.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterAll
    public static void tearDown() {
        spark.stop();
    }

    @Test
    public void testSolrConfig() throws Exception {
        String[] queryStrings;
        String inputPath = "src/test/resources/eu/dnetlib/dhp/oa/provision/xml";
        new XmlIndexingJob(spark, inputPath, "c1", "shadow", batchSize, Boolean.valueOf(false)).run(this.isLookupClient);
        Assertions.assertEquals((int)0, (int)miniCluster.getSolrClient().commit("shadow").getStatus());
        for (String q : queryStrings = new String[]{"cancer", "graph", "graphs"}) {
            SolrQuery query = new SolrQuery();
            query.add("q", new String[]{q});
            log.info("Submit query to Solr with params: {}", (Object)query);
            QueryResponse rsp = miniCluster.getSolrClient().query("shadow", (SolrParams)query);
            for (SolrDocument doc : rsp.getResults()) {
                System.out.println(doc.get((Object)"__indexrecordidentifier") + "\t" + doc.get((Object)"__result") + "\t");
            }
        }
    }

    static {
        batchSize = 100;
    }
}

