/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.provision;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.oa.provision.AbstractSolrRecordTransformJob;
import eu.dnetlib.dhp.oa.provision.ProvisionConstants;
import eu.dnetlib.dhp.oa.provision.model.SerializableSolrInputDocument;
import eu.dnetlib.dhp.oa.provision.model.TupleWrapper;
import eu.dnetlib.dhp.oa.provision.utils.ISLookupClient;
import eu.dnetlib.dhp.oa.provision.utils.StreamingInputDocumentFactory;
import eu.dnetlib.dhp.schema.solr.Funder;
import eu.dnetlib.dhp.schema.solr.Funding;
import eu.dnetlib.dhp.schema.solr.RecordType;
import eu.dnetlib.dhp.schema.solr.SolrRecord;
import eu.dnetlib.dhp.sparksolr.DHPSolrSupport;
import eu.dnetlib.dhp.utils.ISLookupClientFactory;
import eu.dnetlib.dhp.utils.saxon.SaxonTransformerFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.IOUtils;
import org.apache.solr.common.SolrInputDocument;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlIndexingJob
extends AbstractSolrRecordTransformJob {
    private static final Logger log = LoggerFactory.getLogger(XmlIndexingJob.class);
    private static final Integer DEFAULT_BATCH_SIZE = 1000;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    private final String inputPath;
    private final String format;
    private final String shadowCollection;
    private final int batchSize;
    private final Boolean shouldFilterXmlPayload;
    private final SparkSession spark;

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)XmlIndexingJob.class.getResourceAsStream("/eu/dnetlib/dhp/oa/provision/input_params_update_index.json")));
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String inputPath = parser.get("inputPath");
        log.info("inputPath: {}", (Object)inputPath);
        String shadowFormat = parser.get("shadowFormat");
        log.info("shadowFormat: {}", (Object)shadowFormat);
        String shadowCollection = ProvisionConstants.getCollectionName(shadowFormat);
        log.info("shadowCollection: {}", (Object)shadowCollection);
        Integer batchSize = Optional.ofNullable(parser.get("batchSize")).map(Integer::valueOf).orElse(DEFAULT_BATCH_SIZE);
        log.info("batchSize: {}", (Object)batchSize);
        Boolean shouldFilterXmlPayload = Optional.ofNullable(parser.get("shouldFilterXmlPayload")).map(Boolean::valueOf).orElse(Boolean.FALSE);
        log.info("shouldFilterXmlPayload: {}", (Object)shouldFilterXmlPayload);
        SparkConf conf = new SparkConf();
        conf.registerKryoClasses(new Class[]{SerializableSolrInputDocument.class});
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            String isLookupUrl = parser.get("isLookupUrl");
            log.info("isLookupUrl: {}", (Object)isLookupUrl);
            ISLookupClient isLookup = new ISLookupClient(ISLookupClientFactory.getLookUpService((String)isLookupUrl));
            new XmlIndexingJob((SparkSession)spark, inputPath, shadowFormat, shadowCollection, batchSize, shouldFilterXmlPayload).run(isLookup);
        });
    }

    public XmlIndexingJob(SparkSession spark, String inputPath, String format, String shadowCollection, Integer batchSize, Boolean shouldFilterXmlPayload) {
        this.spark = spark;
        this.inputPath = inputPath;
        this.format = format;
        this.shadowCollection = shadowCollection;
        this.batchSize = batchSize;
        this.shouldFilterXmlPayload = shouldFilterXmlPayload;
    }

    public void run(ISLookupClient isLookup) throws ISLookUpException, TransformerException {
        String fields = isLookup.getLayoutSource(this.format);
        log.info("fields: {}", (Object)fields);
        String xslt = isLookup.getLayoutTransformer();
        String zkHost = isLookup.getZkHost();
        log.info("zkHost: {}", (Object)zkHost);
        String indexRecordXslt = XmlIndexingJob.getLayoutTransformer(this.format, fields, xslt);
        log.info("indexRecordTransformer {}", (Object)indexRecordXslt);
        Encoder encoder = Encoders.bean(TupleWrapper.class);
        boolean serializableShouldFilterXmlPayload = this.shouldFilterXmlPayload;
        JavaRDD docs = this.spark.read().schema(encoder.schema()).json(this.inputPath).as(encoder).map((MapFunction & Serializable)t -> new TupleWrapper(XmlIndexingJob.toIndexRecord(SaxonTransformerFactory.newInstance((String)indexRecordXslt), t.getXml()), t.getJson()), Encoders.bean(TupleWrapper.class)).javaRDD().map((Function & Serializable)t -> {
            SolrInputDocument doc = new StreamingInputDocumentFactory().parseDocument(t.getXml(), t.getJson());
            return XmlIndexingJob.filterXmlPayload(doc, serializableShouldFilterXmlPayload);
        });
        DHPSolrSupport.indexDocs(zkHost, this.shadowCollection, this.batchSize, (RDD<SolrInputDocument>)docs.rdd());
    }

    private static SolrInputDocument filterXmlPayload(SolrInputDocument doc, Boolean shouldFilterXmlPayload) {
        if (Boolean.TRUE.equals(shouldFilterXmlPayload)) {
            String json = (String)doc.get((Object)"__json").getFirstValue();
            try {
                SolrRecord sr = (SolrRecord)OBJECT_MAPPER.readValue(json, SolrRecord.class);
                boolean isProject = RecordType.project.equals((Object)sr.getHeader().getRecordType());
                boolean isRelatedToEcFunding = Optional.ofNullable(sr.getLinks()).map(links -> links.stream().anyMatch(rr -> {
                    boolean isRelatedProject = RecordType.project.equals((Object)rr.getHeader().getRelatedRecordType());
                    String funderShortName = Optional.ofNullable(rr.getFunding()).map(Funding::getFunder).map(Funder::getShortname).orElse("");
                    return isRelatedProject && "EC".equals(funderShortName);
                })).orElse(false);
                if (!isProject && !isRelatedToEcFunding) {
                    doc.remove((Object)"__result");
                }
            }
            catch (IOException e) {
                log.error("Error mapping json to SolrRecord", (Throwable)e);
                throw new IllegalStateException(e);
            }
        }
        return doc;
    }
}

