/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.provision;

import eu.dnetlib.dhp.oa.provision.SolrAdminApplication;
import eu.dnetlib.dhp.oa.provision.SolrTest;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.request.SolrPing;
import org.apache.solr.client.solrj.response.CollectionAdminResponse;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SolrAdminApplicationTest
extends SolrTest {
    SolrAdminApplicationTest() {
    }

    @Test
    void testPing() throws Exception {
        SolrPing ping = new SolrPing();
        ping.getParams().set("collection", new String[]{"shadow"});
        SolrPingResponse pingResponse = (SolrPingResponse)ping.process((SolrClient)miniCluster.getSolrClient());
        log.info("pingResponse: '{}'", (Object)pingResponse.getStatus());
        Assertions.assertEquals((int)0, (int)pingResponse.getStatus());
    }

    @Test
    void testAdminApplication_DELETE() throws Exception {
        SolrAdminApplication admin = new SolrAdminApplication(miniCluster.getSolrClient().getZkHost());
        UpdateResponse rsp = (UpdateResponse)admin.execute(SolrAdminApplication.Action.DELETE_BY_QUERY, "*:*", false, null, "c1-index-openaire");
        Assertions.assertEquals((int)0, (int)rsp.getStatus());
    }

    @Test
    void testAdminApplication_COMMIT() throws Exception {
        SolrAdminApplication admin = new SolrAdminApplication(miniCluster.getSolrClient().getZkHost());
        UpdateResponse rsp = (UpdateResponse)admin.commit("c1-index-openaire");
        Assertions.assertEquals((int)0, (int)rsp.getStatus());
    }

    @Test
    void testAdminApplication_CREATE_ALIAS() throws Exception {
        SolrAdminApplication admin = new SolrAdminApplication(miniCluster.getSolrClient().getZkHost());
        CollectionAdminResponse rsp = (CollectionAdminResponse)admin.createAlias("public", "c1-index-openaire");
        Assertions.assertEquals((int)0, (int)rsp.getStatus());
    }

    @Test
    void testAdminApplication_DELETE_ALIAS() throws Exception {
        SolrAdminApplication admin = new SolrAdminApplication(miniCluster.getSolrClient().getZkHost());
        CollectionAdminResponse rsp = (CollectionAdminResponse)admin.deleteAlias("public");
        Assertions.assertEquals((int)0, (int)rsp.getStatus());
    }
}

