/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.provision;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.oa.provision.XmlIndexingJob;
import eu.dnetlib.dhp.oa.provision.model.JoinedEntity;
import eu.dnetlib.dhp.oa.provision.utils.ContextMapper;
import eu.dnetlib.dhp.oa.provision.utils.StreamingInputDocumentFactory;
import eu.dnetlib.dhp.oa.provision.utils.XmlRecordFactory;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.utils.saxon.SaxonTransformerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.IOUtils;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrInputDocument;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class EOSCFuture_Test {
    public static ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    public static final String VERSION = "2021-04-15T10:05:53Z";
    public static final String DSID = "b9ee796a-c49f-4473-a708-e7d67b84c16d_SW5kZXhEU1Jlc291cmNlcy9JbmRleERTUmVzb3VyY2VUeXBl";
    private ContextMapper contextMapper;

    @BeforeEach
    public void setUp() {
        this.contextMapper = new ContextMapper();
    }

    @Test
    public void testEOSC_ROHub() throws IOException, DocumentException, TransformerException {
        ContextMapper contextMapper = new ContextMapper();
        XmlRecordFactory xmlRecordFactory = new XmlRecordFactory(contextMapper, false, "https://www.openaire.eu/schema/1.0/oaf-1.0.xsd");
        OtherResearchProduct p = (OtherResearchProduct)OBJECT_MAPPER.readValue(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("eosc-future/photic-zone.json")), OtherResearchProduct.class);
        String xml = xmlRecordFactory.build(new JoinedEntity((OafEntity)p));
        Assertions.assertNotNull((Object)xml);
        Document doc = new SAXReader().read((Reader)new StringReader(xml));
        Assertions.assertNotNull((Object)doc);
        System.out.println(doc.asXML());
        this.testRecordTransformation(xml);
    }

    private void testRecordTransformation(String record) throws IOException, TransformerException {
        String fields = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("fields.xml"));
        String xslt = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("layoutToRecordTransformer.xsl"));
        String transformer = XmlIndexingJob.getLayoutTransformer((String)"DMF", (String)fields, (String)xslt);
        Transformer tr = SaxonTransformerFactory.newInstance((String)transformer);
        String indexRecordXML = XmlIndexingJob.toIndexRecord((Transformer)tr, (String)record);
        SolrInputDocument solrDoc = new StreamingInputDocumentFactory().parseDocument(indexRecordXML);
        String xmlDoc = ClientUtils.toXML((SolrInputDocument)solrDoc);
        Assertions.assertNotNull((Object)xmlDoc);
        System.out.println(xmlDoc);
    }
}

