/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.raw;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.HdfsSupport;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.common.vocabulary.VocabularyGroup;
import eu.dnetlib.dhp.oa.graph.raw.OafToOafMapper;
import eu.dnetlib.dhp.oa.graph.raw.OdfToOafMapper;
import eu.dnetlib.dhp.oa.graph.raw.common.AbstractMigrationApplication;
import eu.dnetlib.dhp.schema.common.ModelSupport;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.Datasource;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.Organization;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Project;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Software;
import eu.dnetlib.dhp.schema.oaf.utils.MergeUtils;
import eu.dnetlib.dhp.utils.ISLookupClientFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.api.java.function.MapGroupsFunction;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class GenerateEntitiesApplication
extends AbstractMigrationApplication {
    private static final Logger log = LoggerFactory.getLogger(GenerateEntitiesApplication.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)GenerateEntitiesApplication.class.getResourceAsStream("/eu/dnetlib/dhp/oa/graph/generate_entities_parameters.json")));
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String sourcePaths = parser.get("sourcePaths");
        log.info("sourcePaths: {}", (Object)sourcePaths);
        String targetPath = parser.get("targetPath");
        log.info("targetPath: {}", (Object)targetPath);
        String isLookupUrl = parser.get("isLookupUrl");
        log.info("isLookupUrl: {}", (Object)isLookupUrl);
        boolean shouldHashId = Optional.ofNullable(parser.get("shouldHashId")).map(Boolean::valueOf).orElse(true);
        log.info("shouldHashId: {}", (Object)shouldHashId);
        Mode mode = Optional.ofNullable(parser.get("mode")).map(Mode::valueOf).orElse(Mode.graph);
        log.info("mode: {}", (Object)mode);
        ISLookUpService isLookupService = ISLookupClientFactory.getLookUpService((String)isLookupUrl);
        VocabularyGroup vocs = VocabularyGroup.loadVocsFromIS((ISLookUpService)isLookupService);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            HdfsSupport.remove((String)targetPath, (Configuration)spark.sparkContext().hadoopConfiguration());
            GenerateEntitiesApplication.generateEntities(spark, vocs, sourcePaths, targetPath, shouldHashId, mode);
        });
    }

    private static void generateEntities(SparkSession spark, VocabularyGroup vocs, String sourcePaths, String targetPath, boolean shouldHashId, Mode mode) {
        List<String> existingSourcePaths = GenerateEntitiesApplication.listEntityPaths(spark, sourcePaths);
        log.info("Generate entities from files:");
        existingSourcePaths.forEach(arg_0 -> ((Logger)log).info(arg_0));
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        org.apache.spark.sql.Dataset entities = existingSourcePaths.stream().map(sp2 -> spark.createDataset(sc.sequenceFile(sp2, Text.class, Text.class).map((Function & Serializable)k -> new Tuple2((Object)((Text)k._1()).toString(), (Object)((Text)k._2()).toString())).rdd(), Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.STRING()))).reduce(org.apache.spark.sql.Dataset::union).orElse(spark.emptyDataset(Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.STRING()))).flatMap((FlatMapFunction & Serializable)k -> GenerateEntitiesApplication.convertToListOaf((String)k._1(), (String)k._2(), shouldHashId, vocs), Encoders.kryo(Oaf.class)).filter(Objects::nonNull);
        switch (mode) {
            case claim: {
                entities = entities.groupByKey((MapFunction & Serializable)oaf -> (String)ModelSupport.idFn().apply(oaf), Encoders.STRING()).mapGroups((MapGroupsFunction & Serializable)(k, t) -> MergeUtils.mergeGroup((Iterator)t), Encoders.kryo(Oaf.class));
                break;
            }
        }
        entities.map((MapFunction & Serializable)oaf -> {
            try {
                return oaf.getClass().getSimpleName().toLowerCase() + "|" + OBJECT_MAPPER.writeValueAsString(oaf);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }, Encoders.STRING()).write().mode(SaveMode.Overwrite).option("compression", "gzip").text(targetPath);
    }

    public static Iterator<Oaf> convertToListOaf(String id, String s, boolean shouldHashId, VocabularyGroup vocs) {
        String type = StringUtils.substringAfter((String)id, (String)":");
        switch (type.toLowerCase()) {
            case "oaf-store-cleaned": {
                return new OafToOafMapper(vocs, false, shouldHashId).processMdRecord(s).iterator();
            }
            case "oaf-store-claim": {
                return new OafToOafMapper(vocs, false, shouldHashId, true).processMdRecord(s).iterator();
            }
            case "odf-store-cleaned": {
                return new OdfToOafMapper(vocs, false, shouldHashId).processMdRecord(s).iterator();
            }
            case "odf-store-claim": {
                return new OdfToOafMapper(vocs, false, shouldHashId, true).processMdRecord(s).iterator();
            }
            case "oaf-store-intersection": {
                return new OafToOafMapper(vocs, true, shouldHashId).processMdRecord(s).iterator();
            }
            case "odf-store-intersection": {
                return new OdfToOafMapper(vocs, true, shouldHashId).processMdRecord(s).iterator();
            }
            case "datasource": {
                return Collections.singletonList(GenerateEntitiesApplication.convertFromJson(s, Datasource.class)).iterator();
            }
            case "organization": {
                return Collections.singletonList(GenerateEntitiesApplication.convertFromJson(s, Organization.class)).iterator();
            }
            case "project": {
                return Collections.singletonList(GenerateEntitiesApplication.convertFromJson(s, Project.class)).iterator();
            }
            case "relation": {
                return Collections.singletonList(GenerateEntitiesApplication.convertFromJson(s, Relation.class)).iterator();
            }
            case "publication": {
                return Collections.singletonList(GenerateEntitiesApplication.convertFromJson(s, Publication.class)).iterator();
            }
            case "dataset": {
                return Collections.singletonList(GenerateEntitiesApplication.convertFromJson(s, Dataset.class)).iterator();
            }
            case "software": {
                return Collections.singletonList(GenerateEntitiesApplication.convertFromJson(s, Software.class)).iterator();
            }
            case "otherresearchproduct": {
                return Collections.singletonList(GenerateEntitiesApplication.convertFromJson(s, OtherResearchProduct.class)).iterator();
            }
        }
        throw new IllegalArgumentException("type not managed: " + type.toLowerCase());
    }

    private static Oaf convertFromJson(String s, Class<? extends Oaf> clazz) {
        try {
            return (Oaf)OBJECT_MAPPER.readValue(s, clazz);
        }
        catch (Exception e) {
            log.error("Error parsing object of class: {}:\n{}", clazz, (Object)s);
            throw new IllegalArgumentException(e);
        }
    }

    static enum Mode {
        claim,
        graph;

    }
}

