/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.sx.graph.bio.pubmed;

import eu.dnetlib.dhp.common.vocabulary.VocabularyGroup;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.mockito.Mock;
import org.mockito.Mockito;

public abstract class AbstractVocabularyTest {
    @Mock
    protected ISLookUpService isLookUpService;
    protected VocabularyGroup vocabularies;

    public void setUpVocabulary() throws ISLookUpException, IOException {
        Mockito.lenient().when((Object)this.isLookUpService.quickSearchProfile("for $x in collection('/db/DRIVER/VocabularyDSResources/VocabularyDSResourceType') \nlet $vocid := $x//VOCABULARY_NAME/@code\nlet $vocname := $x//VOCABULARY_NAME/text()\nfor $term in ($x//TERM)\nreturn concat($vocid,' @=@ ',$vocname,' @=@ ',$term/@code,' @=@ ',$term/@english_name)")).thenReturn(AbstractVocabularyTest.vocs());
        Mockito.lenient().when((Object)this.isLookUpService.quickSearchProfile("for $x in collection('/db/DRIVER/VocabularyDSResources/VocabularyDSResourceType')\nlet $vocid := $x//VOCABULARY_NAME/@code\nlet $vocname := $x//VOCABULARY_NAME/text()\nfor $term in ($x//TERM)\nfor $syn in ($term//SYNONYM/@term)\nreturn concat($vocid,' @=@ ',$term/@code,' @=@ ', $syn)\n")).thenReturn(AbstractVocabularyTest.synonyms());
        this.vocabularies = VocabularyGroup.loadVocsFromIS((ISLookUpService)this.isLookUpService);
    }

    private static List<String> vocs() throws IOException {
        return IOUtils.readLines((InputStream)Objects.requireNonNull(AbstractVocabularyTest.class.getResourceAsStream("/eu/dnetlib/dhp/transform/terms.txt")));
    }

    private static List<String> synonyms() throws IOException {
        return IOUtils.readLines((InputStream)Objects.requireNonNull(AbstractVocabularyTest.class.getResourceAsStream("/eu/dnetlib/dhp/transform/synonyms.txt")));
    }
}

