/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.raw.common;

import com.google.common.base.Splitter;
import eu.dnetlib.dhp.schema.oaf.Datasource;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.Relation;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class VerifyNsPrefixPredicate
implements Predicate<Oaf> {
    final Set<String> invalids = new HashSet<String>();

    public VerifyNsPrefixPredicate(String blacklist) {
        if (StringUtils.isNotBlank((CharSequence)blacklist)) {
            Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)blacklist).forEach(this.invalids::add);
        }
    }

    @Override
    public boolean test(Oaf oaf) {
        if (oaf instanceof Datasource) {
            return this.testValue((String)((Datasource)oaf).getNamespaceprefix().getValue());
        }
        if (oaf instanceof OafEntity) {
            return this.testValue(((OafEntity)oaf).getId());
        }
        if (oaf instanceof Relation) {
            return this.testValue(((Relation)oaf).getSource()) && this.testValue(((Relation)oaf).getTarget());
        }
        return true;
    }

    protected boolean testValue(String s) {
        if (StringUtils.isNotBlank((CharSequence)s)) {
            for (String invalid : this.invalids) {
                if (!Pattern.matches("^(\\d\\d\\|)?" + invalid + ".*$", s)) continue;
                return false;
            }
        }
        return true;
    }
}

