/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.raw;

import com.google.common.collect.Lists;
import eu.dnetlib.dhp.common.PacePerson;
import eu.dnetlib.dhp.common.vocabulary.VocabularyGroup;
import eu.dnetlib.dhp.oa.graph.raw.AbstractMdRecordToOafMapper;
import eu.dnetlib.dhp.schema.common.ModelConstants;
import eu.dnetlib.dhp.schema.common.ModelSupport;
import eu.dnetlib.dhp.schema.common.RelationInverse;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.GeoLocation;
import eu.dnetlib.dhp.schema.oaf.HashableStructuredProperty;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.oaf.Subject;
import eu.dnetlib.dhp.schema.oaf.utils.CleaningFunctions;
import eu.dnetlib.dhp.schema.oaf.utils.IdentifierFactory;
import eu.dnetlib.dhp.schema.oaf.utils.OafMapperUtils;
import eu.dnetlib.dhp.schema.oaf.utils.PidCleaner;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class OdfToOafMapper
extends AbstractMdRecordToOafMapper {
    public static final String HTTP_DOI_PREIFX = "https://doi.org/";
    public static final String HTTP_HANDLE_PREIFX = "https://hdl.handle.net/";

    public OdfToOafMapper(VocabularyGroup vocs, boolean invisible, boolean shouldHashId, boolean forceOrginalId) {
        super(vocs, invisible, shouldHashId, forceOrginalId);
    }

    public OdfToOafMapper(VocabularyGroup vocs, boolean invisible, boolean shouldHashId) {
        super(vocs, invisible, shouldHashId);
    }

    @Override
    protected List<StructuredProperty> prepareTitles(Document doc, DataInfo info) {
        ArrayList title = Lists.newArrayList();
        String xpath = "//*[local-name()='titles']/*[local-name()='title']|//*[local-name()='resource']/*[local-name()='title']";
        for (Object o : doc.selectNodes("//*[local-name()='titles']/*[local-name()='title']|//*[local-name()='resource']/*[local-name()='title']")) {
            Element e = (Element)o;
            String titleValue = e.getTextTrim();
            String titleType = e.attributeValue("titleType");
            if (StringUtils.isNotBlank((CharSequence)titleType)) {
                title.add(OafMapperUtils.structuredProperty((String)titleValue, (String)titleType, (String)titleType, (String)"dnet:dataCite_title", (String)"dnet:dataCite_title", (DataInfo)info));
                continue;
            }
            title.add(OafMapperUtils.structuredProperty((String)titleValue, (Qualifier)ModelConstants.MAIN_TITLE_QUALIFIER, (DataInfo)info));
        }
        return title;
    }

    @Override
    protected List<Author> prepareAuthors(Document doc, DataInfo info) {
        ArrayList<Author> res = new ArrayList<Author>();
        int pos = 1;
        for (Object o : doc.selectNodes("//*[local-name()='creator']")) {
            Node n = (Node)o;
            Author author = new Author();
            String fullname = n.valueOf("./*[local-name()='creatorName']");
            String name = n.valueOf("./*[local-name()='givenName']");
            String surname = n.valueOf("./*[local-name()='familyName']");
            if (!StringUtils.isNotBlank((CharSequence)fullname) && !StringUtils.isNotBlank((CharSequence)name) && !StringUtils.isNotBlank((CharSequence)surname)) continue;
            author.setFullname(fullname);
            PacePerson pp = new PacePerson(fullname, false);
            if (StringUtils.isBlank((CharSequence)name) & pp.isAccurate()) {
                author.setName(pp.getNormalisedFirstName());
            } else {
                author.setName(name);
            }
            if (StringUtils.isBlank((CharSequence)surname) & pp.isAccurate()) {
                author.setSurname(pp.getNormalisedSurname());
            } else {
                author.setSurname(surname);
            }
            if (StringUtils.isBlank((CharSequence)author.getFullname())) {
                author.setFullname(String.format("%s, %s", author.getSurname(), author.getName()));
            }
            author.setRawAffiliationString(this.prepareListString(n, "./*[local-name()='affiliation']"));
            author.setPid(this.preparePids(n, info));
            author.setRank(Integer.valueOf(pos++));
            res.add(author);
        }
        return res;
    }

    private List<StructuredProperty> preparePids(Node n, DataInfo info) {
        ArrayList<StructuredProperty> res = new ArrayList<StructuredProperty>();
        for (Object o : n.selectNodes("./*[local-name()='nameIdentifier']")) {
            String id = ((Node)o).getText();
            String type = ((Node)o).valueOf("./@nameIdentifierScheme").trim().toUpperCase().replace(" ", "").replace("_", "");
            if (type.toLowerCase().startsWith("orcid")) {
                String cleanedId = id.replace("http://orcid.org/", "").replace("https://orcid.org/", "");
                res.add(OafMapperUtils.structuredProperty((String)cleanedId, (Qualifier)ORCID_PID_TYPE, (DataInfo)info));
                continue;
            }
            if (!type.startsWith("MAGID")) continue;
            res.add(OafMapperUtils.structuredProperty((String)id, (Qualifier)MAG_PID_TYPE, (DataInfo)info));
        }
        return res;
    }

    @Override
    protected Instance prepareInstances(Document doc, DataInfo info, KeyValue collectedfrom, KeyValue hostedby) {
        Instance instance = new Instance();
        instance.setInstancetype(this.prepareQualifier((Node)doc, "//dr:CobjCategory", "dnet:publication_resource"));
        instance.setCollectedfrom(collectedfrom);
        instance.setHostedby(hostedby);
        List<StructuredProperty> alternateIdentifier = this.prepareResultPids(doc, info);
        List pid = IdentifierFactory.getPids(alternateIdentifier, (KeyValue)collectedfrom);
        instance.setInstanceTypeMapping(this.prepareInstanceTypeMapping(doc));
        HashSet pids = new HashSet(pid);
        instance.setAlternateIdentifier(alternateIdentifier.stream().filter(i -> !pids.contains(i)).collect(Collectors.toList()));
        instance.setPid(pid);
        instance.setDateofacceptance(OafMapperUtils.field((Object)doc.valueOf("//oaf:dateAccepted"), (DataInfo)info));
        String distributionlocation = doc.valueOf("//oaf:distributionlocation");
        instance.setDistributionlocation(StringUtils.isNotBlank((CharSequence)distributionlocation) ? distributionlocation : null);
        instance.setAccessright(this.prepareAccessRight((Node)doc, "//oaf:accessrights", "dnet:access_modes"));
        instance.setLicense(OafMapperUtils.field((Object)doc.valueOf("//oaf:license"), (DataInfo)info));
        instance.setRefereed(this.prepareQualifier((Node)doc, "//oaf:refereed", "dnet:review_levels"));
        instance.setProcessingchargeamount(OafMapperUtils.field((Object)doc.valueOf("//oaf:processingchargeamount"), (DataInfo)info));
        instance.setProcessingchargecurrency(OafMapperUtils.field((Object)doc.valueOf("//oaf:processingchargeamount/@currency"), (DataInfo)info));
        this.prepareListURL((Node)doc, "//oaf:fulltext", info).stream().findFirst().map(Field::getValue).ifPresent(arg_0 -> ((Instance)instance).setFulltext(arg_0));
        HashSet<String> url = new HashSet<String>();
        for (Object o : doc.selectNodes("//*[local-name()='alternateIdentifier' and ./@alternateIdentifierType='URL']")) {
            url.add(this.trimAndDecodeUrl(((Node)o).getText().trim()));
        }
        for (Object o : doc.selectNodes("//*[local-name()='alternateIdentifier' and ./@alternateIdentifierType='landingPage']")) {
            url.add(this.trimAndDecodeUrl(((Node)o).getText().trim()));
        }
        for (Object o : doc.selectNodes("//*[local-name()='identifier' and ./@identifierType='URL']")) {
            url.add(this.trimAndDecodeUrl(((Node)o).getText().trim()));
        }
        for (Object o : doc.selectNodes("//*[local-name()='identifier' and ./@identifierType='landingPage']")) {
            url.add(this.trimAndDecodeUrl(((Node)o).getText().trim()));
        }
        for (Object o : doc.selectNodes("//*[local-name()='identifier' and ./@identifierType='w3id']")) {
            url.add(this.trimAndDecodeUrl(((Node)o).getText().trim()));
        }
        Set<String> validUrl = this.validateUrl(url);
        if (validUrl.stream().noneMatch(s -> s.contains("doi.org"))) {
            for (Object o : doc.selectNodes("//*[local-name()='alternateIdentifier' and ./@alternateIdentifierType='DOI']")) {
                validUrl.add(HTTP_DOI_PREIFX + ((Node)o).getText().trim());
            }
            for (Object o : doc.selectNodes("//*[local-name()='identifier' and ./@identifierType='DOI']")) {
                validUrl.add(HTTP_DOI_PREIFX + ((Node)o).getText().trim());
            }
        }
        if (validUrl.stream().noneMatch(s -> s.contains("hdl.handle.net"))) {
            for (Object o : doc.selectNodes("//*[local-name()='alternateIdentifier' and ./@alternateIdentifierType='Handle']")) {
                validUrl.add(HTTP_HANDLE_PREIFX + ((Node)o).getText().trim());
            }
            for (Object o : doc.selectNodes("//*[local-name()='identifier' and ./@identifierType='Handle']")) {
                validUrl.add(HTTP_HANDLE_PREIFX + ((Node)o).getText().trim());
            }
        }
        if (!validUrl.isEmpty()) {
            instance.setUrl(new ArrayList());
            instance.getUrl().addAll(validUrl);
        }
        return instance;
    }

    protected String trimAndDecodeUrl(String url) {
        try {
            return URLDecoder.decode(url.trim(), "UTF-8");
        }
        catch (Throwable t) {
            return url;
        }
    }

    @Override
    protected String findOriginalType(Document doc) {
        return Optional.ofNullable((Element)doc.selectSingleNode("//*[local-name()='metadata']/*[local-name() = 'resource']/*[local-name() = 'resourceType']")).map(e -> {
            String resourceTypeURI = Optional.ofNullable(e.attributeValue("uri")).filter(StringUtils::isNotBlank).orElse(null);
            String resourceTypeAnyURI = Optional.ofNullable(e.attributeValue("anyURI")).filter(StringUtils::isNotBlank).orElse(null);
            String resourceTypeTxt = Optional.ofNullable(e.getText()).filter(StringUtils::isNotBlank).orElse(null);
            String resourceTypeGeneral = Optional.ofNullable(e.attributeValue("resourceTypeGeneral")).filter(StringUtils::isNotBlank).orElse(null);
            return (String)ObjectUtils.firstNonNull((Object[])new String[]{resourceTypeURI, resourceTypeAnyURI, resourceTypeTxt, resourceTypeGeneral});
        }).orElse(null);
    }

    @Override
    protected List<Field<String>> prepareSources(Document doc, DataInfo info) {
        return new ArrayList<Field<String>>();
    }

    @Override
    protected List<StructuredProperty> prepareRelevantDates(Document doc, DataInfo info) {
        ArrayList<StructuredProperty> res = new ArrayList<StructuredProperty>();
        for (Object o : doc.selectNodes("//*[local-name()='date']")) {
            String dateType = ((Node)o).valueOf("@dateType");
            if (StringUtils.isBlank((CharSequence)dateType) || !dateType.equalsIgnoreCase("Accepted") && !dateType.equalsIgnoreCase("Issued") && !dateType.equalsIgnoreCase("Updated") && !dateType.equalsIgnoreCase("Available")) {
                res.add(OafMapperUtils.structuredProperty((String)((Node)o).getText(), (String)"UNKNOWN", (String)"UNKNOWN", (String)"dnet:dataCite_date", (String)"dnet:dataCite_date", (DataInfo)info));
                continue;
            }
            res.add(OafMapperUtils.structuredProperty((String)((Node)o).getText(), (String)dateType, (String)dateType, (String)"dnet:dataCite_date", (String)"dnet:dataCite_date", (DataInfo)info));
        }
        return res;
    }

    @Override
    protected List<Field<String>> prepareCoverages(Document doc, DataInfo info) {
        return new ArrayList<Field<String>>();
    }

    @Override
    protected List<Field<String>> prepareContributors(Document doc, DataInfo info) {
        return this.prepareListFields((Node)doc, "//*[local-name()='contributorName']", info);
    }

    @Override
    protected List<Field<String>> prepareFormats(Document doc, DataInfo info) {
        return this.prepareListFields((Node)doc, "//*[local-name()='format']", info);
    }

    @Override
    protected Field<String> preparePublisher(Document doc, DataInfo info) {
        return this.prepareField((Node)doc, "//*[local-name()='publisher']", info);
    }

    @Override
    protected List<Field<String>> prepareDescriptions(Document doc, DataInfo info) {
        return this.prepareListFields((Node)doc, "//datacite:description[./@descriptionType='Abstract'] | //dc:description", info);
    }

    @Override
    protected List<Subject> prepareSubjects(Document doc, DataInfo info) {
        return this.prepareSubjectList((Node)doc, "//*[local-name()='subject']", info);
    }

    @Override
    protected Qualifier prepareLanguages(Document doc) {
        return this.prepareQualifier((Node)doc, "//*[local-name()='language']", "dnet:languages");
    }

    @Override
    protected List<Field<String>> prepareOtherResearchProductTools(Document doc, DataInfo info) {
        return new ArrayList<Field<String>>();
    }

    @Override
    protected List<Field<String>> prepareOtherResearchProductContactGroups(Document doc, DataInfo info) {
        return this.prepareListFields((Node)doc, "//*[local-name()='contributor' and ./@contributorType='ContactGroup']/*[local-name()='contributorName']", info);
    }

    @Override
    protected List<Field<String>> prepareOtherResearchProductContactPersons(Document doc, DataInfo info) {
        return this.prepareListFields((Node)doc, "//*[local-name()='contributor' and ./@contributorType='ContactPerson']/*[local-name()='contributorName']", info);
    }

    @Override
    protected Qualifier prepareSoftwareProgrammingLanguage(Document doc, DataInfo info) {
        return this.prepareQualifier((Node)doc, "//*[local-name()='format']", "dnet:programming_languages");
    }

    @Override
    protected Field<String> prepareSoftwareCodeRepositoryUrl(Document doc, DataInfo info) {
        return null;
    }

    @Override
    protected List<StructuredProperty> prepareSoftwareLicenses(Document doc, DataInfo info) {
        return new ArrayList<StructuredProperty>();
    }

    @Override
    protected List<Field<String>> prepareSoftwareDocumentationUrls(Document doc, DataInfo info) {
        return this.prepareListFields((Node)doc, "//*[local-name()='relatedIdentifier' and ./@relatedIdentifierType='URL' and @relationType='IsDocumentedBy']", info);
    }

    @Override
    protected List<GeoLocation> prepareDatasetGeoLocations(Document doc, DataInfo info) {
        ArrayList<GeoLocation> res = new ArrayList<GeoLocation>();
        for (Object o : doc.selectNodes("//*[local-name()='geoLocation']")) {
            GeoLocation loc = new GeoLocation();
            loc.setBox(((Node)o).valueOf("./*[local-name()='geoLocationBox']"));
            loc.setPlace(((Node)o).valueOf("./*[local-name()='geoLocationPlace']"));
            loc.setPoint(((Node)o).valueOf("./*[local-name()='geoLocationPoint']"));
            res.add(loc);
        }
        return res;
    }

    @Override
    protected Field<String> prepareDatasetMetadataVersionNumber(Document doc, DataInfo info) {
        return null;
    }

    @Override
    protected Field<String> prepareDatasetLastMetadataUpdate(Document doc, DataInfo info) {
        return this.prepareField((Node)doc, "//*[local-name()='date' and ./@dateType='Updated']", info);
    }

    @Override
    protected Field<String> prepareDatasetVersion(Document doc, DataInfo info) {
        return this.prepareField((Node)doc, "//*[local-name()='version']", info);
    }

    @Override
    protected Field<String> prepareDatasetSize(Document doc, DataInfo info) {
        return this.prepareField((Node)doc, "//*[local-name()='size']", info);
    }

    @Override
    protected Field<String> prepareDatasetDevice(Document doc, DataInfo info) {
        return null;
    }

    @Override
    protected Field<String> prepareDatasetStorageDate(Document doc, DataInfo info) {
        return this.prepareField((Node)doc, "//*[local-name()='date' and ./@dateType='Issued']", info);
    }

    @Override
    protected List<Oaf> addOtherResultRels(Document doc, OafEntity entity, DataInfo info) {
        String docId = entity.getId();
        ArrayList<Oaf> res = new ArrayList<Oaf>();
        for (Object o : doc.selectNodes("//*[local-name()='relatedIdentifier']")) {
            String originalId = ((Node)o).getText().trim();
            if (!StringUtils.isNotBlank((CharSequence)originalId)) continue;
            String idType = ((Node)o).valueOf("@relatedIdentifierType");
            String relType = ((Node)o).valueOf("@relationType");
            String otherId = this.guessRelatedIdentifier(idType, originalId);
            if (!StringUtils.isNotBlank((CharSequence)otherId)) continue;
            res.addAll(this.getRelations(relType, docId, otherId, entity, info));
        }
        return res;
    }

    protected String guessRelatedIdentifier(String idType, String value) {
        if (StringUtils.isBlank((CharSequence)idType) || StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        if (idType.equalsIgnoreCase("OPENAIRE")) {
            return OafMapperUtils.createOpenaireId((int)50, (String)value, (boolean)false);
        }
        if (pidTypeWithAuthority.containsKey(idType.toLowerCase())) {
            return IdentifierFactory.idFromPid((String)"50", (String)((String)pidTypeWithAuthority.get(idType.toLowerCase())), (String)value, (boolean)true);
        }
        return null;
    }

    protected List<Oaf> getRelations(String reltype, String entityId, String otherId, OafEntity entity, DataInfo info) {
        ArrayList<Oaf> res = new ArrayList<Oaf>();
        RelationInverse rel = ModelSupport.findRelation((String)reltype);
        if (rel != null) {
            res.add((Oaf)OafMapperUtils.getRelation((String)entityId, (String)otherId, (String)rel.getRelType(), (String)rel.getSubReltype(), (String)rel.getRelClass(), (List)entity.getCollectedfrom(), (DataInfo)info, (Long)entity.getLastupdatetimestamp(), null, null));
            res.add((Oaf)OafMapperUtils.getRelation((String)otherId, (String)entityId, (String)rel.getRelType(), (String)rel.getSubReltype(), (String)rel.getInverseRelClass(), (List)entity.getCollectedfrom(), (DataInfo)info, (Long)entity.getLastupdatetimestamp(), null, null));
        }
        return res;
    }

    @Override
    protected Qualifier prepareResourceType(Document doc, DataInfo info) {
        return this.prepareQualifier((Node)doc, "//*[local-name() = 'resource']//*[local-name() = 'resourceType']", "dnet:dataCite_resource");
    }

    @Override
    protected List<StructuredProperty> prepareResultPids(Document doc, DataInfo info) {
        HashSet<HashableStructuredProperty> res = new HashSet<HashableStructuredProperty>();
        res.addAll(this.prepareListStructPropsWithValidQualifier((Node)doc, "//oaf:identifier", "@identifierType", "dnet:pid_types", info));
        res.addAll(this.prepareListStructPropsWithValidQualifier((Node)doc, "//*[local-name()='identifier' and ./@identifierType != 'URL' and ./@identifierType != 'landingPage']", "@identifierType", "dnet:pid_types", info));
        res.addAll(this.prepareListStructPropsWithValidQualifier((Node)doc, "//*[local-name()='alternateIdentifier' and ./@alternateIdentifierType != 'URL' and ./@alternateIdentifierType != 'landingPage']", "@alternateIdentifierType", "dnet:pid_types", info));
        return res.stream().map(PidCleaner::normalizePidValue).filter(CleaningFunctions::pidFilter).collect(Collectors.toList());
    }
}

