/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.hostedbymap;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.oa.graph.hostedbymap.model.EntityInfo;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.OpenAccessRoute;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.utils.OafMapperUtils;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.json4s.DefaultFormats$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxedUnit;

public final class SparkApplyHostedByMapToResult$ {
    public static SparkApplyHostedByMapToResult$ MODULE$;

    static {
        new SparkApplyHostedByMapToResult$();
    }

    public Dataset<Publication> applyHBtoPubs(Dataset<EntityInfo> join, Dataset<Publication> pubs) {
        return pubs.joinWith(join, pubs.col("id").equalTo((Object)join.col("id")), "left").map((Function1 & Serializable & scala.Serializable)t2 -> {
            Publication p;
            block0: {
                Buffer i;
                EntityInfo ei;
                block1: {
                    p = (Publication)t2._1();
                    if (t2._2() == null) break block0;
                    ei = (EntityInfo)t2._2();
                    i = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(p.getInstance()).asScala();
                    if (i.size() != 1) break block1;
                    Instance inst = (Instance)i.head();
                    MODULE$.patchInstance(p, ei, inst);
                    break block0;
                }
                Buffer cf = (Buffer)i.map((Function1 & Serializable & scala.Serializable)ii -> ii.getCollectedfrom().getValue(), Buffer$.MODULE$.canBuildFrom());
                if (!cf.contains((Object)"Crossref")) break block0;
                i.foreach((Function1 & Serializable & scala.Serializable)ii -> {
                    SparkApplyHostedByMapToResult$.MODULE$.patchInstance(p, ei, ii);
                    return BoxedUnit.UNIT;
                });
            }
            return p;
        }, Encoders$.MODULE$.bean(Publication.class));
    }

    private void patchInstance(Publication p, EntityInfo ei, Instance inst) {
        inst.getHostedby().setKey(ei.getHostedById());
        inst.getHostedby().setValue(ei.getName());
        if (Predef$.MODULE$.Boolean2boolean(ei.getOpenAccess())) {
            inst.setAccessright(OafMapperUtils.accessRight((String)"OPEN", (String)"Open Access", (String)"dnet:access_modes", (String)"dnet:access_modes"));
            inst.getAccessright().setOpenAccessRoute(OpenAccessRoute.gold);
            p.setBestaccessright(OafMapperUtils.createBestAccessRights((List)p.getInstance()));
            return;
        }
    }

    public void main(String[] args) {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        SparkConf conf = new SparkConf();
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/oa/graph/hostedbymap/hostedby_apply_params.json")));
        parser.parseArgument(args);
        SparkSession spark = SparkSession$.MODULE$.builder().config(conf).appName(this.getClass().getSimpleName()).master(parser.get("master")).getOrCreate();
        String graphPath = parser.get("graphPath");
        String outputPath = parser.get("outputPath");
        String preparedInfoPath = parser.get("preparedInfoPath");
        DefaultFormats$ formats = DefaultFormats$.MODULE$;
        Encoder mapEncoderPubs = Encoders$.MODULE$.bean(Publication.class);
        Encoder mapEncoderEinfo = Encoders$.MODULE$.bean(EntityInfo.class);
        ObjectMapper mapper = new ObjectMapper();
        Dataset pubs = spark.read().textFile(new StringBuilder(12).append(graphPath).append("/publication").toString()).map((Function1 & Serializable & scala.Serializable)r -> (Publication)mapper.readValue(r, Publication.class), mapEncoderPubs);
        Dataset pinfo = spark.read().textFile(preparedInfoPath).map((Function1 & Serializable & scala.Serializable)ei -> (EntityInfo)mapper.readValue(ei, EntityInfo.class), mapEncoderEinfo);
        this.applyHBtoPubs((Dataset<EntityInfo>)pinfo, (Dataset<Publication>)pubs).write().mode(SaveMode.Overwrite).option("compression", "gzip").json(outputPath);
        spark.read().textFile(outputPath).write().mode(SaveMode.Overwrite).option("compression", "gzip").text(new StringBuilder(12).append(graphPath).append("/publication").toString());
    }

    private SparkApplyHostedByMapToResult$() {
        MODULE$ = this;
    }
}

