/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.sx.graph.scholix;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.sx.scholix.Scholix;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixIdentifier;
import eu.dnetlib.dhp.schema.sx.summary.ScholixSummary;
import eu.dnetlib.dhp.sx.graph.bio.pubmed.AbstractVocabularyTest;
import eu.dnetlib.dhp.sx.graph.scholix.ScholixUtils$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

@ExtendWith(value={MockitoExtension.class})
@ScalaSignature(bytes="\u0006\u0001\t4A!\u0001\u0002\u0001\u001f\t\u00012k\u00195pY&DxI]1qQR+7\u000f\u001e\u0006\u0003\u0007\u0011\tqa]2i_2L\u0007P\u0003\u0002\u0006\r\u0005)qM]1qQ*\u0011q\u0001C\u0001\u0003gbT!!\u0003\u0006\u0002\u0007\u0011D\u0007O\u0003\u0002\f\u0019\u00059AM\\3uY&\u0014'\"A\u0007\u0002\u0005\u0015,8\u0001A\n\u0003\u0001A\u0001\"!\u0005\f\u000e\u0003IQ!a\u0005\u000b\u0002\rA,(-\\3e\u0015\t)B!A\u0002cS>L!a\u0006\n\u0003-\u0005\u00137\u000f\u001e:bGR4vnY1ck2\f'/\u001f+fgRDQ!\u0007\u0001\u0005\u0002i\ta\u0001P5oSRtD#A\u000e\u0011\u0005q\u0001Q\"\u0001\u0002\t\u000fy\u0001!\u0019!C\u0001?\u00051Q.\u00199qKJ,\u0012\u0001\t\t\u0003C)j\u0011A\t\u0006\u0003G\u0011\n\u0001\u0002Z1uC\nLg\u000e\u001a\u0006\u0003K\u0019\nqA[1dWN|gN\u0003\u0002(Q\u0005Ia-Y:uKJDX\u000e\u001c\u0006\u0002S\u0005\u00191m\\7\n\u0005-\u0012#\u0001D(cU\u0016\u001cG/T1qa\u0016\u0014\bBB\u0017\u0001A\u0003%\u0001%A\u0004nCB\u0004XM\u001d\u0011\t\u000b=\u0002A\u0011\u0001\u0019\u0002\u000bM,G/\u00169\u0015\u0003E\u0002\"AM\u001b\u000e\u0003MR\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mM\u0012A!\u00168ji\"\u0012a\u0006\u000f\t\u0003s\tk\u0011A\u000f\u0006\u0003wq\n1!\u00199j\u0015\tid(A\u0004kkBLG/\u001a:\u000b\u0005}\u0002\u0015!\u00026v]&$(\"A!\u0002\u0007=\u0014x-\u0003\u0002Du\tQ!)\u001a4pe\u0016,\u0015m\u00195\t\u000b\u0015\u0003A\u0011\u0001\u0019\u0002!Q,7\u000f^(B\rR{7+^7nCJL\bF\u0001#H!\tI\u0004*\u0003\u0002Ju\t!A+Z:u\u0011\u0015Y\u0005\u0001\"\u00011\u0003a!Xm\u001d;TG\"|G.\u001b=NKJ<Wm\u00148T_V\u00148-\u001a\u0015\u0003\u0015\u001eCQA\u0014\u0001\u0005\u0002A\nQ\u0004^3tiN\u001b\u0007n\u001c7jqJ+G.\u0019;j_:\u001c\b.\u001b9t\u00072,\u0017M\u001c\u0015\u0003\u001b\u001eCC\u0001A)X1B\u0011!+V\u0007\u0002'*\u0011AKO\u0001\nKb$XM\\:j_:L!AV*\u0003\u0015\u0015CH/\u001a8e/&$\b.A\u0003wC2,X\rL\u0001ZG\u0005Q\u0006CA.a\u001b\u0005a&BA\u001f^\u0015\tydL\u0003\u0002`\u0001\u00069Qn\\2lSR|\u0017BA1]\u0005AiunY6ji>,\u0005\u0010^3og&|g\u000e")
public class ScholixGraphTest
extends AbstractVocabularyTest {
    private final ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);

    public ObjectMapper mapper() {
        return this.mapper;
    }

    @BeforeEach
    public void setUp() {
        super.setUpVocabulary();
    }

    @Test
    public void testOAFToSummary() {
        String inputRelations = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/oaf_to_summary"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        List items = new StringOps(Predef$.MODULE$.augmentString(inputRelations)).linesWithSeparators().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String l) {
                return new StringOps(Predef$.MODULE$.augmentString(l)).stripLineEnd();
            }
        }).toList();
        Assertions.assertNotNull((Object)items);
        items.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String i) {
                Assertions.assertTrue((boolean)new StringOps(Predef$.MODULE$.augmentString(i)).nonEmpty());
            }
        });
        List result = (List)((List)items.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ScholixGraphTest $outer;

            public final Result apply(String r) {
                return (Result)this.$outer.mapper().readValue(r, Result.class);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ScholixSummary apply(Result i) {
                return ScholixUtils$.MODULE$.resultToSummary(i);
            }
        }, List$.MODULE$.canBuildFrom());
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((int)result.size(), (int)items.size());
        Option d = result.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ScholixSummary s) {
                return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(s.getLocalIdentifier()).asScala()).exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ScholixIdentifier i) {
                        return i.getUrl() == null || i.getUrl().isEmpty();
                    }
                });
            }
        });
        Assertions.assertFalse((boolean)d.isDefined());
        Predef$.MODULE$.println((Object)this.mapper().writeValueAsString(result.head()));
    }

    @Test
    public void testScholixMergeOnSource() {
        String inputRelations = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/merge_result_scholix"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        Iterator qual$1 = new StringOps(Predef$.MODULE$.augmentString(inputRelations)).linesWithSeparators().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String l) {
                return new StringOps(Predef$.MODULE$.augmentString(l)).stripLineEnd();
            }
        });
        int x$1 = 2;
        int x$2 = qual$1.sliding$default$2();
        List result = qual$1.sliding(x$1, x$2).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(Seq<String> s) {
                return new Tuple2(s.head(), s.apply(1));
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ScholixGraphTest $outer;

            public final Tuple2<Relation, ScholixSummary> apply(Tuple2<String, String> p) {
                return new Tuple2(this.$outer.mapper().readValue((String)p._1(), Relation.class), this.$outer.mapper().readValue((String)p._2(), ScholixSummary.class));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).toList();
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.nonEmpty());
        result.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<Relation, ScholixSummary> r) {
                Assertions.assertEquals((Object)((Relation)r._1()).getSource(), (Object)((ScholixSummary)r._2()).getId());
            }
        });
        List scholix = (List)result.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Scholix apply(Tuple2<Relation, ScholixSummary> r) {
                return ScholixUtils$.MODULE$.scholixFromSource((Relation)r._1(), (ScholixSummary)r._2());
            }
        }, List$.MODULE$.canBuildFrom());
        Predef$.MODULE$.println((Object)this.mapper().writeValueAsString(scholix.head()));
    }

    @Test
    public void testScholixRelationshipsClean() {
        ObjectRef formats$lzy = ObjectRef.zero();
        ObjectRef json$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        String inputRelations = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/relation_transform.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        List l = (List)package$.MODULE$.jvalue2extractable(this.json$1(inputRelations, json$lzy, bitmap$0)).extract((Formats)this.formats$1(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
        Assertions.assertNotNull((Object)l);
        Assertions.assertTrue((boolean)l.nonEmpty());
        Map relVocbaulary = ScholixUtils$.MODULE$.relations();
        l.foreach((Function1)new Serializable(this, relVocbaulary){
            public static final long serialVersionUID = 0L;
            private final Map relVocbaulary$1;

            public final void apply(String r) {
                Assertions.assertTrue((boolean)this.relVocbaulary$1.contains((Object)r.toLowerCase()));
            }
            {
                this.relVocbaulary$1 = relVocbaulary$1;
            }
        });
    }

    private final DefaultFormats$ formats$lzycompute$1(ObjectRef formats$lzy$1, VolatileByteRef bitmap$0$1) {
        ScholixGraphTest scholixGraphTest = this;
        synchronized (scholixGraphTest) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                formats$lzy$1.elem = DefaultFormats$.MODULE$;
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (DefaultFormats$)formats$lzy$1.elem;
        }
    }

    private final DefaultFormats$ formats$1(ObjectRef formats$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.formats$lzycompute$1(formats$lzy$1, bitmap$0$1) : (DefaultFormats$)formats$lzy$1.elem;
    }

    private final JsonAST.JValue json$lzycompute$1(String inputRelations$1, ObjectRef json$lzy$1, VolatileByteRef bitmap$0$1) {
        ScholixGraphTest scholixGraphTest = this;
        synchronized (scholixGraphTest) {
            if ((byte)(bitmap$0$1.elem & 2) == 0) {
                json$lzy$1.elem = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(inputRelations$1), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 2);
            }
            return (JsonAST.JValue)json$lzy$1.elem;
        }
    }

    private final JsonAST.JValue json$1(String inputRelations$1, ObjectRef json$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 2) == 0 ? this.json$lzycompute$1(inputRelations$1, json$lzy$1, bitmap$0$1) : (JsonAST.JValue)json$lzy$1.elem;
    }

    public ScholixGraphTest() {
        this.mapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

