/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.orcid;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.schema.oaf.Author;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.junit.jupiter.api.Test;
import org.junit.platform.commons.util.StringUtils;

public class ORCIDAuthorEnricherTest {
    @Test
    public void testEnrcichAuthor() throws Exception {
        String pubLine;
        ObjectMapper mapper = new ObjectMapper();
        BufferedReader pr = new BufferedReader(new InputStreamReader(Objects.requireNonNull(ORCIDAuthorEnricherTest.class.getResourceAsStream("/eu/dnetlib/dhp/enrich/orcid/authors_publication_sample.json"))));
        BufferedReader or = new BufferedReader(new InputStreamReader(Objects.requireNonNull(ORCIDAuthorEnricherTest.class.getResourceAsStream("/eu/dnetlib/dhp/enrich/orcid/authors_orcid_sample.json"))));
        TypeReference<List<Author>> aclass = new TypeReference<List<Author>>(){};
        boolean i = false;
        while ((pubLine = pr.readLine()) != null) {
            String pubId = pubLine;
            String MatchPidOrcid = or.readLine();
            String pubOrcid = or.readLine();
            String data = pr.readLine();
            if (!StringUtils.isNotBlank((String)data)) continue;
            List publicationAuthors = (List)mapper.readValue(data, (TypeReference)aclass);
            List orcidAuthors = (List)mapper.readValue(or.readLine(), (TypeReference)aclass);
            System.out.printf("OAF ID = %s \n", pubId);
            System.out.printf("ORCID Intersected ID = %s \n", pubOrcid);
            System.out.printf("OAF Author Size = %d \n", publicationAuthors.size());
            System.out.printf("Oricd Author Size = %d \n", orcidAuthors.size());
            System.out.printf("Oricd Matched PID = %s \n", MatchPidOrcid);
            long originalAuthorWithPiD = publicationAuthors.stream().filter(a -> a.getPid() != null && a.getPid().stream().anyMatch(p -> p.getQualifier() != null && p.getQualifier().getClassid().toLowerCase().contains("orcid"))).count();
            long start = System.currentTimeMillis();
            List enrichedList = Collections.emptyList();
            long enrichedAuthorWithPid = enrichedList.stream().filter(a -> a.getPid() != null && a.getPid().stream().anyMatch(p -> p.getQualifier() != null && p.getQualifier().getClassid().toLowerCase().contains("orcid"))).count();
            long totalTime = (System.currentTimeMillis() - start) / 1000L;
            System.out.printf("Enriched authors in %d seconds from %d pid to %d pid \n", totalTime, originalAuthorWithPiD, enrichedAuthorWithPid);
            System.out.println("=================");
        }
    }
}

