/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.person;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.enrich.relsfrompublisherenricheddata.EnrichExternalDataWithGraphORCID;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.api.java.function.ForeachFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnrichPublisherAndCreatePersonRelationsTest {
    private static final Logger log = LoggerFactory.getLogger(EnrichPublisherAndCreatePersonRelationsTest.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static SparkSession spark;
    private static Path workingDir;

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(EnrichPublisherAndCreatePersonRelationsTest.class.getSimpleName(), new FileAttribute[0]);
        log.info("using work dir {}", (Object)workingDir);
        SparkConf conf = new SparkConf();
        conf.setAppName(EnrichPublisherAndCreatePersonRelationsTest.class.getSimpleName());
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.toString());
        conf.set("hive.metastore.warehouse.dir", workingDir.resolve("warehouse").toString());
        spark = SparkSession.builder().appName(EnrichPublisherAndCreatePersonRelationsTest.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterAll
    public static void afterAll() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
        spark.stop();
    }

    @Test
    void testNewRelationNoMergeNoDedup() throws Exception {
        String sourcePathPubs = this.getClass().getResource("/eu/dnetlib/dhp/person/testNewRelationNoMergeNoDedup/graph/publication").getPath();
        String sourcePathRels = this.getClass().getResource("/eu/dnetlib/dhp/person/testNewRelationNoMergeNoDedup/graph/relation").getPath();
        String publisherPath = this.getClass().getResource("/eu/dnetlib/dhp/person/testNewRelationNoMergeNoDedup/publisher/").getPath();
        spark.read().json(sourcePathPubs).write().json(workingDir.toString() + "/graph/publication");
        spark.read().json(sourcePathRels).write().json(workingDir.toString() + "/graph/relation");
        spark.read().json(publisherPath).write().json(workingDir.toString() + "/publisher");
        EnrichExternalDataWithGraphORCID.main((String[])new String[]{"--orcidPath", workingDir.toString() + "/graph", "--targetPath", workingDir.toString() + "/graph", "--graphPath", workingDir.toString() + "/publisher", "--workingDir", workingDir.toString() + "/working", "--master", "yarn", "--matchingSource", "graph"});
        Dataset relations = spark.read().schema(Encoders.bean(Relation.class).schema()).json(workingDir.toString() + "/graph/relation").as(Encoders.bean(Relation.class));
        relations.show(false);
        Assertions.assertEquals((long)19L, (long)relations.count());
        Assertions.assertEquals((long)1L, (long)relations.filter((FilterFunction & Serializable)r -> r.getSubRelType().equalsIgnoreCase("authorship")).count());
        Relation relation = (Relation)relations.filter((FilterFunction & Serializable)r -> r.getSubRelType().equalsIgnoreCase("authorship")).first();
        Assertions.assertEquals((Object)("30|orcid_______::" + DHPUtils.md5((String)"0000-0001-8255-3618")), (Object)relation.getSource());
        Assertions.assertEquals((Object)("50|doi_________::" + DHPUtils.md5((String)"10.11646/phytotaxa.379.3.5")), (Object)relation.getTarget());
        Assertions.assertEquals((int)2, (int)relation.getProperties().size());
        relation.getProperties().forEach(r -> Assertions.assertEquals((Object)"declared_affiliation", (Object)r.getKey()));
        Assertions.assertTrue((boolean)relation.getProperties().stream().anyMatch(r -> r.getValue().equalsIgnoreCase("https://ror.org/029m7xn54")));
        Assertions.assertTrue((boolean)relation.getProperties().stream().anyMatch(r -> r.getValue().equalsIgnoreCase("OpenOrgs: 0000002097")));
        Assertions.assertEquals((double)1.0, (double)Double.parseDouble(((KeyValue)relation.getProperties().get(0)).getDataInfo().getTrust()));
        Assertions.assertEquals((long)0L, (long)relations.filter((FilterFunction & Serializable)r -> r.getRelClass().equalsIgnoreCase("hasCoAuthor")).count());
    }

    @Test
    void testNewRelationMergeNoDedup() throws Exception {
        String sourcePathPubs = this.getClass().getResource("/eu/dnetlib/dhp/person/testNewRelationMergeNoDedup/graph/publication").getPath();
        String sourcePathRels = this.getClass().getResource("/eu/dnetlib/dhp/person/testNewRelationMergeNoDedup/graph/relation").getPath();
        String publisherPath = this.getClass().getResource("/eu/dnetlib/dhp/person/testNewRelationMergeNoDedup/publisher/").getPath();
        spark.read().json(sourcePathPubs).write().json(workingDir.toString() + "/graph/publication");
        spark.read().json(sourcePathRels).write().json(workingDir.toString() + "/graph/relation");
        spark.read().json(publisherPath).write().json(workingDir.toString() + "/publisher");
        EnrichExternalDataWithGraphORCID.main((String[])new String[]{"--orcidPath", workingDir.toString() + "/graph", "--targetPath", workingDir.toString() + "/graph", "--graphPath", workingDir.toString() + "/publisher", "--workingDir", workingDir.toString() + "/working", "--master", "yarn", "--matchingSource", "graph"});
        Dataset relations = spark.read().schema(Encoders.bean(Relation.class).schema()).json(workingDir.toString() + "/graph/relation").as(Encoders.bean(Relation.class));
        Assertions.assertEquals((long)18L, (long)relations.count());
        Assertions.assertEquals((long)1L, (long)relations.filter((FilterFunction & Serializable)r -> r.getSubRelType().equalsIgnoreCase("authorship")).count());
        Relation relation = (Relation)relations.filter((FilterFunction & Serializable)r -> r.getSubRelType().equalsIgnoreCase("authorship")).first();
        Assertions.assertEquals((Object)("30|orcid_______::" + DHPUtils.md5((String)"0000-0001-8255-3618")), (Object)relation.getSource());
        Assertions.assertEquals((Object)("50|doi_________::" + DHPUtils.md5((String)"10.11646/phytotaxa.379.3.5")), (Object)relation.getTarget());
        Assertions.assertEquals((int)3, (int)relation.getProperties().size());
        relation.getProperties().forEach(p -> Assertions.assertEquals((Object)"declared_affiliation", (Object)p.getKey()));
        Assertions.assertTrue((boolean)relation.getProperties().stream().anyMatch(p -> p.getValue().equals("https://ror.org/029m7xn54")));
        Assertions.assertTrue((boolean)relation.getProperties().stream().anyMatch(p -> p.getValue().equals("https://ror.org/029m7fake")));
        Assertions.assertTrue((boolean)relation.getProperties().stream().anyMatch(r -> r.getValue().equalsIgnoreCase("OpenOrgs: 0000002097")));
        Assertions.assertEquals((double)1.0, (double)Double.parseDouble(relation.getProperties().stream().filter(p -> p.getDataInfo() != null).findFirst().get().getDataInfo().getTrust()));
        Assertions.assertEquals((long)0L, (long)relations.filter((FilterFunction & Serializable)r -> r.getRelClass().equalsIgnoreCase("hasCoAuthor")).count());
    }

    @Test
    void testNewRelationNoMergeDedup() throws Exception {
        String sourcePathPubs = this.getClass().getResource("/eu/dnetlib/dhp/person/testNewRelationNoMergeDedup/graph/publication").getPath();
        String sourcePathRels = this.getClass().getResource("/eu/dnetlib/dhp/person/testNewRelationNoMergeDedup/graph/relation").getPath();
        String publisherPath = this.getClass().getResource("/eu/dnetlib/dhp/person/testNewRelationNoMergeDedup/publisher/").getPath();
        spark.read().json(sourcePathPubs).write().json(workingDir.toString() + "/graph/publication");
        spark.read().json(sourcePathRels).write().json(workingDir.toString() + "/graph/relation");
        spark.read().json(publisherPath).write().json(workingDir.toString() + "/publisher");
        EnrichExternalDataWithGraphORCID.main((String[])new String[]{"--orcidPath", workingDir.toString() + "/graph", "--targetPath", workingDir.toString() + "/graph", "--graphPath", workingDir.toString() + "/publisher", "--workingDir", workingDir.toString() + "/working", "--master", "yarn", "--matchingSource", "graph"});
        Dataset relations = spark.read().schema(Encoders.bean(Relation.class).schema()).json(workingDir.toString() + "/graph/relation").as(Encoders.bean(Relation.class));
        Assertions.assertEquals((long)19L, (long)relations.count());
        Assertions.assertEquals((long)1L, (long)relations.filter((FilterFunction & Serializable)r -> r.getSubRelType().equalsIgnoreCase("authorship")).count());
        Relation relation = (Relation)relations.filter((FilterFunction & Serializable)r -> r.getSubRelType().equalsIgnoreCase("authorship")).first();
        Assertions.assertEquals((Object)("30|orcid_______::" + DHPUtils.md5((String)"0000-0001-8255-3618")), (Object)relation.getSource());
        Assertions.assertEquals((Object)("50|doi_________::" + DHPUtils.md5((String)"10.11646/phytotaxa.379.3.5")), (Object)relation.getTarget());
        Assertions.assertEquals((int)2, (int)relation.getProperties().size());
        relation.getProperties().forEach(r -> Assertions.assertEquals((Object)"declared_affiliation", (Object)r.getKey()));
        Assertions.assertTrue((boolean)relation.getProperties().stream().anyMatch(r -> r.getValue().equalsIgnoreCase("https://ror.org/029m7xn54")));
        Assertions.assertTrue((boolean)relation.getProperties().stream().anyMatch(r -> r.getValue().equalsIgnoreCase("OpenOrgs: 0000002097")));
        Assertions.assertEquals((double)1.0, (double)Double.parseDouble(((KeyValue)relation.getProperties().get(0)).getDataInfo().getTrust()));
        Assertions.assertEquals((long)0L, (long)relations.filter((FilterFunction & Serializable)r -> r.getRelClass().equalsIgnoreCase("hasCoAuthor")).count());
    }

    @Test
    void testNewRelationMergeDedup() throws Exception {
        String sourcePathPubs = this.getClass().getResource("/eu/dnetlib/dhp/person/testNewRelationMergeDedup/graph/publication").getPath();
        String sourcePathRels = this.getClass().getResource("/eu/dnetlib/dhp/person/testNewRelationMergeDedup/graph/relation").getPath();
        String publisherPath = this.getClass().getResource("/eu/dnetlib/dhp/person/testNewRelationMergeDedup/publisher/").getPath();
        spark.read().json(sourcePathPubs).write().json(workingDir.toString() + "/graph/publication");
        spark.read().json(sourcePathRels).write().json(workingDir.toString() + "/graph/relation");
        spark.read().json(publisherPath).write().json(workingDir.toString() + "/publisher");
        EnrichExternalDataWithGraphORCID.main((String[])new String[]{"--orcidPath", workingDir.toString() + "/graph", "--targetPath", workingDir.toString() + "/graph", "--graphPath", workingDir.toString() + "/publisher", "--workingDir", workingDir.toString() + "/working", "--master", "yarn", "--matchingSource", "graph"});
        Dataset relations = spark.read().schema(Encoders.bean(Relation.class).schema()).json(workingDir.toString() + "/graph/relation").as(Encoders.bean(Relation.class));
        Assertions.assertEquals((long)18L, (long)relations.count());
        Assertions.assertEquals((long)1L, (long)relations.filter((FilterFunction & Serializable)r -> r.getSubRelType().equalsIgnoreCase("authorship")).count());
        Relation relation = (Relation)relations.filter((FilterFunction & Serializable)r -> r.getSubRelType().equalsIgnoreCase("authorship")).first();
        Assertions.assertEquals((Object)("30|orcid_______::" + DHPUtils.md5((String)"0000-0001-8255-3618")), (Object)relation.getSource());
        Assertions.assertEquals((Object)("50|doi_________::" + DHPUtils.md5((String)"10.11646/phytotaxa.379.3.5")), (Object)relation.getTarget());
        Assertions.assertEquals((int)3, (int)relation.getProperties().size());
        relation.getProperties().forEach(p -> Assertions.assertEquals((Object)"declared_affiliation", (Object)p.getKey()));
        Assertions.assertTrue((boolean)relation.getProperties().stream().anyMatch(p -> p.getValue().equals("https://ror.org/029m7xn54")));
        Assertions.assertTrue((boolean)relation.getProperties().stream().anyMatch(p -> p.getValue().equals("https://ror.org/029m7fake")));
        Assertions.assertTrue((boolean)relation.getProperties().stream().anyMatch(r -> r.getValue().equalsIgnoreCase("OpenOrgs: 0000002097")));
        Assertions.assertEquals((double)1.0, (double)Double.parseDouble(relation.getProperties().stream().filter(p -> p.getDataInfo() != null).findFirst().get().getDataInfo().getTrust()));
        Assertions.assertEquals((long)0L, (long)relations.filter((FilterFunction & Serializable)r -> r.getRelClass().equalsIgnoreCase("hasCoAuthor")).count());
    }

    @Test
    void testNewRelationCoAuthorship() throws Exception {
        String sourcePathPubs = this.getClass().getResource("/eu/dnetlib/dhp/person/testNewAuthorshiRelations/graph/publication").getPath();
        String sourcePathRels = this.getClass().getResource("/eu/dnetlib/dhp/person/testNewAuthorshiRelations/graph/relation").getPath();
        String publisherPath = this.getClass().getResource("/eu/dnetlib/dhp/person/testNewAuthorshiRelations/publisher/").getPath();
        spark.read().json(sourcePathPubs).write().json(workingDir.toString() + "/graph/publication");
        spark.read().json(sourcePathRels).write().json(workingDir.toString() + "/graph/relation");
        spark.read().json(publisherPath).write().json(workingDir.toString() + "/publisher");
        EnrichExternalDataWithGraphORCID.main((String[])new String[]{"--orcidPath", workingDir.toString() + "/graph", "--targetPath", workingDir.toString() + "/graph", "--graphPath", workingDir.toString() + "/publisher", "--workingDir", workingDir.toString() + "/working", "--master", "yarn", "--matchingSource", "graph"});
        Dataset relations = spark.read().schema(Encoders.bean(Relation.class).schema()).json(workingDir.toString() + "/graph/relation").as(Encoders.bean(Relation.class));
        Assertions.assertEquals((long)20L, (long)relations.count());
        Assertions.assertEquals((long)1L, (long)relations.filter((FilterFunction & Serializable)r -> r.getSubRelType().equalsIgnoreCase("authorship")).count());
        Relation relation = (Relation)relations.filter((FilterFunction & Serializable)r -> r.getSubRelType().equalsIgnoreCase("authorship")).first();
        Assertions.assertEquals((Object)("30|orcid_______::" + DHPUtils.md5((String)"0000-0001-8255-3618")), (Object)relation.getSource());
        Assertions.assertEquals((Object)("50|doi_________::" + DHPUtils.md5((String)"10.11646/phytotaxa.379.3.5")), (Object)relation.getTarget());
        Assertions.assertEquals((int)3, (int)relation.getProperties().size());
        relation.getProperties().forEach(p -> Assertions.assertEquals((Object)"declared_affiliation", (Object)p.getKey()));
        Assertions.assertTrue((boolean)relation.getProperties().stream().anyMatch(p -> p.getValue().equals("https://ror.org/029m7xn54")));
        Assertions.assertTrue((boolean)relation.getProperties().stream().anyMatch(p -> p.getValue().equals("https://ror.org/029m7fake")));
        Assertions.assertTrue((boolean)relation.getProperties().stream().anyMatch(p -> p.getValue().equals("OpenOrgs: 0000002097")));
        Assertions.assertEquals((double)1.0, (double)Double.parseDouble(relation.getProperties().stream().filter(p -> p.getDataInfo() != null).findFirst().get().getDataInfo().getTrust()));
        Assertions.assertEquals((long)2L, (long)relations.filter((FilterFunction & Serializable)r -> r.getRelClass().equalsIgnoreCase("hasCoAuthor")).count());
    }

    @Test
    void testNewRelationWithRoles() throws Exception {
        String sourcePathPubs = this.getClass().getResource("/eu/dnetlib/dhp/person/testNewRelationsWithRoles/graph/publication").getPath();
        String sourcePathRels = this.getClass().getResource("/eu/dnetlib/dhp/person/testNewRelationsWithRoles/graph/relation").getPath();
        String publisherPath = this.getClass().getResource("/eu/dnetlib/dhp/person/testNewRelationsWithRoles/publisher/").getPath();
        spark.read().json(sourcePathPubs).write().json(workingDir.toString() + "/graph/publication");
        spark.read().json(sourcePathRels).write().json(workingDir.toString() + "/graph/relation");
        spark.read().json(publisherPath).write().json(workingDir.toString() + "/publisher");
        EnrichExternalDataWithGraphORCID.main((String[])new String[]{"--orcidPath", workingDir.toString() + "/graph", "--targetPath", workingDir.toString() + "/graph", "--graphPath", workingDir.toString() + "/publisher", "--workingDir", workingDir.toString() + "/working", "--master", "yarn", "--matchingSource", "graph"});
        Dataset relations = spark.read().schema(Encoders.bean(Relation.class).schema()).json(workingDir.toString() + "/graph/relation").as(Encoders.bean(Relation.class));
        relations.foreach((ForeachFunction & Serializable)r -> System.out.println(new ObjectMapper().writeValueAsString(r)));
        Assertions.assertEquals((long)1L, (long)relations.filter((FilterFunction & Serializable)r -> r.getSubRelType().equalsIgnoreCase("authorship")).count());
        Relation relation = (Relation)relations.filter((FilterFunction & Serializable)r -> r.getSubRelType().equalsIgnoreCase("authorship")).first();
        Assertions.assertEquals((int)7, (int)relation.getProperties().size());
        Assertions.assertEquals((long)3L, (long)relation.getProperties().stream().filter(p -> p.getKey().equalsIgnoreCase("declared_affiliation")).count());
        Assertions.assertEquals((long)3L, (long)relation.getProperties().stream().filter(p -> p.getKey().equalsIgnoreCase("role")).count());
        Assertions.assertEquals((long)1L, (long)relation.getProperties().stream().filter(p -> p.getKey().equalsIgnoreCase("corresponding")).count());
        Assertions.assertTrue((boolean)relation.getProperties().stream().filter(p -> p.getKey().equalsIgnoreCase("role")).anyMatch(p -> p.getValue().equalsIgnoreCase("CReDIT http://credit.niso.org/contributor-roles/investigation")));
        Assertions.assertTrue((boolean)relation.getProperties().stream().filter(p -> p.getKey().equalsIgnoreCase("role")).anyMatch(p -> p.getValue().equalsIgnoreCase("CReDit http://credit.niso.org/contributor-roles/methodology")));
        Assertions.assertTrue((boolean)relation.getProperties().stream().filter(p -> p.getKey().equalsIgnoreCase("role")).anyMatch(p -> p.getValue().equalsIgnoreCase("CReDIT http://credit.niso.org/contributor-roles/writing-original-draft")));
        Assertions.assertFalse((boolean)Boolean.parseBoolean(relation.getProperties().stream().filter(p -> p.getKey().equalsIgnoreCase("corresponding")).findFirst().get().getValue()));
    }
}

