/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dedup;

import eu.dnetlib.dedup.DedupRecordFactory;
import eu.dnetlib.dedup.DedupUtility;
import eu.dnetlib.dedup.OafEntityType;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.pace.config.DedupConfig;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;

public class SparkCreateDedupRecord {
    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)SparkCreateDedupRecord.class.getResourceAsStream("/eu/dnetlib/dhp/sx/dedup/dedupRecord_parameters.json")));
        parser.parseArgument(args);
        SparkSession spark = SparkSession.builder().appName(SparkCreateDedupRecord.class.getSimpleName()).master(parser.get("master")).getOrCreate();
        JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
        String sourcePath = parser.get("sourcePath");
        String entity = parser.get("entity");
        String dedupPath = parser.get("dedupPath");
        DedupConfig dedupConf = DedupConfig.load((String)parser.get("dedupConf"));
        JavaRDD<OafEntity> dedupRecord = DedupRecordFactory.createDedupRecord(sc, spark, DedupUtility.createMergeRelPath(dedupPath, entity), DedupUtility.createEntityPath(sourcePath, entity), OafEntityType.valueOf(entity), dedupConf);
        spark.createDataset(dedupRecord.rdd(), Encoders.kryo(OafEntity.class)).write().mode(SaveMode.Overwrite).save(dedupPath + "/" + entity + "/dedup_records");
    }
}

