/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.oa.dedup.DedupRecordFactory;
import eu.dnetlib.dhp.oa.dedup.SparkDedupTest;
import eu.dnetlib.dhp.oa.merge.AuthorMerger;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Software;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.pace.util.MapDocumentUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Tuple2;

class EntityMergerTest
implements Serializable {
    private List<Tuple2<String, Publication>> publications;
    private List<Tuple2<String, Publication>> publications2;
    private List<Tuple2<String, Publication>> publications3;
    private List<Tuple2<String, Publication>> publications4;
    private List<Tuple2<String, Publication>> publications5;
    private String testEntityBasePath;
    private DataInfo dataInfo;
    private final String dedupId = "00|dedup_id::1";
    private Publication pub_top;

    EntityMergerTest() {
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.testEntityBasePath = Paths.get(SparkDedupTest.class.getResource("/eu/dnetlib/dhp/dedup/json").toURI()).toFile().getAbsolutePath();
        this.publications = this.readSample(this.testEntityBasePath + "/publication_merge.json", Publication.class);
        this.publications2 = this.readSample(this.testEntityBasePath + "/publication_merge2.json", Publication.class);
        this.publications3 = this.readSample(this.testEntityBasePath + "/publication_merge3.json", Publication.class);
        this.publications4 = this.readSample(this.testEntityBasePath + "/publication_merge4.json", Publication.class);
        this.publications5 = this.readSample(this.testEntityBasePath + "/publication_merge5.json", Publication.class);
        this.pub_top = this.getTopPub(this.publications);
        this.dataInfo = this.setDI();
    }

    @Test
    void softwareMergerTest() throws InstantiationException, IllegalAccessException, InvocationTargetException {
        List<Tuple2<String, Software>> softwares = this.readSample(this.testEntityBasePath + "/software_merge.json", Software.class);
        Software merged = (Software)DedupRecordFactory.entityMerger((String)"00|dedup_id::1", softwares.iterator(), (long)0L, (DataInfo)this.dataInfo, Software.class);
        Assertions.assertEquals((Object)"OPEN SOURCE", (Object)merged.getBestaccessright().getClassid());
        Assertions.assertEquals((Object)"00|dedup_id::1", (Object)merged.getId());
    }

    @Test
    void publicationMergerTest() throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Publication pub_merged = (Publication)DedupRecordFactory.entityMerger((String)"00|dedup_id::1", this.publications.iterator(), (long)0L, (DataInfo)this.dataInfo, Publication.class);
        Assertions.assertEquals((Object)"00|dedup_id::1", (Object)pub_merged.getId());
        Assertions.assertEquals((Object)this.pub_top.getJournal().getName(), (Object)pub_merged.getJournal().getName());
        Assertions.assertEquals((Object)this.pub_top.getJournal().getIssnOnline(), (Object)pub_merged.getJournal().getIssnOnline());
        Assertions.assertEquals((Object)this.pub_top.getJournal().getIssnLinking(), (Object)pub_merged.getJournal().getIssnLinking());
        Assertions.assertEquals((Object)this.pub_top.getJournal().getIssnPrinted(), (Object)pub_merged.getJournal().getIssnPrinted());
        Assertions.assertEquals((Object)this.pub_top.getJournal().getIss(), (Object)pub_merged.getJournal().getIss());
        Assertions.assertEquals((Object)this.pub_top.getJournal().getEp(), (Object)pub_merged.getJournal().getEp());
        Assertions.assertEquals((Object)this.pub_top.getJournal().getSp(), (Object)pub_merged.getJournal().getSp());
        Assertions.assertEquals((Object)this.pub_top.getJournal().getVol(), (Object)pub_merged.getJournal().getVol());
        Assertions.assertEquals((Object)this.pub_top.getJournal().getConferencedate(), (Object)pub_merged.getJournal().getConferencedate());
        Assertions.assertEquals((Object)this.pub_top.getJournal().getConferenceplace(), (Object)pub_merged.getJournal().getConferenceplace());
        Assertions.assertEquals((Object)"OPEN", (Object)pub_merged.getBestaccessright().getClassid());
        Assertions.assertEquals((Object)this.pub_top.getResulttype().getClassid(), (Object)pub_merged.getResulttype().getClassid());
        Assertions.assertEquals((Object)this.pub_top.getLanguage().getClassid(), (Object)pub_merged.getLanguage().getClassid());
        Assertions.assertEquals((Object)"Elsevier BV", (Object)pub_merged.getPublisher().getValue());
        Assertions.assertEquals((Object)this.pub_top.getEmbargoenddate().getValue(), (Object)pub_merged.getEmbargoenddate().getValue());
        Assertions.assertEquals((Object)this.pub_top.getResourcetype().getClassid(), (Object)"");
        Assertions.assertEquals((Object)this.pub_top.getDateoftransformation(), (Object)pub_merged.getDateoftransformation());
        Assertions.assertEquals((Object)this.pub_top.getOaiprovenance(), (Object)pub_merged.getOaiprovenance());
        Assertions.assertEquals((int)3, (int)pub_merged.getInstance().size());
        Assertions.assertEquals((int)2, (int)pub_merged.getCountry().size());
        Assertions.assertEquals((int)0, (int)pub_merged.getSubject().size());
        Assertions.assertEquals((int)2, (int)pub_merged.getTitle().size());
        Assertions.assertEquals((int)0, (int)pub_merged.getRelevantdate().size());
        Assertions.assertEquals((int)0, (int)pub_merged.getDescription().size());
        Assertions.assertEquals((int)0, (int)pub_merged.getSource().size());
        Assertions.assertEquals((int)0, (int)pub_merged.getFulltext().size());
        Assertions.assertEquals((int)0, (int)pub_merged.getFormat().size());
        Assertions.assertEquals((int)0, (int)pub_merged.getContributor().size());
        Assertions.assertEquals((int)0, (int)pub_merged.getCoverage().size());
        Assertions.assertEquals((int)0, (int)pub_merged.getContext().size());
        Assertions.assertEquals((int)0, (int)pub_merged.getExternalReference().size());
        Assertions.assertEquals((int)3, (int)pub_merged.getOriginalId().size());
        Assertions.assertEquals((int)3, (int)pub_merged.getCollectedfrom().size());
        Assertions.assertEquals((int)1, (int)pub_merged.getPid().size());
        Assertions.assertEquals((int)0, (int)pub_merged.getExtraInfo().size());
        Assertions.assertEquals((Object)this.dataInfo, (Object)pub_merged.getDataInfo());
        Assertions.assertEquals((Object)"2016-01-01", (Object)pub_merged.getDateofacceptance().getValue());
        Assertions.assertEquals((int)13, (int)pub_merged.getAuthor().size());
        Assertions.assertEquals((int)4, (int)AuthorMerger.countAuthorsPids((List)pub_merged.getAuthor()));
        int count = 0;
        for (StructuredProperty title : pub_merged.getTitle()) {
            if (!title.getQualifier().getClassid().equals("main title")) continue;
            ++count;
        }
        Assertions.assertEquals((int)1, (int)count);
    }

    @Test
    void publicationMergerTest2() throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Publication pub_merged = (Publication)DedupRecordFactory.entityMerger((String)"00|dedup_id::1", this.publications2.iterator(), (long)0L, (DataInfo)this.dataInfo, Publication.class);
        Assertions.assertEquals((Object)"00|dedup_id::1", (Object)pub_merged.getId());
        Assertions.assertEquals((int)27, (int)pub_merged.getAuthor().size());
    }

    @Test
    void publicationMergerTest3() throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Publication pub_merged = (Publication)DedupRecordFactory.entityMerger((String)"00|dedup_id::1", this.publications3.iterator(), (long)0L, (DataInfo)this.dataInfo, Publication.class);
        Assertions.assertEquals((Object)"00|dedup_id::1", (Object)pub_merged.getId());
    }

    @Test
    void publicationMergerTest4() throws InstantiationException, IllegalStateException, IllegalAccessException, InvocationTargetException {
        Publication pub_merged = (Publication)DedupRecordFactory.entityMerger((String)"00|dedup_id::1", this.publications4.iterator(), (long)0L, (DataInfo)this.dataInfo, Publication.class);
        Assertions.assertEquals((Object)"00|dedup_id::1", (Object)pub_merged.getId());
    }

    @Test
    void publicationMergerTest5() throws InstantiationException, IllegalStateException, IllegalAccessException, InvocationTargetException {
        System.out.println(this.publications5.stream().map(p -> ((Publication)p._2()).getId()).collect(Collectors.toList()));
        Publication pub_merged = (Publication)DedupRecordFactory.entityMerger((String)"00|dedup_id::1", this.publications5.iterator(), (long)0L, (DataInfo)this.dataInfo, Publication.class);
        Assertions.assertEquals((Object)"00|dedup_id::1", (Object)pub_merged.getId());
    }

    public DataInfo setDI() {
        DataInfo dataInfo = new DataInfo();
        dataInfo.setTrust("0.9");
        dataInfo.setDeletedbyinference(Boolean.valueOf(false));
        dataInfo.setInferenceprovenance("testing");
        dataInfo.setInferred(Boolean.valueOf(true));
        return dataInfo;
    }

    public Publication getTopPub(List<Tuple2<String, Publication>> publications) {
        Double maxTrust = 0.0;
        Publication maxPub = new Publication();
        for (Tuple2<String, Publication> publication : publications) {
            Double pubTrust = Double.parseDouble(((Publication)publication._2()).getDataInfo().getTrust());
            if (!(pubTrust > maxTrust)) continue;
            maxTrust = pubTrust;
            maxPub = (Publication)publication._2();
        }
        return maxPub;
    }

    public <T> List<Tuple2<String, T>> readSample(String path, Class<T> clazz) {
        ArrayList<Tuple2<String, T>> res = new ArrayList<Tuple2<String, T>>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(path));
            String line = reader.readLine();
            while (line != null) {
                res.add(new Tuple2((Object)MapDocumentUtil.getJPathString((String)"$.id", (String)line), new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(line, clazz)));
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res;
    }
}

