/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup;

import eu.dnetlib.dhp.schema.oaf.Field;
import java.time.Year;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DatePicker {
    public static final String DATE_PATTERN = "^(\\d{4})-(\\d{2})-(\\d{2})";
    private static final String DATE_DEFAULT_SUFFIX = "01-01";
    private static final int YEAR_LB = 1300;
    private static final int YEAR_UB = Year.now().getValue() + 5;

    private DatePicker() {
    }

    public static Field<String> pick(Collection<String> dateofacceptance) {
        Map frequencies = dateofacceptance.parallelStream().filter(StringUtils::isNotBlank).map(d -> StringUtils.substringBefore((String)d, (String)"T")).collect(Collectors.toConcurrentMap(w -> w, w -> 1, Integer::sum));
        if (frequencies.isEmpty()) {
            return new Field();
        }
        Field date = new Field();
        date.setValue(frequencies.keySet().iterator().next());
        Map sorted = frequencies.entrySet().stream().filter(d -> StringUtils.isNotBlank((CharSequence)((CharSequence)d.getKey()))).filter(d -> ((String)d.getKey()).matches(DATE_PATTERN)).filter(d -> DatePicker.inRange((String)d.getKey())).sorted(Collections.reverseOrder(Map.Entry.comparingByValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e2, LinkedHashMap::new));
        if (sorted.size() == 0) {
            return date;
        }
        if (sorted.size() >= 3) {
            int acceptThreshold = sorted.size() / 3 + 1;
            List accepted = sorted.entrySet().stream().filter(e -> (Integer)e.getValue() >= acceptThreshold).map(Map.Entry::getKey).collect(Collectors.toList());
            if (accepted.isEmpty()) {
                int max = (Integer)sorted.values().iterator().next();
                Optional<String> first = sorted.entrySet().stream().filter(e -> (Integer)e.getValue() == max && !StringUtils.endsWith((CharSequence)((CharSequence)e.getKey()), (CharSequence)DATE_DEFAULT_SUFFIX)).map(Map.Entry::getKey).findFirst();
                if (first.isPresent()) {
                    date.setValue((Object)first.get());
                    return date;
                }
                date.setValue(sorted.keySet().iterator().next());
                return date;
            }
            if (accepted.size() == 1) {
                date.setValue(accepted.get(0));
                return date;
            }
            Optional<String> first = accepted.stream().filter(d -> !StringUtils.endsWith((CharSequence)d, (CharSequence)DATE_DEFAULT_SUFFIX)).findFirst();
            if (first.isPresent()) {
                date.setValue((Object)first.get());
                return date;
            }
            return date;
        }
        if (sorted.size() == 2) {
            for (Map.Entry e3 : sorted.entrySet()) {
                if (StringUtils.endsWith((CharSequence)((CharSequence)e3.getKey()), (CharSequence)DATE_DEFAULT_SUFFIX)) continue;
                date.setValue(e3.getKey());
                return date;
            }
        }
        date.setValue(sorted.keySet().iterator().next());
        return date;
    }

    public static boolean inRange(String date) {
        int year = Integer.parseInt(StringUtils.substringBefore((String)date, (String)"-"));
        return year >= 1300 && year <= YEAR_UB;
    }
}

