/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.common.collection;

import eu.dnetlib.dhp.common.aggregation.AggregatorReport;
import eu.dnetlib.dhp.common.collection.CollectorException;
import eu.dnetlib.dhp.common.collection.HttpClientParams;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnector2 {
    private static final Logger log = LoggerFactory.getLogger(HttpConnector2.class);
    private static final String REPORT_PREFIX = "http:";
    private HttpClientParams clientParams;
    private String responseType = null;
    private static final String userAgent = "Mozilla/5.0 (compatible; OAI; +http://www.openaire.eu)";

    public HttpConnector2() {
        this(new HttpClientParams());
    }

    public HttpConnector2(HttpClientParams clientParams) {
        this.clientParams = clientParams;
        CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
    }

    public InputStream getInputSourceAsStream(String requestUrl) throws CollectorException {
        return IOUtils.toInputStream((String)this.getInputSource(requestUrl));
    }

    public String getInputSource(String requestUrl) throws CollectorException {
        return this.attemptDownloadAsString(requestUrl, 1, new AggregatorReport());
    }

    public InputStream getInputSourceAsBinary(String requestUrl) throws CollectorException, IOException {
        return this.attemptDownload(requestUrl, 1, new AggregatorReport());
    }

    public String getInputSource(String requestUrl, AggregatorReport report) throws CollectorException {
        return this.attemptDownloadAsString(requestUrl, 1, report);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String attemptDownloadAsString(String requestUrl, int retryNumber, AggregatorReport report) throws CollectorException {
        try (InputStream s = this.attemptDownload(requestUrl, retryNumber, report);){
            String string = IOUtils.toString((InputStream)s);
            return string;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new CollectorException(e);
        }
    }

    private InputStream attemptDownload(String requestUrl, int retryNumber, AggregatorReport report) throws CollectorException, IOException {
        if (retryNumber > this.getClientParams().getMaxNumberOfRetry()) {
            String msg = String.format("Max number of retries (%s/%s) exceeded, failing.", retryNumber, this.getClientParams().getMaxNumberOfRetry());
            log.error(msg);
            throw new CollectorException(msg);
        }
        Object input = null;
        long start = System.currentTimeMillis();
        try {
            if (this.getClientParams().getRequestDelay() > 0) {
                this.backoffAndSleep(this.getClientParams().getRequestDelay());
            }
            log.info("Request attempt {} [{}]", (Object)retryNumber, (Object)requestUrl);
            HttpURLConnection urlConn = (HttpURLConnection)new URL(requestUrl).openConnection();
            urlConn.setInstanceFollowRedirects(false);
            urlConn.setReadTimeout(this.getClientParams().getReadTimeOut() * 1000);
            urlConn.setConnectTimeout(this.getClientParams().getConnectTimeOut() * 1000);
            urlConn.addRequestProperty("User-Agent", userAgent);
            urlConn.setRequestMethod(this.getClientParams().getRequestMethod());
            if (!this.getClientParams().getHeaders().isEmpty()) {
                for (Map.Entry<String, String> headerEntry : this.getClientParams().getHeaders().entrySet()) {
                    urlConn.addRequestProperty(headerEntry.getKey(), headerEntry.getValue());
                }
            }
            this.logHeaderFields(urlConn);
            int retryAfter = this.obtainRetryAfter(urlConn.getHeaderFields());
            String rateLimit = urlConn.getHeaderField("X-RateLimit-Limit");
            String rateRemaining = urlConn.getHeaderField("X-RateLimit-Remaining");
            if (rateLimit != null && rateRemaining != null && Integer.parseInt(rateRemaining) < 2) {
                if (retryAfter > 0) {
                    this.backoffAndSleep(retryAfter);
                } else {
                    this.backoffAndSleep(1000);
                }
            }
            if (this.is2xx(urlConn.getResponseCode())) {
                return this.getInputStream(urlConn, start);
            }
            if (this.is3xx(urlConn.getResponseCode())) {
                String newUrl = this.obtainNewLocation(urlConn.getHeaderFields());
                log.info("The requested url has been moved to {}", (Object)newUrl);
                report.put(REPORT_PREFIX + urlConn.getResponseCode(), String.format("Moved to: %s", newUrl));
                HttpConnector2.logRequestTime(start);
                urlConn.disconnect();
                if (retryAfter > 0) {
                    this.backoffAndSleep(retryAfter);
                }
                return this.attemptDownload(newUrl, retryNumber + 1, report);
            }
            if (this.is4xx(urlConn.getResponseCode()) || this.is5xx(urlConn.getResponseCode())) {
                switch (urlConn.getResponseCode()) {
                    case 404: 
                    case 502: 
                    case 503: 
                    case 504: {
                        if (retryAfter > 0) {
                            log.warn("waiting and repeating request after suggested retry-after {} sec for URL {}", (Object)retryAfter, (Object)requestUrl);
                            this.backoffAndSleep(retryAfter * 1000);
                        } else {
                            log.warn("waiting and repeating request after default delay of {} sec for URL {}", (Object)this.getClientParams().getRetryDelay(), (Object)requestUrl);
                            this.backoffAndSleep(retryNumber * this.getClientParams().getRetryDelay());
                        }
                        report.put(REPORT_PREFIX + urlConn.getResponseCode(), requestUrl);
                        HttpConnector2.logRequestTime(start);
                        urlConn.disconnect();
                        return this.attemptDownload(requestUrl, retryNumber + 1, report);
                    }
                    case 422: {
                        report.put(REPORT_PREFIX + urlConn.getResponseCode(), requestUrl);
                        log.warn("waiting and repeating request after 10 sec for URL {}", (Object)requestUrl);
                        this.backoffAndSleep(10000);
                        urlConn.disconnect();
                        HttpConnector2.logRequestTime(start);
                        try {
                            return this.getInputStream(urlConn, start);
                        }
                        catch (IOException e) {
                            log.error("server returned 422 and got IOException accessing the response body from URL {}", (Object)requestUrl);
                            log.error("IOException:", (Throwable)e);
                            return this.attemptDownload(requestUrl, retryNumber + 1, report);
                        }
                    }
                }
                log.error("gor error {} from URL: {}", (Object)urlConn.getResponseCode(), (Object)urlConn.getURL());
                log.error("response message: {}", (Object)urlConn.getResponseMessage());
                report.put(REPORT_PREFIX + urlConn.getResponseCode(), String.format("%s Error: %s", requestUrl, urlConn.getResponseMessage()));
                HttpConnector2.logRequestTime(start);
                urlConn.disconnect();
                throw new CollectorException(urlConn.getResponseCode() + " error " + report);
            }
            throw new CollectorException(String.format("Unexpected status code: %s errors: %s", urlConn.getResponseCode(), DHPUtils.MAPPER.writeValueAsString((Object)report)));
        }
        catch (MalformedURLException e) {
            log.error(e.getMessage(), (Throwable)e);
            report.put(e.getClass().getName(), e.getMessage());
            throw new CollectorException(e.getMessage(), e);
        }
        catch (SocketException | SocketTimeoutException | UnknownHostException e) {
            log.error(e.getMessage(), (Throwable)e);
            report.put(e.getClass().getName(), e.getMessage());
            this.backoffAndSleep(this.getClientParams().getRetryDelay() * retryNumber * 1000);
            return this.attemptDownload(requestUrl, retryNumber + 1, report);
        }
    }

    private InputStream getInputStream(HttpURLConnection urlConn, long start) throws IOException {
        InputStream input = urlConn.getInputStream();
        this.responseType = urlConn.getContentType();
        HttpConnector2.logRequestTime(start);
        return input;
    }

    private static void logRequestTime(long start) {
        log.info("request time elapsed: {}sec", (Object)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - start));
    }

    private void logHeaderFields(HttpURLConnection urlConn) throws IOException {
        log.info("Response: {} - {}", (Object)urlConn.getResponseCode(), (Object)urlConn.getResponseMessage());
        for (Map.Entry<String, List<String>> e : urlConn.getHeaderFields().entrySet()) {
            if (e.getKey() == null) continue;
            for (String v : e.getValue()) {
                log.info("  key: {} - value: {}", (Object)e.getKey(), (Object)v);
            }
        }
    }

    private void backoffAndSleep(int sleepTimeMs) throws CollectorException {
        log.info("I'm going to sleep for {}ms", (Object)sleepTimeMs);
        try {
            Thread.sleep(sleepTimeMs);
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new CollectorException(e);
        }
    }

    private int obtainRetryAfter(Map<String, List<String>> headerMap) {
        for (String key : headerMap.keySet()) {
            if (key == null || !key.equalsIgnoreCase("Retry-After") || headerMap.get(key).isEmpty() || !NumberUtils.isCreatable((String)headerMap.get(key).get(0))) continue;
            return Integer.parseInt(headerMap.get(key).get(0));
        }
        return -1;
    }

    private String obtainNewLocation(Map<String, List<String>> headerMap) throws CollectorException {
        for (String key : headerMap.keySet()) {
            if (key == null || !key.equalsIgnoreCase("Location") || headerMap.get(key).size() <= 0) continue;
            return headerMap.get(key).get(0);
        }
        throw new CollectorException("The requested url has been MOVED, but 'location' param is MISSING");
    }

    private boolean is2xx(int statusCode) {
        return statusCode >= 200 && statusCode <= 299;
    }

    private boolean is4xx(int statusCode) {
        return statusCode >= 400 && statusCode <= 499;
    }

    private boolean is3xx(int statusCode) {
        return statusCode >= 300 && statusCode <= 399;
    }

    private boolean is5xx(int statusCode) {
        return statusCode >= 500 && statusCode <= 599;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public HttpClientParams getClientParams() {
        return this.clientParams;
    }

    public void setClientParams(HttpClientParams clientParams) {
        this.clientParams = clientParams;
    }
}

