/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.common.vocabulary;

import eu.dnetlib.dhp.common.vocabulary.Vocabulary;
import eu.dnetlib.dhp.common.vocabulary.VocabularyTerm;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.utils.OafMapperUtils;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class VocabularyGroup
implements Serializable {
    public static final String VOCABULARIES_XQUERY = "for $x in collection('/db/DRIVER/VocabularyDSResources/VocabularyDSResourceType') \nlet $vocid := $x//VOCABULARY_NAME/@code\nlet $vocname := $x//VOCABULARY_NAME/text()\nfor $term in ($x//TERM)\nreturn concat($vocid,' @=@ ',$vocname,' @=@ ',$term/@code,' @=@ ',$term/@english_name)";
    public static final String VOCABULARY_SYNONYMS_XQUERY = "for $x in collection('/db/DRIVER/VocabularyDSResources/VocabularyDSResourceType')\nlet $vocid := $x//VOCABULARY_NAME/@code\nlet $vocname := $x//VOCABULARY_NAME/text()\nfor $term in ($x//TERM)\nfor $syn in ($term//SYNONYM/@term)\nreturn concat($vocid,' @=@ ',$term/@code,' @=@ ', $syn)\n";
    private final Map<String, Vocabulary> vocs = new HashMap<String, Vocabulary>();

    public static VocabularyGroup loadVocsFromIS(ISLookUpService isLookUpService) throws ISLookUpException {
        String vocId;
        String[] arr;
        VocabularyGroup vocs = new VocabularyGroup();
        for (String s : isLookUpService.quickSearchProfile(VOCABULARIES_XQUERY)) {
            arr = s.split("@=@");
            if (arr.length != 4) continue;
            vocId = arr[0].trim();
            String vocName = arr[1].trim();
            String termId = arr[2].trim();
            String termName = arr[3].trim();
            if (!vocs.vocabularyExists(vocId)) {
                vocs.addVocabulary(vocId, vocName);
            }
            vocs.addTerm(vocId, termId, termName);
        }
        for (String s : isLookUpService.quickSearchProfile(VOCABULARY_SYNONYMS_XQUERY)) {
            arr = s.split("@=@");
            if (arr.length != 3) continue;
            vocId = arr[0].trim();
            String termId = arr[1].trim();
            String syn = arr[2].trim();
            vocs.addSynonyms(vocId, termId, syn);
        }
        vocs.vocs.values().forEach(voc -> voc.getTerms().values().forEach(term -> voc.addSynonym(term.getName().toLowerCase(), term.getId())));
        return vocs;
    }

    public Set<String> vocabularyNames() {
        return this.vocs.keySet();
    }

    public void addVocabulary(String id, String name) {
        this.vocs.put(id.toLowerCase(), new Vocabulary(id, name));
    }

    public Optional<Vocabulary> find(String vocId) {
        return Optional.ofNullable(vocId).map(String::toLowerCase).map(this.vocs::get);
    }

    public void addTerm(String vocId, String id, String name) {
        if (this.vocabularyExists(vocId)) {
            this.vocs.get(vocId.toLowerCase()).addTerm(id, name);
        }
    }

    public VocabularyTerm getTerm(String vocId, String id) {
        if (this.termExists(vocId, id)) {
            return this.vocs.get(vocId.toLowerCase()).getTerm(id);
        }
        return new VocabularyTerm(id, id);
    }

    public Set<String> getTerms(String vocId) {
        if (!this.vocabularyExists(vocId)) {
            return new HashSet<String>();
        }
        return this.vocs.get(vocId.toLowerCase()).getTerms().values().stream().map(VocabularyTerm::getId).collect(Collectors.toCollection(HashSet::new));
    }

    public Qualifier lookup(String vocId, String id) {
        return Optional.ofNullable(this.getSynonymAsQualifier(vocId, id)).orElse(this.getTermAsQualifier(vocId, id));
    }

    public Qualifier getTermAsQualifier(String vocId, String id) {
        if (this.vocabularyExists(vocId)) {
            return this.vocs.get(vocId.toLowerCase()).getTermAsQualifier(id);
        }
        return OafMapperUtils.qualifier(id, id, "", "");
    }

    public Qualifier getSynonymAsQualifier(String vocId, String syn) {
        if (StringUtils.isBlank((CharSequence)vocId)) {
            return OafMapperUtils.unknown("", "");
        }
        return this.vocs.get(vocId.toLowerCase()).getSynonymAsQualifier(syn);
    }

    public Qualifier lookupTermBySynonym(String vocId, String syn) {
        return this.find(vocId).map(vocabulary -> Optional.ofNullable(vocabulary.getTerm(syn)).map(term -> OafMapperUtils.qualifier(term.getId(), term.getName(), vocabulary.getId(), vocabulary.getName())).orElse(Optional.ofNullable(vocabulary.getTermBySynonym(syn)).map(term -> OafMapperUtils.qualifier(term.getId(), term.getName(), vocabulary.getId(), vocabulary.getName())).orElse(null))).orElse(null);
    }

    public Qualifier getSynonymAsQualifierCaseSensitive(String vocId, String syn) {
        if (StringUtils.isBlank((CharSequence)vocId)) {
            return OafMapperUtils.unknown("", "");
        }
        return this.vocs.get(vocId).getSynonymAsQualifier(syn);
    }

    public boolean termExists(String vocId, String id) {
        return this.termExists(vocId, id, Boolean.FALSE);
    }

    public boolean termExists(String vocId, String id, Boolean caseSensitive) {
        if (Boolean.TRUE.equals(caseSensitive)) {
            return this.vocabularyExists(vocId) && this.vocs.get(vocId).termExists(id);
        }
        return this.vocabularyExists(vocId) && this.vocs.get(vocId.toLowerCase()).termExists(id);
    }

    public boolean vocabularyExists(String vocId) {
        return Optional.ofNullable(vocId).map(String::toLowerCase).map(this.vocs::containsKey).orElse(false);
    }

    private void addSynonyms(String vocId, String termId, String syn) {
        String id = Optional.ofNullable(vocId).map(String::toLowerCase).orElseThrow(() -> new IllegalArgumentException(String.format("empty vocabulary id for [term:%s, synonym:%s]", termId, syn)));
        Optional.ofNullable(this.vocs.get(id)).orElseThrow(() -> new IllegalArgumentException("missing vocabulary id: " + vocId)).addSynonym(syn.toLowerCase(), termId);
    }
}

