/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.broker.oa.controllers;

import eu.dnetlib.broker.common.controllers.AbstractLbsController;
import eu.dnetlib.broker.common.elasticsearch.Notification;
import eu.dnetlib.broker.common.properties.ElasticSearchProperties;
import eu.dnetlib.broker.common.subscriptions.SubscriptionRepository;
import eu.dnetlib.broker.oa.controllers.NotificationMessage;
import eu.dnetlib.broker.oa.controllers.ScrollPage;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchScrollHits;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Profile(value={"openaire"})
@RestController
@RequestMapping(value={"/api/openaireBroker"})
@Api(tags={"OpenAIRE"})
public class OpenairePublicController
extends AbstractLbsController {
    @Autowired
    private ElasticsearchOperations esOperations;
    @Autowired
    private SubscriptionRepository subscriptionRepo;
    @Autowired
    private ElasticSearchProperties props;
    private static final long SCROLL_TIMEOUT_IN_MILLIS = 300000L;
    private static final Log log = LogFactory.getLog(OpenairePublicController.class);

    @ApiOperation(value="Returns notifications by subscription using scrolls (first page)")
    @GetMapping(value={"/scroll/notifications/bySubscriptionId/{subscrId}"})
    public ScrollPage<NotificationMessage> prepareScrollNotificationsBySubscrId(@PathVariable String subscrId) {
        Optional optSub = this.subscriptionRepo.findById((Object)subscrId);
        if (optSub.isPresent()) {
            ElasticsearchRestTemplate esTemplate = (ElasticsearchRestTemplate)this.esOperations;
            NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.matchQuery((String)"subscriptionId", (Object)subscrId)).withSearchType(SearchType.DEFAULT).withFields(new String[]{"payload"}).build();
            SearchScrollHits scroll = esTemplate.searchScrollStart(300000L, (Query)searchQuery, Notification.class, IndexCoordinates.of((String[])new String[]{this.props.getNotificationsIndexName()}));
            if (scroll.hasSearchHits()) {
                List values = this.calculateNotificationMessages(scroll);
                return new ScrollPage(scroll.getScrollId(), values.isEmpty() || scroll.getScrollId() == null, values);
            }
            esTemplate.searchScrollClear(Arrays.asList(scroll.getScrollId()));
            return new ScrollPage(null, true, new ArrayList());
        }
        log.warn((Object)("Invalid subscription: " + subscrId));
        return new ScrollPage();
    }

    @ApiOperation(value="Returns notifications by opendorar Id (for example: 301) using scrolls (first page)")
    @GetMapping(value={"/scroll/notifications/byOpenDoarId/{opendoarId}"})
    public ScrollPage<NotificationMessage> prepareScrollNotificationsByOpendoarId(@PathVariable String opendoarId) {
        ElasticsearchRestTemplate esTemplate = (ElasticsearchRestTemplate)this.esOperations;
        String dsId = this.calculateDsIdFromOpenDoarId(opendoarId);
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.nestedQuery((String)"map", (QueryBuilder)QueryBuilders.matchQuery((String)"map.targetDatasourceId", (Object)dsId), (ScoreMode)ScoreMode.None)).withSearchType(SearchType.DEFAULT).withFields(new String[]{"payload"}).build();
        SearchScrollHits scroll = esTemplate.searchScrollStart(300000L, (Query)searchQuery, Notification.class, IndexCoordinates.of((String[])new String[]{this.props.getNotificationsIndexName()}));
        if (scroll.hasSearchHits()) {
            List values = this.calculateNotificationMessages(scroll);
            return new ScrollPage(scroll.getScrollId(), values.isEmpty() || scroll.getScrollId() == null, values);
        }
        esTemplate.searchScrollClear(Arrays.asList(scroll.getScrollId()));
        return new ScrollPage(null, true, new ArrayList());
    }

    private String calculateDsIdFromOpenDoarId(String opendoarId) {
        return "10|opendoar____::" + DigestUtils.md5Hex((String)opendoarId);
    }

    @ApiOperation(value="Returns notifications using scrolls (other pages)")
    @GetMapping(value={"/scroll/notifications/{scrollId}"})
    public ScrollPage<NotificationMessage> scrollNotifications(@PathVariable String scrollId) {
        ElasticsearchRestTemplate esTemplate = (ElasticsearchRestTemplate)this.esOperations;
        SearchScrollHits scroll = esTemplate.searchScrollContinue(scrollId, 300000L, Notification.class, IndexCoordinates.of((String[])new String[]{this.props.getNotificationsIndexName()}));
        if (scroll.hasSearchHits()) {
            List values = this.calculateNotificationMessages(scroll);
            return new ScrollPage(scroll.getScrollId(), values.isEmpty() || scroll.getScrollId() == null, values);
        }
        esTemplate.searchScrollClear(Arrays.asList(scroll.getScrollId()));
        return new ScrollPage(null, true, new ArrayList());
    }

    private List<NotificationMessage> calculateNotificationMessages(SearchScrollHits<Notification> scroll) {
        if (scroll.getSearchHits().size() > 0) {
            return scroll.stream().map(SearchHit::getContent).map(NotificationMessage::fromNotification).collect(Collectors.toList());
        }
        return new ArrayList<NotificationMessage>();
    }
}

